/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.DeploymentConfigurationFactory;
import com.sun.jbi.management.config.InstallationConfigurationFactory;
import com.sun.jbi.management.config.LoggerConfigurationFactory;
import com.sun.jbi.management.config.SystemConfigurationFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigurationBuilder {
    private static HashMap<MBeanNames.ServiceType, ConfigurationFactory> sConfigs;

    public static synchronized Map<MBeanNames.ServiceType, ConfigurationFactory> createConfigurations(Properties defaults) {
        if (sConfigs == null) {
            sConfigs = new HashMap();
            sConfigs.put(MBeanNames.ServiceType.Installation, new InstallationConfigurationFactory(defaults));
            sConfigs.put(MBeanNames.ServiceType.Deployment, new DeploymentConfigurationFactory(defaults));
            sConfigs.put(MBeanNames.ServiceType.System, new SystemConfigurationFactory(defaults));
            sConfigs.put(MBeanNames.ServiceType.Logger, new LoggerConfigurationFactory(defaults));
        }
        return sConfigs;
    }

    public static String getControlType(MBeanNames.ServiceType svcType) {
        String controlType = "System";
        switch (svcType) {
            case Installation: {
                controlType = "InstallationService";
                break;
            }
            case Deployment: {
                controlType = "DeploymentService";
                break;
            }
            case System: {
                controlType = "System";
                break;
            }
            case Logger: {
                controlType = "LoggingService";
            }
        }
        return controlType;
    }
}

