/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;

public class ServiceUnit
implements ServiceUnitInfo {
    private String mName;
    private String mFilePath;
    private String mSaName;
    private ServiceUnitState mState;
    private ServiceUnitState mDesiredState;
    private transient StringTranslator mTranslator = (StringTranslator)EnvironmentContext.getInstance().getStringTranslatorFor(this);
    private String mTargetComponent;

    public ServiceUnit(String saName, String name, String filePath) {
        this.mSaName = saName;
        this.mName = name;
        this.mFilePath = filePath;
        this.mState = ServiceUnitState.SHUTDOWN;
        this.mDesiredState = ServiceUnitState.SHUTDOWN;
    }

    public ServiceUnit(String saName, String name, String filePath, String targetComp) {
        this.mSaName = saName;
        this.mName = name;
        this.mFilePath = filePath;
        this.mState = ServiceUnitState.SHUTDOWN;
        this.mDesiredState = ServiceUnitState.SHUTDOWN;
        this.mTargetComponent = targetComp;
    }

    public ServiceUnit(ServiceUnitInfo suInfo) {
        this.mSaName = suInfo.getServiceAssemblyName();
        this.mName = suInfo.getName();
        this.mFilePath = suInfo.getFilePath();
        this.mState = ServiceUnitState.SHUTDOWN;
        this.mDesiredState = suInfo.getState();
        this.mTargetComponent = suInfo.getTargetComponent();
    }

    @Override
    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof ServiceUnit)) {
            return false;
        }
        ServiceUnit su = (ServiceUnit)object;
        if (!this.mSaName.equals(su.getServiceAssemblyName())) {
            return false;
        }
        if (!this.mName.equals(su.getName())) {
            return false;
        }
        return this.mFilePath.equals(su.getFilePath());
    }

    public ServiceUnitState getDesiredState() {
        return this.mDesiredState;
    }

    @Override
    public String getFilePath() {
        return this.mFilePath;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getServiceAssemblyName() {
        return this.mSaName;
    }

    @Override
    public ServiceUnitState getState() {
        return this.mState;
    }

    @Override
    public String getStateAsString() {
        return this.mState.toString();
    }

    public String getStateAsString(ServiceUnitState state) {
        return state.toString();
    }

    @Override
    public String getTargetComponent() {
        return this.mTargetComponent;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += this.mName.hashCode();
        hashCode += this.mSaName.hashCode();
        return hashCode += this.mFilePath.hashCode();
    }

    public boolean isShutdown() {
        return ServiceUnitState.SHUTDOWN == this.mState;
    }

    public boolean isStarted() {
        return ServiceUnitState.STARTED == this.mState;
    }

    public boolean isStopped() {
        return ServiceUnitState.STOPPED == this.mState;
    }

    void setDesiredState(ServiceUnitState state) {
        if (ServiceUnitState.SHUTDOWN != state && ServiceUnitState.STOPPED != state && ServiceUnitState.STARTED != state) {
            throw new IllegalArgumentException(this.mTranslator.getString("INVALID_ARGUMENT", "state", (Object)state));
        }
        this.mDesiredState = state;
    }

    void setState(ServiceUnitState state) {
        this.mState = state;
    }

    public void setShutdown() {
        if (this.isStarted()) {
            throw new IllegalStateException(this.mTranslator.getString("SU_INVALID_STATE_CHANGE", this.mTranslator.getString("SU_STATE_STARTED"), this.mTranslator.getString("SU_STATE_SHUTDOWN")));
        }
        this.mState = ServiceUnitState.SHUTDOWN;
    }

    public void setStarted() {
        if (this.isShutdown()) {
            throw new IllegalStateException(this.mTranslator.getString("SU_INVALID_STATE_CHANGE", this.mTranslator.getString("SU_STATE_SHUTDOWN"), this.mTranslator.getString("SU_STATE_STARTED")));
        }
        this.mState = ServiceUnitState.STARTED;
    }

    public void setStopped() {
        this.mState = ServiceUnitState.STOPPED;
    }

    public void setTargetComponent(String componentName) {
        this.mTargetComponent = componentName;
    }

    public String toString() {
        String sep = new String(",\n");
        StringBuffer b = new StringBuffer();
        b.append("Name = " + this.mName);
        b.append(sep);
        b.append("FilePath = " + this.mFilePath);
        b.append(sep);
        b.append("State = " + this.mState.toString());
        b.append(sep);
        b.append("Desired state = " + this.mDesiredState.toString());
        b.append(sep);
        b.append("Service Assembly name = " + this.mSaName);
        b.append("\n");
        return b.toString();
    }
}

