/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.EventNotifier;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryBuilder;
import com.sun.jbi.management.registry.RegistrySpecImpl;
import com.sun.jbi.management.registry.RegistryType;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.util.jmx.MBeanUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.naming.InitialContext;

public class JBIFramework {
    protected EnvironmentContext mEnvironment;
    private Logger mLog;
    private long mStartupElapsedTime;
    private long mShutdownElapsedTime;
    private StringTranslator mTranslator;
    private boolean mStartFailed;
    private boolean mCfStarted;
    private boolean mCrStarted;
    private boolean mCsStarted;
    private boolean mMsStarted;
    private boolean mNmsStarted;
    private boolean mMrsStarted;
    private static final String TIMESTAMP_REF = "timestamp.ref";
    private boolean mFrameworkReady;
    private boolean mLazyInit;

    public void init(PlatformContext platformContext, Properties initialProperties) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mEnvironment = new EnvironmentContext(platformContext, this, initialProperties);
        this.mEnvironment.setJbiInitTime(startTime);
        MBeanUtils.init(platformContext.getMBeanServer());
        this.mLog = this.mEnvironment.getLogger();
        this.mLog.finest("JBIFramework.init entered");
        this.mTranslator = (StringTranslator)this.mEnvironment.getStringTranslator("com.sun.jbi.framework");
        this.mLog.fine(this.mTranslator.getString("JBI_INITIALIZING"));
        this.initRepository();
        boolean initFailed = false;
        String serviceName = null;
        try {
            serviceName = this.mTranslator.getString("CS_NAME");
            this.mEnvironment.getConfigurationService().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("NMS_NAME");
            this.mEnvironment.getNormalizedMessageService().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("CR_NAME");
            this.mEnvironment.getComponentRegistry().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("CF_NAME");
            this.mEnvironment.getComponentFramework().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("MS_NAME");
            this.mEnvironment.getManagementService().initService(this.mEnvironment);
        }
        catch (Throwable initEx) {
            initFailed = true;
            this.logFailure(serviceName, initEx, "INIT_SERVICE_FAILED");
        }
        if (initFailed) {
            String msg = this.mTranslator.getString("INIT_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mLog.fine(this.mTranslator.getString("JBI_INITIALIZED"));
        this.mLog.finest("JBIFramework.init exited");
        this.mStartupElapsedTime = System.currentTimeMillis() - startTime;
    }

    public void startup(InitialContext context, String namingprefix) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.startup entered");
        this.mLog.fine(this.mTranslator.getString("JBI_STARTING"));
        this.mEnvironment.setNamingContext(context);
        this.mEnvironment.setNamingPrefix(namingprefix);
        try {
            this.removeStoppedStateFile();
            this.mEnvironment.getMgmtRuntimeService().initService(this.mEnvironment);
            this.createStartedStateFile();
            ((EventNotifier)this.mEnvironment.getNotifier()).instanceStarting();
        }
        catch (Throwable mrsEx) {
            this.mStartFailed = true;
            this.logFailure(this.mTranslator.getString("MRS_NAME"), mrsEx, "INIT_SERVICE_FAILED");
        }
        if (this.mStartFailed) {
            String msg = this.mTranslator.getString("START_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mEnvironment.createLoggerMBeans();
        PlatformContext platform = this.mEnvironment.getPlatformContext();
        String instanceName = platform.getInstanceName();
        System.setProperty("com.sun.jbi.instanceName", instanceName);
        this.mLog.log(Level.FINE, "set system property com.sun.jbi.instanceName to {0}", instanceName);
        Boolean clustered = platform.isInstanceClustered(instanceName);
        System.setProperty("com.sun.jbi.isClustered", clustered.toString());
        this.mLog.log(Level.FINE, "set system property com.sun.jbi.isClustered to {0}", clustered.toString());
        if (clustered.booleanValue()) {
            String clusterName = platform.getTargetName();
            System.setProperty("com.sun.jbi.clusterName", clusterName);
            this.mLog.log(Level.FINE, "set system property com.sun.jbi.clusterName to {0}", clusterName);
        }
        String readyMsg = this.mTranslator.getString("JBI_READY");
        this.mLog.info(readyMsg);
        this.mEnvironment.getNotifier().emitRuntimeNotification(EventNotifierBase.EventType.Ready, readyMsg);
        this.mLog.finest("JBIFramework.startup exited");
        this.mStartupElapsedTime += System.currentTimeMillis() - startTime;
        this.setStartupTime();
    }

    public void prepare() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.prepare entered");
        try {
            ManagementContext mgmtCtx = this.mEnvironment.getManagementService().getManagementContext();
            mgmtCtx.getRepository().cleanRepository();
            this.mEnvironment.getComponentRegistry().startService();
            this.mCrStarted = true;
        }
        catch (Throwable crEx) {
            this.mStartFailed = true;
            this.logFailure(this.mTranslator.getString("CR_NAME"), crEx, "START_SERVICE_FAILED");
            String msg = this.mTranslator.getString("INIT_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mEnvironment.getComponentFramework().prepare();
        this.mLog.finest("JBIFramework.prepare exited");
        this.mStartupElapsedTime += System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(boolean wait) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.ready entered");
        if (this.mStartFailed) {
            return;
        }
        String serviceName = null;
        try {
            serviceName = this.mTranslator.getString("CS_NAME");
            this.mEnvironment.getConfigurationService().startService();
            this.mCsStarted = true;
            serviceName = this.mTranslator.getString("NMS_NAME");
            this.mEnvironment.getNormalizedMessageService().startService();
            this.mNmsStarted = true;
            serviceName = this.mTranslator.getString("CF_NAME");
            this.mEnvironment.getComponentFramework().startService();
            this.mCfStarted = true;
            serviceName = this.mTranslator.getString("MS_NAME");
            this.mEnvironment.getManagementService().startService();
            this.mMsStarted = true;
            serviceName = this.mTranslator.getString("MRS_NAME");
            this.mEnvironment.getMgmtRuntimeService().startService();
            this.mMrsStarted = true;
        }
        catch (Throwable startEx) {
            this.mStartFailed = true;
            this.logFailure(serviceName, startEx, "START_SERVICE_FAILED");
        }
        if (this.mStartFailed) {
            String msg = this.mTranslator.getString("START_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mEnvironment.getComponentFramework().ready(wait);
        JBIFramework msg = this;
        synchronized (msg) {
            this.mFrameworkReady = true;
            this.notifyAll();
        }
        this.mStartupElapsedTime += System.currentTimeMillis() - startTime;
        this.mLog.fine(this.mTranslator.getString("JBI_STARTUP_TIME", this.getStartupTime()));
        this.setStartupTime();
        this.mEnvironment.getFrameworkStatistics().setLastRestartTime(new Date());
        String startedMsg = this.mTranslator.getString("JBI_STARTED");
        this.mLog.info(startedMsg);
        this.mEnvironment.getNotifier().emitRuntimeNotification(EventNotifierBase.EventType.Started, startedMsg);
        this.mLog.finest("JBIFramework.ready exited");
    }

    public long getStartupTime() {
        return this.mStartupElapsedTime;
    }

    public void setStartupTime() {
        this.mEnvironment.getFrameworkStatistics().setStartupTime(this.getStartupTime());
    }

    public void shutdown() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.shutdown entered");
        this.mLog.fine(this.mTranslator.getString("JBI_SHUTTING_DOWN"));
        boolean errors = false;
        String shutMsg = this.mTranslator.getString("JBI_SHUT_DOWN");
        EventNotifier notifier = (EventNotifier)this.mEnvironment.getNotifier();
        notifier.emitRuntimeNotification(EventNotifierBase.EventType.Stopped, shutMsg);
        if (this.mMrsStarted) {
            try {
                this.removeStartedStateFile();
                this.mEnvironment.getMgmtRuntimeService().stopService();
                this.mMrsStarted = false;
            }
            catch (Throwable mrsEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("MRS_NAME"), mrsEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCfStarted) {
            try {
                this.mEnvironment.getComponentFramework().stopService();
                this.mCfStarted = false;
            }
            catch (Throwable cfEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CF_NAME"), cfEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCrStarted) {
            try {
                this.mEnvironment.getComponentRegistry().stopService();
                this.mCrStarted = false;
            }
            catch (Throwable crEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CR_NAME"), crEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mNmsStarted) {
            try {
                this.mEnvironment.getNormalizedMessageService().stopService();
                this.mNmsStarted = false;
            }
            catch (Throwable nmsEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("NMS_NAME"), nmsEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mMsStarted) {
            try {
                this.mEnvironment.getManagementService().stopService();
                this.mMsStarted = false;
            }
            catch (Throwable msEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("MS_NAME"), msEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCsStarted) {
            try {
                this.mEnvironment.getConfigurationService().stopService();
                this.mCsStarted = false;
            }
            catch (Throwable msEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CS_NAME"), msEx, "STOP_SERVICE_FAILED");
            }
        }
        if (!errors) {
            this.mLog.fine(shutMsg);
        } else {
            this.mLog.warning(this.mTranslator.getString("STOP_FRAMEWORK_FAILED"));
        }
        notifier.instanceStopping();
        this.createStoppedStateFile();
        this.mLog.finest("JBIFramework.shutdown exited");
        this.mShutdownElapsedTime += System.currentTimeMillis() - startTime;
    }

    public void terminate() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.terminate entered");
        this.mLog.fine(this.mTranslator.getString("JBI_TERMINATING"));
        this.mEnvironment.destroyInstance();
        this.mLog.info(this.mTranslator.getString("JBI_TERMINATED"));
        this.mLog.finest("JBIFramework.terminate exited");
        this.mShutdownElapsedTime += System.currentTimeMillis() - startTime;
        this.mLog.fine(this.mTranslator.getString("JBI_SHUTDOWN_TIME", this.mShutdownElapsedTime));
    }

    public EnvironmentContext getEnvironment() {
        return this.mEnvironment;
    }

    public synchronized void enterLazyMode() {
        this.mLog.fine("JBIFramework: Enter lazy mode...");
        this.mLazyInit = true;
        this.notifyAll();
    }

    public synchronized void frameworkReady() throws RuntimeException {
        while (!this.mFrameworkReady) {
            if (this.mLazyInit) {
                try {
                    this.mLog.fine("JBIFramework: Transition to ready...");
                    this.prepare();
                    this.ready(true);
                    continue;
                }
                catch (Throwable ex) {
                    this.mFrameworkReady = false;
                    this.mLog.log(Level.FINE, "Exception occurred making the runtime ready", ex);
                    throw new RuntimeException(ex.toString());
                }
                finally {
                    this.notifyAll();
                    continue;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized boolean isFrameworkReady() {
        return this.mFrameworkReady;
    }

    synchronized void setFrameworkReady() {
        this.mFrameworkReady = true;
    }

    private void logWarning(Throwable ex, String msgKey) {
        String msg = ex.getMessage();
        msg = null != msg ? msg : this.mTranslator.getString("NO_MESSAGE");
        this.mLog.log(Level.WARNING, this.mTranslator.getString(msgKey, ex.getClass().getName(), msg), ex);
    }

    private void logFailure(String service, Throwable ex, String msgKey) {
        String msg = ex.getMessage();
        msg = null != msg ? msg : this.mTranslator.getString("NO_MESSAGE");
        this.mLog.log(Level.SEVERE, this.mTranslator.getString(msgKey, service, ex.getClass().getName(), msg), ex);
    }

    private void setRepositoryInitTime(Repository repository) {
        String tmpString = this.mEnvironment.getJbiInstanceRoot() + File.separator + "tmp";
        File tmpDir = new File(tmpString);
        try {
            File tsRefFile;
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            if ((tsRefFile = new File(tmpString + File.separator + TIMESTAMP_REF)).exists()) {
                tsRefFile.delete();
            }
            tsRefFile.createNewFile();
            repository.setRepositoryInitTime(tsRefFile.lastModified());
        }
        catch (IOException ioEx) {
            repository.setRepositoryInitTime(System.currentTimeMillis());
            this.logWarning(ioEx, "JBI_REPOSITORY_TIMESTAMP_WARNING");
        }
    }

    Registry initRegistry() throws JBIException {
        Registry registry = null;
        String regFolder = this.mEnvironment.getJbiInstanceRoot() + File.separator + "config";
        Properties props = new Properties();
        props.setProperty("com.sun.jbi.registry.folder", regFolder);
        ManagementContext mgmtCtx = new ManagementContext(this.mEnvironment);
        registry = RegistryBuilder.buildRegistry(new RegistrySpecImpl(RegistryType.XML, props, mgmtCtx));
        return registry;
    }

    private void initRepository() throws JBIException {
        ManagementContext mgmtCtx = new ManagementContext(this.mEnvironment);
        Repository repository = null;
        try {
            repository = new Repository(mgmtCtx);
            this.setRepositoryInitTime(repository);
            mgmtCtx.setRepository(repository);
        }
        catch (RepositoryException repEx) {
            throw new JBIException((Throwable)((Object)repEx));
        }
    }

    private void createStoppedStateFile() {
        String parentDir = this.mEnvironment.getJbiInstanceRoot() + File.separator + "tmp";
        this.removeStartedStateFile();
        File adminStoppedFile = new File(parentDir, ".jbi_admin_stopped");
        try {
            adminStoppedFile.createNewFile();
        }
        catch (IOException ioex) {
            String errMsg = this.mTranslator.getString("JBI_STATE_FILE_CREATION_FAILED", ".jbi_admin_stopped", ioex.getClass().getName(), ioex.getMessage());
            this.mLog.log(Level.FINE, errMsg, ioex);
        }
    }

    private void removeStartedStateFile() {
        String parentDir = this.mEnvironment.getJbiInstanceRoot() + File.separator + "tmp";
        File adminStartedFile = new File(parentDir, ".jbi_admin_running");
        if (adminStartedFile.exists()) {
            adminStartedFile.delete();
        }
    }

    private void createStartedStateFile() {
        String parentDir = this.mEnvironment.getJbiInstanceRoot() + File.separator + "tmp";
        this.removeStoppedStateFile();
        File adminStartedFile = new File(parentDir, ".jbi_admin_running");
        try {
            adminStartedFile.createNewFile();
        }
        catch (IOException ioex) {
            String errMsg = this.mTranslator.getString("JBI_STATE_FILE_CREATION_FAILED", ".jbi_admin_running", ioex.getClass().getName(), ioex.getMessage());
            this.mLog.log(Level.FINE, errMsg, ioex);
        }
    }

    private void removeStoppedStateFile() {
        String parentDir = this.mEnvironment.getJbiInstanceRoot() + File.separator + "tmp";
        File adminStoppedFile = new File(parentDir, ".jbi_admin_stopped");
        if (adminStoppedFile.exists()) {
            adminStoppedFile.delete();
        }
    }
}

