/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentRegistry;
import com.sun.jbi.framework.ComponentStatistics;
import com.sun.jbi.framework.DeployerMBean;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.OperationCounter;
import com.sun.jbi.framework.ServiceUnit;
import com.sun.jbi.framework.ServiceUnitOperation;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;

public class Deployer
implements DeployerMBean {
    private Component mComponent;
    private ComponentRegistry mComponentRegistry;
    private ComponentStatistics mComponentStatistics;
    private EnvironmentContext mEnv;
    private Logger mLog;
    private ServiceUnitManager mSuMgr;
    private StringTranslator mTranslator;

    Deployer(Component component) {
        this.mComponent = component;
        this.mComponentStatistics = component.getStatisticsInstance();
        this.mEnv = EnvironmentContext.getInstance();
        this.mComponentRegistry = this.mEnv.getComponentRegistry();
        this.mLog = this.mEnv.getLogger();
        this.mSuMgr = null;
        this.mTranslator = this.mEnv.getStringTranslatorFor(this);
    }

    @Override
    public String deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("deploy", msg));
        }
        if (null == serviceUnitRootPath) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitRootPath");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("deploy", msg));
        }
        if (this.mComponent.isServiceUnitRegistered(serviceUnitName)) {
            String msg = this.mTranslator.getString("DMB_SU_ALREADY_DEPLOYED", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("deploy", msg));
        }
        this.checkComponentState(serviceUnitName, "deploy");
        if (this.statisticsEnabled()) {
            this.mComponentStatistics.incrementDeploySURequests();
        }
        this.mLog.log(Level.FINER, "Calling deploy() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
        String status = this.performOperation(1, this.mEnv.getDeploymentTimeout(), "deploy", serviceUnitName, serviceUnitRootPath);
        if (this.statisticsEnabled()) {
            this.mComponentStatistics.incrementDeployedSUs();
        }
        return status;
    }

    @Override
    public String[] getDeployments() {
        List<ServiceUnitInfo> sus = this.mComponent.getServiceUnitList();
        int suCount = sus.size();
        String[] names = new String[suCount];
        if (0 < suCount) {
            for (int i = 0; i < suCount; ++i) {
                names[i] = ((ServiceUnit)sus.get(i)).getName();
            }
        }
        return names;
    }

    @Override
    public ServiceUnitState getServiceUnitState(String serviceUnitName) {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("getServiceUnitState", msg));
        }
        ServiceUnit su = this.mComponent.getServiceUnit(serviceUnitName);
        if (null != su) {
            return su.getState();
        }
        return ServiceUnitState.UNKNOWN;
    }

    @Override
    public boolean isDeployed(String serviceUnitName) {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("isDeployed", msg));
        }
        return this.mComponent.isServiceUnitRegistered(serviceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("init", msg));
        }
        if (null == serviceUnitRootPath) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitRootPath");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("init", msg));
        }
        ServiceUnit su = this.mComponent.getServiceUnit(serviceUnitName);
        if (null == su) {
            String msg = this.mTranslator.getString("DMB_SU_NOT_FOUND", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("init", msg));
        }
        this.checkComponentState(serviceUnitName, "init");
        if (su.isStarted()) {
            String msg = this.mTranslator.getString("DMB_SU_CANNOT_INIT_STARTED", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("init", msg));
        }
        try {
            su.setDesiredState(ServiceUnitState.STOPPED);
            if (su.isShutdown()) {
                if (this.statisticsEnabled()) {
                    this.mComponentStatistics.incrementInitSURequests();
                }
                this.mLog.log(Level.FINER, "Calling init() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                this.performOperation(2, this.mEnv.getServiceUnitTimeout(), "init", serviceUnitName, serviceUnitRootPath);
                su.setStopped();
            }
        }
        finally {
            this.persistState(su, "init");
        }
    }

    @Override
    public void shutDown(String serviceUnitName) throws DeploymentException {
        this.shutDown(serviceUnitName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown(String serviceUnitName, boolean force) throws DeploymentException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("shutDown", msg));
        }
        ServiceUnit su = this.mComponent.getServiceUnit(serviceUnitName);
        if (null == su) {
            String msg = this.mTranslator.getString("DMB_SU_NOT_FOUND", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("shutDown", msg));
        }
        this.checkComponentState(serviceUnitName, "shutDown");
        if (su.isStarted() && !force) {
            String msg = this.mTranslator.getString("DMB_SU_CANNOT_SHUT_DOWN_NOT_STOPPED", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("shutDown", msg));
        }
        su.setDesiredState(ServiceUnitState.SHUTDOWN);
        if (su.isStarted()) {
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.incrementStopSURequests();
            }
            try {
                this.mLog.log(Level.FINER, "Calling stop() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                this.performOperation(4, this.mEnv.getServiceUnitTimeout(), "stop", serviceUnitName, null);
            }
            catch (DeploymentException dEx) {
            }
            finally {
                su.setStopped();
            }
        }
        if (su.isStopped()) {
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.incrementShutDownSURequests();
            }
            try {
                this.mLog.log(Level.FINER, "Calling shutDown() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                this.performOperation(5, this.mEnv.getServiceUnitTimeout(), "shutDown", serviceUnitName, null);
                su.setShutdown();
                this.mEnv.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.ShutDown, serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_SHUT_DOWN", serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName()));
            }
            catch (DeploymentException dEx) {
                if (!force) {
                    throw dEx;
                }
                su.setShutdown();
            }
            finally {
                this.persistState(su, "shutDown");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String serviceUnitName) throws DeploymentException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("start", msg));
        }
        ServiceUnit su = this.mComponent.getServiceUnit(serviceUnitName);
        if (null == su) {
            String msg = this.mTranslator.getString("DMB_SU_NOT_FOUND", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("start", msg));
        }
        this.checkComponentState(serviceUnitName, "start");
        if (su.isShutdown()) {
            String msg = this.mTranslator.getString("DMB_SU_CANNOT_START_NOT_INITIALIZED", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("start", msg));
        }
        try {
            su.setDesiredState(ServiceUnitState.STARTED);
            if (su.isStopped()) {
                if (this.statisticsEnabled()) {
                    this.mComponentStatistics.incrementStartSURequests();
                }
                this.mLog.log(Level.FINER, "Calling start() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                this.performOperation(3, this.mEnv.getServiceUnitTimeout(), "start", serviceUnitName, null);
                su.setStarted();
                this.mEnv.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.Started, serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_STARTED", serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName()));
            }
        }
        finally {
            this.persistState(su, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String serviceUnitName) throws DeploymentException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("stop", msg));
        }
        ServiceUnit su = this.mComponent.getServiceUnit(serviceUnitName);
        if (null == su) {
            String msg = this.mTranslator.getString("DMB_SU_NOT_FOUND", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("stop", msg));
        }
        this.checkComponentState(serviceUnitName, "stop");
        if (su.isShutdown()) {
            String msg = this.mTranslator.getString("DMB_SU_CANNOT_STOP_SHUT_DOWN", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("stop", msg));
        }
        try {
            su.setDesiredState(ServiceUnitState.STOPPED);
            if (su.isStarted()) {
                if (this.statisticsEnabled()) {
                    this.mComponentStatistics.incrementStopSURequests();
                }
                this.mLog.log(Level.FINER, "Calling stop() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                this.performOperation(4, this.mEnv.getServiceUnitTimeout(), "stop", serviceUnitName, null);
                su.setStopped();
                this.mEnv.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.Stopped, serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_STOPPED", serviceUnitName, this.mComponent.getName(), su.getServiceAssemblyName()));
            }
        }
        finally {
            this.persistState(su, "stop");
        }
    }

    @Override
    public String undeploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        return this.undeploy(serviceUnitName, serviceUnitRootPath, false);
    }

    @Override
    public String undeploy(String serviceUnitName, String serviceUnitRootPath, boolean force) throws DeploymentException {
        ServiceUnit su;
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("undeploy", msg));
        }
        if (null == serviceUnitRootPath) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitRootPath");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(this.buildMessage("undeploy", msg));
        }
        if (!force) {
            this.checkComponentState(serviceUnitName, "undeploy");
        }
        if (null == (su = this.mComponent.getServiceUnit(serviceUnitName))) {
            String msg = this.mTranslator.getString("DMB_SU_NOT_FOUND", serviceUnitName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("undeploy", msg));
        }
        if (!su.isShutdown()) {
            String msg = this.mTranslator.getString("DMB_SU_CANNOT_UNDEPLOY_NOT_SHUT_DOWN", serviceUnitName, su.getStateAsString());
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage("undeploy", msg));
        }
        String status = "";
        if (!force) {
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.incrementUndeploySURequests();
            }
            this.mLog.log(Level.FINER, "Calling undeploy() for Service Unit {0} on {1} {2}", new Object[]{serviceUnitName, this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
            status = this.performOperation(6, this.mEnv.getDeploymentTimeout(), "undeploy", serviceUnitName, serviceUnitRootPath);
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.decrementDeployedSUs();
            }
        } else {
            if (this.mComponent.isStarted()) {
                if (this.statisticsEnabled()) {
                    this.mComponentStatistics.incrementUndeploySURequests();
                }
                try {
                    this.mLog.log(Level.FINER, "Calling undeploy() for Service Unit {0} on {1} {2}", new Object[]{su.getName(), this.mComponent.getComponentTypeAsString(), this.mComponent.getName()});
                    this.performOperation(6, this.mEnv.getDeploymentTimeout(), "undeploy", serviceUnitName, serviceUnitRootPath);
                }
                catch (DeploymentException dEx) {
                    // empty catch block
                }
            }
            status = this.buildSuccessMessage("undeploy");
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.decrementDeployedSUs();
            }
        }
        return status;
    }

    void setServiceUnitManager(ServiceUnitManager suManager) throws DeploymentException {
        this.mSuMgr = suManager;
    }

    private String buildMessage(String task, String msg) {
        int end = msg.indexOf(":");
        if (0 < end) {
            end = msg.indexOf(" ");
        }
        StringBuffer returnMsg = new StringBuffer();
        returnMsg.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        returnMsg.append("<component-task-result>");
        returnMsg.append("<component-name>");
        returnMsg.append(this.mComponent.getName());
        returnMsg.append("</component-name>");
        returnMsg.append("<component-task-result-details>");
        returnMsg.append("<task-result-details>");
        returnMsg.append("<task-id>");
        returnMsg.append(task);
        returnMsg.append("</task-id>");
        returnMsg.append("<task-result>FAILED</task-result>");
        returnMsg.append("<message-type>ERROR</message-type>");
        returnMsg.append("<task-status-msg>");
        returnMsg.append("<msg-loc-info>");
        returnMsg.append("<loc-token>");
        returnMsg.append(msg.substring(0, end - 1).trim());
        returnMsg.append("</loc-token>");
        returnMsg.append("<loc-message>");
        returnMsg.append(msg.substring(end + 1).trim());
        returnMsg.append("</loc-message>");
        returnMsg.append("</msg-loc-info>");
        returnMsg.append("</task-status-msg>");
        returnMsg.append("</task-result-details>");
        returnMsg.append("</component-task-result-details>");
        returnMsg.append("</component-task-result>");
        return returnMsg.toString();
    }

    private String buildSuccessMessage(String task) {
        StringBuffer returnMsg = new StringBuffer();
        returnMsg.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        returnMsg.append("<component-task-result>");
        returnMsg.append("<component-name>");
        returnMsg.append(this.mComponent.getName());
        returnMsg.append("</component-name>");
        returnMsg.append("<component-task-result-details>");
        returnMsg.append("<task-result-details>");
        returnMsg.append("<task-id>");
        returnMsg.append(task);
        returnMsg.append("</task-id>");
        returnMsg.append("<task-result>SUCCESS</task-result>");
        returnMsg.append("</task-result-details>");
        returnMsg.append("</component-task-result-details>");
        returnMsg.append("</component-task-result>");
        return returnMsg.toString();
    }

    private void checkComponentState(String suName, String oper) throws DeploymentException {
        if (!this.mComponent.isStarted()) {
            String msg = this.mTranslator.getString("DMB_SU_COMP_NOT_STARTED", oper, suName);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage(oper, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performOperation(int operation, long timeout, String task, String suName, String suRoot) throws DeploymentException {
        Object[] args = new Object[]{suName, suRoot};
        OperationCounter oc = new OperationCounter();
        if (null == this.mSuMgr) {
            String msg = this.mTranslator.getString("DMB_SU_OPERATION_NOT_AVAILABLE", task, suName);
            throw new DeploymentException(this.buildMessage(task, msg));
        }
        ServiceUnitOperation suOper = new ServiceUnitOperation(oc, this.mComponent.getName(), this.mSuMgr, operation, args);
        new Thread((Runnable)suOper, suName).start();
        OperationCounter operationCounter = oc;
        synchronized (operationCounter) {
            try {
                if (0 < oc.getValue()) {
                    oc.wait(timeout);
                }
            }
            catch (InterruptedException iEx) {
                suOper.getThread().interrupt();
                String msg = this.mTranslator.getString("DMB_SU_OPERATION_INTERRUPTED", task, suName);
                this.mLog.warning(msg);
                throw new DeploymentException(this.buildMessage(task, msg));
            }
        }
        if (suOper.completed()) {
            Throwable ex = suOper.getException();
            if (null != ex) {
                if (this.statisticsEnabled()) {
                    this.mComponentStatistics.incrementFailedSURequests();
                }
                if (ex instanceof DeploymentException) {
                    throw (DeploymentException)ex;
                }
                String exMsg = ex.getMessage();
                String msg = null == exMsg ? this.mTranslator.getString("DMB_SU_OPERATION_EXCEPTION_NO_MSG", ex.getClass().getName(), task, suName) : this.mTranslator.getString("DMB_SU_OPERATION_EXCEPTION", ex.getClass().getName(), task, suName, exMsg);
                this.mLog.log(Level.WARNING, msg, ex);
                throw new DeploymentException(this.buildMessage(task, msg));
            }
        } else {
            suOper.getThread().interrupt();
            if (this.statisticsEnabled()) {
                this.mComponentStatistics.incrementTimedOutSURequests();
            }
            String msg = this.mTranslator.getString("DMB_SU_OPERATION_TIMEOUT", task, suName, timeout);
            this.mLog.warning(msg);
            throw new DeploymentException(this.buildMessage(task, msg));
        }
        return (String)suOper.getReturnValue();
    }

    private void persistState(ServiceUnit su, String task) {
        try {
            Updater updater = ((Registry)this.mEnv.getRegistry()).getUpdater();
            updater.setServiceUnitState(su.getDesiredState(), this.mComponent.getName(), su.getName());
        }
        catch (RegistryException rex) {
            String msg = this.mTranslator.getString("DMB_SU_STATE_PERSIST_FAILURE", su.getName(), task, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private boolean statisticsEnabled() {
        if (null != this.mComponentStatistics) {
            if (this.mComponentStatistics.isEnabled()) {
                return true;
            }
        } else {
            this.mComponentStatistics = this.mComponent.getStatisticsInstance();
            if (null != this.mComponentStatistics && this.mComponentStatistics.isEnabled()) {
                return true;
            }
        }
        return false;
    }
}

