/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentLoggerMBean;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.framework.XmlUtil;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentLogger
implements ComponentLoggerMBean {
    private Component mComponent;
    private Logger mLog;
    private TreeMap<String, LoggerInfo> mLoggerInfo;
    private String mLoggerNamePrefix;
    private String mLoggerNameTop;
    private Properties mLoggerSettings;
    private StringTranslator mTranslator;
    static final String CONFIG_DIRECTORY = "/config/";
    static final String LOGGER_SETTINGS = "loggerSettings.properties";
    static final String LOGGER_DEFAULT = "DEFAULT";
    static final String DISPLAY_NAME = ".displayName";
    static final String TAG_LOGGING_SECTION = "logging:Logging";
    static final String TAG_LOGGING_ROOT = "root";
    static final String TAG_LOGGER_DEFINITION = "logging:logger";
    static final String TAG_DISPLAY_NAME = "displayName";
    static final String TAG_ADD_PREFIX = "addPrefix";
    static final String URI_LOGGING_SECTION = "http://www.sun.com/jbi/descriptor/logging";

    ComponentLogger(Component component) {
        this.mComponent = component;
        EnvironmentContext env = EnvironmentContext.getInstance();
        this.mLog = env.getLogger();
        this.mLoggerInfo = new TreeMap();
        this.setLoggerNamePrefix(component.getName());
        this.mLoggerSettings = new Properties();
        this.mTranslator = (StringTranslator)env.getStringTranslatorFor(this);
        this.loadLoggerSettings();
        this.getLoggerDefs();
        this.mLoggerNameTop = this.getLoggerNamePrefix();
        int dot = this.mLoggerNameTop.lastIndexOf(".");
        if (-1 < dot) {
            this.mLoggerNameTop = this.mLoggerNameTop.substring(0, dot);
        }
        Logger logger = Logger.getLogger(this.mLoggerNameTop);
        try {
            logger.setParent(env.getJbiLogger());
        }
        catch (SecurityException se) {
            // empty catch block
        }
        logger.setLevel(this.getSavedLevel(this.mLoggerNameTop));
        this.addLogger(logger, this.mComponent.getName());
    }

    @Override
    public String getDisplayName(String logName) {
        if (null == logName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "logName"));
        }
        String displayName = null;
        LoggerInfo info = this.mLoggerInfo.get(logName);
        if (null != info) {
            String dn = info.getDisplayName();
            if (null == dn) {
                dn = this.mLoggerSettings.getProperty(logName + DISPLAY_NAME);
                if (null != dn) {
                    displayName = dn;
                    info.setDisplayName(dn);
                }
            } else {
                displayName = dn;
            }
        }
        if (null == displayName) {
            int lastDot = logName.lastIndexOf(".");
            displayName = -1 < lastDot ? logName.substring(lastDot + 1) : logName;
        }
        return displayName;
    }

    @Override
    public String getLevel(String logName) throws JBIException {
        if (null == logName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "logName"));
        }
        LoggerInfo info = this.mLoggerInfo.get(logName);
        if (null == info) {
            throw new JBIException(this.mTranslator.getString("COMP_LOGGER_NOT_FOUND", logName));
        }
        Logger log = info.getLogger();
        if (null == log) {
            String lvl = this.mLoggerSettings.getProperty(logName);
            if (null == lvl || lvl.equals(LOGGER_DEFAULT)) {
                lvl = this.getLevel(this.mLoggerNameTop);
            }
            return Level.parse(lvl).getLocalizedName();
        }
        Level level = log.getLevel();
        while (null == level && null != (log = log.getParent())) {
            level = log.getLevel();
        }
        if (null != level) {
            return level.getLocalizedName();
        }
        return null;
    }

    @Override
    public String[] getLoggerNames() {
        String[] s = new String[this.mLoggerInfo.size()];
        this.mLoggerInfo.keySet().toArray(s);
        return s;
    }

    @Override
    public int setAll(String logName) throws JBIException {
        return this.setLevel(logName, Level.ALL);
    }

    @Override
    public int setConfig(String logName) throws JBIException {
        return this.setLevel(logName, Level.CONFIG);
    }

    @Override
    public int setDefault(String logName) throws JBIException {
        return this.setLevel(logName, null);
    }

    @Override
    public int setFine(String logName) throws JBIException {
        return this.setLevel(logName, Level.FINE);
    }

    @Override
    public int setFiner(String logName) throws JBIException {
        return this.setLevel(logName, Level.FINER);
    }

    @Override
    public int setFinest(String logName) throws JBIException {
        return this.setLevel(logName, Level.FINEST);
    }

    @Override
    public int setInfo(String logName) throws JBIException {
        return this.setLevel(logName, Level.INFO);
    }

    @Override
    public int setOff(String logName) throws JBIException {
        return this.setLevel(logName, Level.OFF);
    }

    @Override
    public int setSevere(String logName) throws JBIException {
        return this.setLevel(logName, Level.SEVERE);
    }

    @Override
    public int setWarning(String logName) throws JBIException {
        return this.setLevel(logName, Level.WARNING);
    }

    boolean addLogger(Logger logger, String displayName) {
        if (null == logger) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "logger"));
        }
        if (null == displayName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", TAG_DISPLAY_NAME));
        }
        boolean added = false;
        String loggerName = logger.getName();
        LoggerInfo info = null;
        if (this.mLoggerInfo.containsKey(loggerName)) {
            info = this.mLoggerInfo.get(loggerName);
            if (null == info.getLogger()) {
                info.setLogger(logger);
                added = true;
            }
            if (null == info.getDisplayName()) {
                info.setDisplayName(displayName);
            }
        } else {
            info = new LoggerInfo(logger, displayName);
            this.mLoggerInfo.put(loggerName, info);
            added = true;
        }
        if (added) {
            logger.setLevel(this.getSavedLevel(loggerName));
        }
        return added;
    }

    void addLoggerInfo(String loggerName, String displayName, boolean addPrefix) {
        if (addPrefix && null != this.mLoggerNamePrefix && !loggerName.startsWith(this.mLoggerNamePrefix)) {
            loggerName = this.mLoggerNamePrefix + loggerName;
        }
        if (null == displayName) {
            int lastDot = loggerName.lastIndexOf(".");
            displayName = -1 < lastDot ? loggerName.substring(lastDot + 1) : loggerName;
        }
        if (!this.mLoggerInfo.containsKey(loggerName)) {
            LoggerInfo info = new LoggerInfo(displayName);
            this.mLoggerInfo.put(loggerName, info);
        } else {
            LoggerInfo info = this.mLoggerInfo.get(loggerName);
            info.setDisplayName(displayName);
        }
        if (null == this.mLoggerSettings.getProperty(loggerName)) {
            this.mLoggerSettings.setProperty(loggerName, LOGGER_DEFAULT);
            this.mLoggerSettings.setProperty(loggerName + DISPLAY_NAME, displayName);
        }
    }

    void getLoggerDefs() {
        this.getLoggerDefs(false);
    }

    void getLoggerDefs(boolean upgradeFlag) {
        Element logging;
        ComponentDescriptor cd = this.mComponent.getInstallationDescriptorModel(upgradeFlag);
        if (null != cd && null != (logging = cd.getComponentLoggingXml())) {
            try {
                NodeList logDefs;
                String prefix = XmlUtil.getAttribute(logging, TAG_LOGGING_ROOT);
                if (0 < prefix.length()) {
                    this.setLoggerNamePrefix(prefix);
                }
                if (null != (logDefs = XmlUtil.getElements(logging, TAG_LOGGER_DEFINITION, false))) {
                    for (int l = 0; l < logDefs.getLength(); ++l) {
                        Node logDef = logDefs.item(l);
                        String name = XmlUtil.getStringValue(logDef);
                        String displayName = XmlUtil.getAttribute(logDef, TAG_DISPLAY_NAME);
                        String addPrefixStr = XmlUtil.getAttribute(logDef, TAG_ADD_PREFIX);
                        boolean addPrefix = true;
                        if (0 < addPrefixStr.length()) {
                            addPrefix = Boolean.parseBoolean(addPrefixStr);
                        }
                        if (0 == displayName.length()) {
                            displayName = null;
                        }
                        this.addLoggerInfo(name, displayName, addPrefix);
                    }
                }
            }
            catch (JBIException ex) {
                this.mLog.warning(ex.getMessage());
            }
            this.saveLoggerSettings();
        }
    }

    String getLoggerNamePrefix() {
        return this.mLoggerNamePrefix;
    }

    Level getSavedLevel(String loggerName) {
        if (null == loggerName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "loggerName"));
        }
        String level = this.mLoggerSettings.getProperty(loggerName);
        if (null != level) {
            if (level.equals(LOGGER_DEFAULT)) {
                return null;
            }
            return Level.parse(level);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadLoggerSettings() {
        FileInputStream inStream = null;
        File configFile = new File(this.getConfigDirName() + LOGGER_SETTINGS);
        try {
            inStream = new FileInputStream(configFile);
            this.mLoggerSettings.load(inStream);
        }
        catch (FileNotFoundException fnfEx) {
        }
        catch (IOException ioEx) {
            this.mLog.log(Level.WARNING, this.mTranslator.getString("COMP_LOGGER_SETTINGS_LOAD_FAILED", this.mComponent.getComponentTypeAsString(), this.mComponent.getName(), configFile.getAbsolutePath()), ioEx);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException ioEx) {
                    this.mLog.log(Level.WARNING, this.mTranslator.getString("COMP_LOGGER_SETTINGS_CLOSE_FAILED", this.mComponent.getComponentTypeAsString(), this.mComponent.getName(), configFile.getAbsolutePath()), ioEx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void saveLoggerSettings() {
        File configDir = new File(this.getConfigDirName());
        if (!configDir.exists() && !configDir.mkdir()) {
            this.mLog.warning(this.mTranslator.getString("COMP_LOGGER_SETTINGS_CREATE_FAILED", configDir.getAbsolutePath(), this.mComponent.getComponentTypeAsString(), this.mComponent.getName()));
            return;
        }
        File configFile = new File(this.getConfigDirName() + LOGGER_SETTINGS);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(configFile);
            this.mLoggerSettings.store(outStream, "Logger levels for " + this.mComponent.getComponentTypeAsString() + " " + this.mComponent.getName());
        }
        catch (FileNotFoundException fnfEx) {
            this.mLog.log(Level.WARNING, this.mTranslator.getString("COMP_LOGGER_SETTINGS_SAVE_FAILED", this.mComponent.getComponentTypeAsString(), this.mComponent.getName(), configFile.getAbsolutePath()), fnfEx);
        }
        catch (IOException ioEx) {
            this.mLog.log(Level.WARNING, this.mTranslator.getString("COMP_LOGGER_SETTINGS_SAVE_FAILED", this.mComponent.getComponentTypeAsString(), this.mComponent.getName(), configFile.getAbsolutePath()), ioEx);
        }
        finally {
            if (null != outStream) {
                try {
                    outStream.close();
                }
                catch (IOException ioEx) {
                    this.mLog.log(Level.WARNING, this.mTranslator.getString("COMP_LOGGER_SETTINGS_CLOSE_FAILED", this.mComponent.getComponentTypeAsString(), this.mComponent.getName(), configFile.getAbsolutePath()), ioEx);
                }
            }
        }
    }

    boolean isLoggerRegistered(String name) {
        LoggerInfo info;
        return this.mLoggerInfo.containsKey(name) && null != (info = this.mLoggerInfo.get(name)).getLogger();
    }

    void setLoggerNamePrefix(String prefix) {
        this.mLoggerNamePrefix = prefix.endsWith(".") ? prefix : prefix + ".";
    }

    private String getConfigDirName() {
        File installRoot = new File(this.mComponent.getInstallRoot());
        return installRoot.getParent() + CONFIG_DIRECTORY;
    }

    int setLevel(String logName, Level logLevel) throws JBIException {
        if (null == logName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "logName"));
        }
        LoggerInfo info = this.mLoggerInfo.get(logName);
        if (null != info) {
            Logger log = info.getLogger();
            if (null == log) {
                log = Logger.getLogger(logName);
                info.setLogger(log);
            }
            log.setLevel(logLevel);
            this.mLog.log(Level.FINE, "Logger {0} set to {1}", new Object[]{logName, logLevel == null ? "null" : logLevel.getLocalizedName()});
            if (null == logLevel) {
                this.mLoggerSettings.setProperty(logName, LOGGER_DEFAULT);
            } else {
                this.mLoggerSettings.setProperty(logName, logLevel.getName());
            }
            this.saveLoggerSettings();
            return 0;
        }
        throw new JBIException(this.mTranslator.getString("COMP_LOGGER_NOT_FOUND", logName));
    }

    private class LoggerInfo {
        Logger mLogger;
        String mDisplayName;

        LoggerInfo(Logger logger, String displayName) {
            this.mLogger = logger;
            this.mDisplayName = displayName;
        }

        LoggerInfo(String displayName) {
            this.mLogger = null;
            this.mDisplayName = displayName;
        }

        Logger getLogger() {
            return this.mLogger;
        }

        String getLoggerName() {
            return this.mLogger.getName();
        }

        String getDisplayName() {
            return this.mDisplayName;
        }

        void setLogger(Logger logger) {
            this.mLogger = logger;
        }

        void setDisplayName(String displayName) {
            this.mDisplayName = displayName;
        }
    }
}

