/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentState;
import com.sun.jbi.component.InstallationContext;
import com.sun.jbi.framework.ComponentFramework;
import com.sun.jbi.framework.ComponentRegistry;
import com.sun.jbi.management.InstallerMBean;
import javax.jbi.JBIException;
import javax.management.ObjectName;

public class ComponentInstaller
implements InstallerMBean {
    private ComponentFramework mComponentFramework;
    private ComponentRegistry mComponentRegistry;
    private InstallationContext mInstallContext;

    ComponentInstaller(InstallationContext installContext, ComponentFramework componentFramework, ComponentRegistry componentRegistry) {
        this.mInstallContext = installContext;
        this.mComponentFramework = componentFramework;
        this.mComponentRegistry = componentRegistry;
    }

    public ObjectName getInstallerConfigurationMBean() throws JBIException {
        return this.mComponentFramework.getInstallerConfigurationMBeanName(this.mInstallContext.getComponentName());
    }

    public String getInstallRoot() {
        return this.mInstallContext.getInstallRoot();
    }

    public ObjectName install() throws JBIException {
        return this.mComponentFramework.installComponent(this.mInstallContext);
    }

    public boolean isInstalled() {
        ComponentState s;
        try {
            s = this.mComponentRegistry.getStatus(this.mInstallContext.getComponentName());
        }
        catch (JBIException ex) {
            return false;
        }
        return s != ComponentState.LOADED;
    }

    public void uninstall() throws JBIException {
        this.uninstall(false);
    }

    @Override
    public void uninstall(boolean force) throws JBIException {
        this.mComponentFramework.uninstallComponent(this.mInstallContext, force);
    }
}

