/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ConsumingEndpointStatisticsData;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.ProvisioningEndpointStatisticsData;
import com.sun.esb.management.common.data.helper.EndpointStatisticsDataReader;
import com.sun.esb.management.common.data.helper.EndpointStatisticsDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EndpointStatisticsDataWriter
implements EndpointStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    static final String FILE_NAME_KEY = "EndpointStatisticsData.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, IEndpointStatisticsData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        EndpointStatisticsDataWriter writer = new EndpointStatisticsDataWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("EndpointStatisticsDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/EndpointStatisticsDataList");
            root.setAttribute("version", "1.0");
            for (String instanceName : dataMap.keySet()) {
                Element endpointStatisticsDataElementChild;
                IEndpointStatisticsData data = dataMap.get(instanceName);
                if (data.isProvisioningEndpoint()) {
                    endpointStatisticsDataElementChild = writer.createProvisioningEndpointStatisticsDataElement(document, (ProvisioningEndpointStatisticsData)data);
                    root.appendChild(endpointStatisticsDataElementChild);
                    continue;
                }
                endpointStatisticsDataElementChild = writer.createConsumingEndpointStatisticsDataElement(document, (ConsumingEndpointStatisticsData)data);
                root.appendChild(endpointStatisticsDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createProvisioningEndpointStatisticsDataElement(Document document, ProvisioningEndpointStatisticsData provisioningData) {
        Element endpointStatisticsDataElement = null;
        if (document != null && provisioningData != null) {
            endpointStatisticsDataElement = document.createElement("ProvisioningEndpointStatisticsData");
            Element activationTimeElementChild = document.createElement("ActivationTime");
            if (activationTimeElementChild != null) {
                activationTimeElementChild.setTextContent(provisioningData.getActivationTime() + "");
            }
            endpointStatisticsDataElement.appendChild(activationTimeElementChild);
            Element numberOfActiveExchangesElementChild = document.createElement("NumberOfActiveExchanges");
            if (numberOfActiveExchangesElementChild != null) {
                numberOfActiveExchangesElementChild.setTextContent(provisioningData.getNumberOfActiveExchanges() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfActiveExchangesElementChild);
            Element numberOfReceivedRequestsElementChild = document.createElement("NumberOfReceivedRequests");
            if (numberOfReceivedRequestsElementChild != null) {
                numberOfReceivedRequestsElementChild.setTextContent(provisioningData.getNumberOfReceivedRequests() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedRequestsElementChild);
            Element numberOfSentRepliesElementChild = document.createElement("NumberOfSentReplies");
            if (numberOfSentRepliesElementChild != null) {
                numberOfSentRepliesElementChild.setTextContent(provisioningData.getNumberOfSentReplies() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentRepliesElementChild);
            Element uptimeElementChild = document.createElement("Uptime");
            if (uptimeElementChild != null) {
                uptimeElementChild.setTextContent(provisioningData.getUptime() + "");
            }
            endpointStatisticsDataElement.appendChild(uptimeElementChild);
            Element messageExchangeResponseTimeAverageElementChild = document.createElement("MessageExchangeResponseTimeAverage");
            if (messageExchangeResponseTimeAverageElementChild != null) {
                messageExchangeResponseTimeAverageElementChild.setTextContent(provisioningData.getMessageExchangeResponseTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeResponseTimeAverageElementChild);
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(provisioningData.getInstanceName());
            }
            endpointStatisticsDataElement.appendChild(instanceNameElementChild);
            Element componentNameElementChild = document.createElement("ComponentName");
            if (componentNameElementChild != null) {
                componentNameElementChild.setTextContent(provisioningData.getComponentName());
            }
            endpointStatisticsDataElement.appendChild(componentNameElementChild);
            Element extendedTimingStatisticsFlagEnabledElementChild = document.createElement("ExtendedTimingStatisticsFlagEnabled");
            if (extendedTimingStatisticsFlagEnabledElementChild != null) {
                extendedTimingStatisticsFlagEnabledElementChild.setTextContent(provisioningData.isExtendedTimingStatisticsFlagEnabled() + "");
            }
            endpointStatisticsDataElement.appendChild(extendedTimingStatisticsFlagEnabledElementChild);
            Element messageExchangeComponentTimeAverageElementChild = document.createElement("MessageExchangeComponentTimeAverage");
            if (messageExchangeComponentTimeAverageElementChild != null) {
                messageExchangeComponentTimeAverageElementChild.setTextContent(provisioningData.getMessageExchangeComponentTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeComponentTimeAverageElementChild);
            Element messageExchangeDeliveryChannelTimeAverageElementChild = document.createElement("MessageExchangeDeliveryChannelTimeAverage");
            if (messageExchangeDeliveryChannelTimeAverageElementChild != null) {
                messageExchangeDeliveryChannelTimeAverageElementChild.setTextContent(provisioningData.getMessageExchangeDeliveryChannelTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeDeliveryChannelTimeAverageElementChild);
            Element messageExchangeServiceTimeAverageElementChild = document.createElement("MessageExchangeServiceTimeAverage");
            if (messageExchangeServiceTimeAverageElementChild != null) {
                messageExchangeServiceTimeAverageElementChild.setTextContent(provisioningData.getMessageExchangeServiceTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeServiceTimeAverageElementChild);
            Element numberOfReceivedDonesElementChild = document.createElement("NumberOfReceivedDones");
            if (numberOfReceivedDonesElementChild != null) {
                numberOfReceivedDonesElementChild.setTextContent(provisioningData.getNumberOfReceivedDones() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedDonesElementChild);
            Element numberOfReceivedErrorsElementChild = document.createElement("NumberOfReceivedErrors");
            if (numberOfReceivedErrorsElementChild != null) {
                numberOfReceivedErrorsElementChild.setTextContent(provisioningData.getNumberOfReceivedErrors() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedErrorsElementChild);
            Element numberOfReceivedFaultsElementChild = document.createElement("NumberOfReceivedFaults");
            if (numberOfReceivedFaultsElementChild != null) {
                numberOfReceivedFaultsElementChild.setTextContent(provisioningData.getNumberOfReceivedFaults() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedFaultsElementChild);
            Element numberOfSentDonesElementChild = document.createElement("NumberOfSentDones");
            if (numberOfSentDonesElementChild != null) {
                numberOfSentDonesElementChild.setTextContent(provisioningData.getNumberOfSentDones() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentDonesElementChild);
            Element numberOfSentErrorsElementChild = document.createElement("NumberOfSentErrors");
            if (numberOfSentErrorsElementChild != null) {
                numberOfSentErrorsElementChild.setTextContent(provisioningData.getNumberOfSentErrors() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentErrorsElementChild);
            Element numberOfSentFaultsElementChild = document.createElement("NumberOfSentFaults");
            if (numberOfSentFaultsElementChild != null) {
                numberOfSentFaultsElementChild.setTextContent(provisioningData.getNumberOfSentFaults() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentFaultsElementChild);
            Element performanceDataListElement = document.createElement("PerformanceMeasurementDataList");
            performanceDataListElement.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/PerformanceMeasurementDataList");
            performanceDataListElement.setAttribute("version", "1.0");
            Map<String, PerformanceData> dataMap = provisioningData.getCategoryToPerformanceDataMap();
            for (String category : dataMap.keySet()) {
                PerformanceData data = dataMap.get(category);
                Element performanceMeasurementDataElementChild = this.createPerformanceMeasurementDataElement(document, data);
                performanceDataListElement.appendChild(performanceMeasurementDataElementChild);
            }
            endpointStatisticsDataElement.appendChild(performanceDataListElement);
        }
        return endpointStatisticsDataElement;
    }

    protected Element createConsumingEndpointStatisticsDataElement(Document document, ConsumingEndpointStatisticsData consumingData) {
        Element endpointStatisticsDataElement = null;
        if (document != null && consumingData != null) {
            endpointStatisticsDataElement = document.createElement("ConsumingEndpointStatisticsData");
            Element numberOfReceivedRepliesElementChild = document.createElement("NumberOfReceivedReplies");
            if (numberOfReceivedRepliesElementChild != null) {
                numberOfReceivedRepliesElementChild.setTextContent(consumingData.getNumberOfReceivedReplies() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedRepliesElementChild);
            Element numberOfSentRequestsElementChild = document.createElement("NumberOfSentRequests");
            if (numberOfSentRequestsElementChild != null) {
                numberOfSentRequestsElementChild.setTextContent(consumingData.getNumberOfSentRequests() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentRequestsElementChild);
            Element messageExchangeStatusTimeAverageElementChild = document.createElement("MessageExchangeStatusTimeAverage");
            if (messageExchangeStatusTimeAverageElementChild != null) {
                messageExchangeStatusTimeAverageElementChild.setTextContent(consumingData.getMessageExchangeStatusTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeStatusTimeAverageElementChild);
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(consumingData.getInstanceName());
            }
            endpointStatisticsDataElement.appendChild(instanceNameElementChild);
            Element componentNameElementChild = document.createElement("ComponentName");
            if (componentNameElementChild != null) {
                componentNameElementChild.setTextContent(consumingData.getComponentName());
            }
            endpointStatisticsDataElement.appendChild(componentNameElementChild);
            Element extendedTimingStatisticsFlagEnabledElementChild = document.createElement("ExtendedTimingStatisticsFlagEnabled");
            if (extendedTimingStatisticsFlagEnabledElementChild != null) {
                extendedTimingStatisticsFlagEnabledElementChild.setTextContent(consumingData.isExtendedTimingStatisticsFlagEnabled() + "");
            }
            endpointStatisticsDataElement.appendChild(extendedTimingStatisticsFlagEnabledElementChild);
            Element messageExchangeComponentTimeAverageElementChild = document.createElement("MessageExchangeComponentTimeAverage");
            if (messageExchangeComponentTimeAverageElementChild != null) {
                messageExchangeComponentTimeAverageElementChild.setTextContent(consumingData.getMessageExchangeComponentTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeComponentTimeAverageElementChild);
            Element messageExchangeDeliveryChannelTimeAverageElementChild = document.createElement("MessageExchangeDeliveryChannelTimeAverage");
            if (messageExchangeDeliveryChannelTimeAverageElementChild != null) {
                messageExchangeDeliveryChannelTimeAverageElementChild.setTextContent(consumingData.getMessageExchangeDeliveryChannelTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeDeliveryChannelTimeAverageElementChild);
            Element messageExchangeServiceTimeAverageElementChild = document.createElement("MessageExchangeServiceTimeAverage");
            if (messageExchangeServiceTimeAverageElementChild != null) {
                messageExchangeServiceTimeAverageElementChild.setTextContent(consumingData.getMessageExchangeServiceTimeAverage() + "");
            }
            endpointStatisticsDataElement.appendChild(messageExchangeServiceTimeAverageElementChild);
            Element numberOfReceivedDonesElementChild = document.createElement("NumberOfReceivedDones");
            if (numberOfReceivedDonesElementChild != null) {
                numberOfReceivedDonesElementChild.setTextContent(consumingData.getNumberOfReceivedDones() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedDonesElementChild);
            Element numberOfReceivedErrorsElementChild = document.createElement("NumberOfReceivedErrors");
            if (numberOfReceivedErrorsElementChild != null) {
                numberOfReceivedErrorsElementChild.setTextContent(consumingData.getNumberOfReceivedErrors() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedErrorsElementChild);
            Element numberOfReceivedFaultsElementChild = document.createElement("NumberOfReceivedFaults");
            if (numberOfReceivedFaultsElementChild != null) {
                numberOfReceivedFaultsElementChild.setTextContent(consumingData.getNumberOfReceivedFaults() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfReceivedFaultsElementChild);
            Element numberOfSentDonesElementChild = document.createElement("NumberOfSentDones");
            if (numberOfSentDonesElementChild != null) {
                numberOfSentDonesElementChild.setTextContent(consumingData.getNumberOfSentDones() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentDonesElementChild);
            Element numberOfSentErrorsElementChild = document.createElement("NumberOfSentErrors");
            if (numberOfSentErrorsElementChild != null) {
                numberOfSentErrorsElementChild.setTextContent(consumingData.getNumberOfSentErrors() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentErrorsElementChild);
            Element numberOfSentFaultsElementChild = document.createElement("NumberOfSentFaults");
            if (numberOfSentFaultsElementChild != null) {
                numberOfSentFaultsElementChild.setTextContent(consumingData.getNumberOfSentFaults() + "");
            }
            endpointStatisticsDataElement.appendChild(numberOfSentFaultsElementChild);
            Element performanceDataListElement = document.createElement("PerformanceMeasurementDataList");
            performanceDataListElement.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/PerformanceMeasurementDataList");
            performanceDataListElement.setAttribute("version", "1.0");
            Map<String, PerformanceData> dataMap = consumingData.getCategoryToPerformanceDataMap();
            for (String category : dataMap.keySet()) {
                PerformanceData data = dataMap.get(category);
                Element performanceMeasurementDataElementChild = this.createPerformanceMeasurementDataElement(document, data);
                performanceDataListElement.appendChild(performanceMeasurementDataElementChild);
            }
            endpointStatisticsDataElement.appendChild(performanceDataListElement);
        }
        return endpointStatisticsDataElement;
    }

    protected Element createPerformanceMeasurementDataElement(Document document, PerformanceData data) {
        Element performanceDataElement = null;
        if (document != null && data != null) {
            performanceDataElement = document.createElement("PerformanceMeasurementData");
            Element categoryElementChild = document.createElement("category");
            if (categoryElementChild != null) {
                categoryElementChild.setTextContent(data.getCategory());
            }
            performanceDataElement.appendChild(categoryElementChild);
            Element endpointElementChild = document.createElement("endpoint");
            if (endpointElementChild != null) {
                endpointElementChild.setTextContent(data.getEndpoint());
            }
            performanceDataElement.appendChild(endpointElementChild);
            Element sourceClassNameElementChild = document.createElement("sourceClassName");
            if (sourceClassNameElementChild != null) {
                sourceClassNameElementChild.setTextContent(data.getSourceClassName());
            }
            performanceDataElement.appendChild(sourceClassNameElementChild);
            Element numberOfMeasurementObjectsElementChild = document.createElement("numberOfMeasurementObjects");
            if (numberOfMeasurementObjectsElementChild != null) {
                numberOfMeasurementObjectsElementChild.setTextContent(data.getNumberOfMeasurementObjects() + "");
            }
            performanceDataElement.appendChild(numberOfMeasurementObjectsElementChild);
            Element numberOfMeasurementsElementChild = document.createElement("numberOfMeasurements");
            if (categoryElementChild != null) {
                numberOfMeasurementsElementChild.setTextContent(data.getNumberOfMeasurements() + "");
            }
            performanceDataElement.appendChild(numberOfMeasurementsElementChild);
            Element averageElementChild = document.createElement("average");
            if (averageElementChild != null) {
                averageElementChild.setTextContent(data.getAverage() + "");
            }
            performanceDataElement.appendChild(averageElementChild);
            Element averageWithoutFirstMeasurementElementChild = document.createElement("averageWithoutFirstMeasurement");
            if (averageWithoutFirstMeasurementElementChild != null) {
                averageWithoutFirstMeasurementElementChild.setTextContent(data.getAverageWithoutFirstMeasurement() + "");
            }
            performanceDataElement.appendChild(averageWithoutFirstMeasurementElementChild);
            Element firstMeasurementTimeElementChild = document.createElement("firstMeasurementTime");
            if (firstMeasurementTimeElementChild != null) {
                firstMeasurementTimeElementChild.setTextContent(data.getFirstMeasurementTime() + "");
            }
            performanceDataElement.appendChild(firstMeasurementTimeElementChild);
            Element loadElementChild = document.createElement("load");
            if (loadElementChild != null) {
                loadElementChild.setTextContent(data.getLoad() + "");
            }
            performanceDataElement.appendChild(loadElementChild);
            Element medianElementChild = document.createElement("median");
            if (medianElementChild != null) {
                medianElementChild.setTextContent(data.getMedian() + "");
            }
            performanceDataElement.appendChild(medianElementChild);
            Element throughputElementChild = document.createElement("throughput");
            if (throughputElementChild != null) {
                throughputElementChild.setTextContent(data.getThroughput() + "");
            }
            performanceDataElement.appendChild(throughputElementChild);
            Element timeTakenElementChild = document.createElement("timeTaken");
            if (timeTakenElementChild != null) {
                timeTakenElementChild.setTextContent(data.getTimeTaken() + "");
            }
            performanceDataElement.appendChild(timeTakenElementChild);
            Element totalTimeElementChild = document.createElement("totalTime");
            if (totalTimeElementChild != null) {
                totalTimeElementChild.setTextContent(data.getTotalTime() + "");
            }
            performanceDataElement.appendChild(totalTimeElementChild);
        }
        return performanceDataElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/endpointstatistics/EndpointStatisticsData.xml";
        try {
            Map<String, IEndpointStatisticsData> map = null;
            map = EndpointStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            String content = EndpointStatisticsDataWriter.serialize(map);
            System.out.println(content);
            EndpointStatisticsDataWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

