/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

public enum AlertLevelType {
    NONE("NONE"),
    INFO("INFO"),
    WARNING("WARNING"),
    MINOR("MINOR"),
    MAJOR("MAJOR"),
    CRITICAL("CRITICAL"),
    FATAL("FATAL");

    String alertLevel;

    private AlertLevelType(String minAlertLevel) {
        this.alertLevel = minAlertLevel;
    }

    public String getDescription() {
        switch (this) {
            case NONE: {
                return "No limitation on alerts persisted";
            }
            case INFO: {
                return "All Alerts except Info. level alerts can be persisted";
            }
            case WARNING: {
                return "All Alerts except Info. and warning level alerts can be persisted";
            }
            case MINOR: {
                return "All Alerts except Info,warning. and minor level alerts can be persisted";
            }
            case MAJOR: {
                return "Only Alerts with  major,critical and fatal level alerts can be persisted";
            }
            case CRITICAL: {
                return "Only Alerts with  critical and fatal level alerts can be persisted";
            }
            case FATAL: {
                return "Only Alerts with  fatal level alerts can be persisted";
            }
        }
        return "";
    }

    public String getAlertLevel() {
        return this.alertLevel;
    }

    public String getAlertLevelAsIntString() {
        switch (this) {
            case NONE: {
                return "-1";
            }
            case INFO: {
                return "5";
            }
            case WARNING: {
                return "4";
            }
            case MINOR: {
                return "3";
            }
            case MAJOR: {
                return "2";
            }
            case CRITICAL: {
                return "1";
            }
            case FATAL: {
                return "0";
            }
        }
        return "-1";
    }
}

