/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIVerifierReportItemNames;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.apache.tools.ant.BuildException;

public class JbiVerifyApplicationEnvTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.verify.app.env.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.verify.app.env.failed";
    private File mAppFile;
    private boolean mIncludeDeployFlag;
    private String mTemplateDir;

    public File getFile() {
        return this.mAppFile;
    }

    public void setFile(File file) {
        this.mAppFile = file;
    }

    public boolean getIncludeDeploy() {
        return this.mIncludeDeployFlag;
    }

    public void setIncludeDeploy(boolean includeDeploy) {
        this.mIncludeDeployFlag = includeDeploy;
    }

    public String getTemplateDir() {
        return this.mTemplateDir;
    }

    public void setTemplateDir(String templateDir) {
        this.mTemplateDir = templateDir;
    }

    @Override
    public void executeTask() throws BuildException {
        String target = this.getValidTarget();
        try {
            String templateFlagStr = this.mTemplateDir != null && this.mTemplateDir.compareTo("") != 0 ? "True" : "False";
            String deployFlagStr = this.mIncludeDeployFlag ? "True" : "False";
            this.logDebug("app path: " + this.mAppFile.getPath() + " The target: " + target + " The gen templates flag: " + templateFlagStr + " The templates dir: " + this.mTemplateDir + " The deploy flag: " + deployFlagStr);
            CompositeData result = this.getJBIAdminCommands().verifyApplication(this.mAppFile.getPath(), target, this.mTemplateDir != null && this.mTemplateDir.compareTo("") != 0, this.mTemplateDir, this.mIncludeDeployFlag);
            this.printResultCompositeData(result);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    protected void printResultCompositeData(CompositeData compData) throws IOException {
        String[] attributeNames = new String[]{"ServiceAssemblyName", "ServiceAssemblyDescription", "NumServiceUnits", "AllComponentsInstalled", "MissingComponentsList", "EndpointInfo", "TemplateZIPID", "JavaEEVerificationReport"};
        String[] endpointNames = new String[]{"EndpointName", "ServiceUnitName", "ComponentName", "Status", "MissingApplicationVariables", "MissingApplicationConfigurations"};
        String saName = (String)compData.get(attributeNames[0]);
        String saDesc = (String)compData.get(attributeNames[1]);
        int numSUs = (Integer)compData.get(attributeNames[2]);
        boolean allComponentsInstalled = (Boolean)compData.get(attributeNames[3]);
        String[] missingComponents = (String[])compData.get(attributeNames[4]);
        CompositeData[] endpointInfo = (CompositeData[])compData.get(attributeNames[5]);
        String templateZipID = (String)compData.get(attributeNames[6]);
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.header.separator"));
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.header", (Object)this.getValidTarget()));
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.separator"));
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.sa.name") + ": " + saName);
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.service.units") + ": " + numSUs);
        this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.sa.description") + ": " + (saDesc + "").trim());
        if (!allComponentsInstalled) {
            StringBuffer missingCompString = new StringBuffer();
            for (String missingComponent : missingComponents) {
                missingCompString.append(" " + missingComponent);
            }
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.commponents.not.installed") + ": " + (missingCompString.toString() + "").trim());
        }
        for (CompositeData endpointInfo1 : endpointInfo) {
            String[] appConfigs;
            this.logWarning("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.configuration"));
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.separator"));
            Object[] endpointValues = endpointInfo1.getAll(endpointNames);
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.name") + ": " + (String)endpointValues[0]);
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.service.unit") + ": " + (String)endpointValues[1]);
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.component") + ": " + (String)endpointValues[2]);
            if ("UNKNOWN".compareTo(("" + endpointValues[3]).trim()) == 0) {
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status") + ": " + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status.unknown"));
            } else if ("RESOLVED".compareTo(("" + endpointValues[3]).trim()) == 0) {
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status") + ": " + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status.resolved"));
            } else if ("UNRESOLVED".compareTo(("" + endpointValues[3]).trim()) == 0) {
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status") + ": " + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.endpoint.status.unresolved"));
            }
            String[] appVars = (String[])endpointValues[4];
            if (appVars != null && appVars.length > 0) {
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.missing.app.vars"));
                for (String appVar : appVars) {
                    this.logWarning("\t" + appVar);
                }
                this.logWarning("");
            }
            if ((appConfigs = (String[])endpointValues[5]) == null || appConfigs.length <= 0) continue;
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.missing.app.configs"));
            for (String appConfig : appConfigs) {
                this.logWarning("\t" + appConfig);
            }
            this.logWarning("");
        }
        if (compData.containsKey(attributeNames[7])) {
            String[] eeReportFieldNames = new String[]{"ServiceUnitName", "JavaEEVerifierReport"};
            CompositeData[] javaEEVerifierReports = (CompositeData[])compData.get(attributeNames[7]);
            if (javaEEVerifierReports != null && javaEEVerifierReports.length > 0) {
                this.logWarning("");
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.ee.verify.report"));
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.separator"));
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter msgWriter = new PrintWriter(stringWriter);
            for (CompositeData javaEEVerifierReport : javaEEVerifierReports) {
                String serviceUnitName = (String)javaEEVerifierReport.get(eeReportFieldNames[0]);
                this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.service.unit") + ": " + serviceUnitName);
                TabularData reportTable = (TabularData)javaEEVerifierReport.get(eeReportFieldNames[1]);
                Set<?> rows = reportTable.keySet();
                for (Object row : rows) {
                    Object[] key = ((List)row).toArray();
                    CompositeData rptCompData = reportTable.get(key);
                    msgWriter.println();
                    if (rptCompData == null) continue;
                    CompositeType suCompType = rptCompData.getCompositeType();
                    Set<String> suCompItemSet = suCompType.keySet();
                    for (String keyName : suCompItemSet) {
                        if (keyName.startsWith(JBIVerifierReportItemNames.NON_I18N_KEY_PREFIX)) continue;
                        String tabStr = "";
                        msgWriter.println(tabStr + keyName + ": " + rptCompData.get(keyName));
                    }
                }
                this.printMessage(stringWriter.getBuffer().toString());
                stringWriter.flush();
            }
            msgWriter.close();
            stringWriter.close();
        }
        if (this.mTemplateDir != null && this.mTemplateDir.compareTo("") != 0) {
            this.logWarning("");
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.info.separator"));
            this.logWarning(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.verify.app.env.templates.create.msg", (Object[])new String[]{this.mTemplateDir}));
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }
}

