/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.AppVariable;
import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiDeleteApplicationVariablesTask
extends JbiTargetTask {
    private static final String APPVARIABLE_SUCCESS_STATUS_KEY = "jbi.ui.ant.delete.appvariable.successful";
    private static final String APPVARIABLE_FAILED_STATUS_KEY = "jbi.ui.ant.delete.appvariable.failed";
    private static final String APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.delete.appvariable.partial.success";
    private List mAppVariableList;
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeDeleteApplicationVariables(List appVariableList, String compName, String target) throws Exception, BuildException {
        this.logDebug("Delete application variables, component name: " + compName + " target: " + target);
        Properties varsProps = new Properties();
        Iterator itr = appVariableList.iterator();
        ArrayList<String> deletedNames = new ArrayList<String>();
        while (itr.hasNext()) {
            AppVariable appVar = (AppVariable)itr.next();
            String appVarName = "" + appVar.getName();
            if (appVarName.compareTo("") == 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.no.input.appvariable.data.found", null);
                throw new BuildException(msg, this.getLocation());
            }
            this.logDebug("The deleted applicaiton variable is: " + appVarName);
            String[] appVarNames = ("" + appVarName).split("\\s");
            for (int i = 0; i < appVarNames.length; ++i) {
                deletedNames.add(appVarNames[i]);
            }
        }
        String[] deletedStrs = deletedNames.toArray(new String[0]);
        for (int i = 0; i < deletedStrs.length; ++i) {
            this.logDebug("Variable name to be deleted: " + deletedStrs[i]);
        }
        String rtnXml = this.getJBIAdminCommands().deleteApplicationVariables(compName, target, deletedNames.toArray(new String[0]));
        JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)rtnXml);
        if (mgmtMsg.isFailedMsg()) {
            throw new Exception(rtnXml);
        }
        this.printTaskSuccess(mgmtMsg);
    }

    @Override
    public void executeTask() throws BuildException {
        try {
            String compName = this.getComponentName();
            String target = this.getValidTarget();
            List appVariableList = this.getAppVariableList();
            if (compName == null || compName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing delete application variable Task....");
            this.executeDeleteApplicationVariables(appVariableList, compName, target);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPVARIABLE_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPVARIABLE_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getAppVariableList() {
        if (this.mAppVariableList == null) {
            this.mAppVariableList = new ArrayList();
        }
        return this.mAppVariableList;
    }

    public AppVariable createAppVariable() {
        AppVariable appVar = new AppVariable();
        this.getAppVariableList().add(appVar);
        return appVar;
    }
}

