/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Param;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiDeleteApplicationConfigurationsTask
extends JbiTargetTask {
    private static final String APPCONFIG_SUCCESS_STATUS_KEY = "jbi.ui.ant.delete.appconfig.successful";
    private static final String APPCONFIG_FAILED_STATUS_KEY = "jbi.ui.ant.delete.appconfig.failed";
    private static final String APPCONFIG_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.delete.appconfig.partial.success";
    private List mAppConfigList;
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeDeleteApplicationConfigurations(List appConfigList, String compName, String target) throws Exception, BuildException {
        Properties appConfigParamProps = new Properties();
        for (Param appConfig : appConfigList) {
            String appConfigName = appConfig.getName();
            this.logDebug("Delete application configuration, component name: " + compName + " Application Configuration name: " + appConfigName + " target: " + target);
            String rtnXml = this.getJBIAdminCommands().deleteApplicationConfiguration(compName, target, appConfigName);
            JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)rtnXml);
            if (mgmtMsg.isFailedMsg()) {
                throw new Exception(rtnXml);
            }
            this.printTaskSuccess(mgmtMsg);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        try {
            String compName = this.getComponentName();
            String target = this.getValidTarget();
            List appConfigList = this.getAppConfigList();
            if (compName == null || compName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing delete application configurations Task....");
            this.executeDeleteApplicationConfigurations(appConfigList, compName, target);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPCONFIG_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPCONFIG_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return APPCONFIG_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getAppConfigList() {
        if (this.mAppConfigList == null) {
            this.mAppConfigList = new ArrayList();
        }
        return this.mAppConfigList;
    }

    public Param createAppConfig() {
        Param appConfig = new Param();
        this.getAppConfigList().add(appConfig);
        return appConfig;
    }
}

