/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.security.realm;

import java.util.Map;
import java.util.ServiceLoader;
import net.openesb.standalone.security.realm.Realm;
import net.openesb.standalone.security.realm.RealmHandler;
import net.openesb.standalone.utils.I18NBundle;

public final class RealmBuilder {
    private static final String REALM_TYPE = "type";

    public static RealmBuilder realmBuilder() {
        return new RealmBuilder();
    }

    public Realm build(String realmName, Map<String, String> properties) {
        ServiceLoader<RealmHandler> handlers = ServiceLoader.load(RealmHandler.class);
        for (RealmHandler handler : handlers) {
            String type;
            if (!handler.canHandle(type = properties.get(REALM_TYPE))) continue;
            Object realm = handler.create(realmName, properties);
            return realm;
        }
        String msg = I18NBundle.getBundle().getMessage("SECURITY_REALM_HANDLER_NOT_FOUND", realmName);
        throw new IllegalStateException(msg);
    }
}

