/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public final class ClassFinder {
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String CLASS_SUFFIX = ".class";
    private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the given '%s' package exists?";

    public static final List<Class<?>> find(String scannedPackage) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String scannedPath = scannedPackage.replace('.', '/');
        try {
            resources = classLoader.getResources(scannedPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage), e);
        }
        LinkedList classes = new LinkedList();
        while (resources.hasMoreElements()) {
            File file = new File(resources.nextElement().getFile());
            classes.addAll(ClassFinder.find(file, new String()));
        }
        return classes;
    }

    private static final List<Class<?>> find(File file, String scannedPackage) {
        LinkedList classes;
        block4: {
            String resource;
            block3: {
                System.out.println("Package : " + scannedPackage);
                classes = new LinkedList();
                resource = scannedPackage + '.' + file.getName();
                if (!file.isDirectory()) break block3;
                for (File nestedFile : file.listFiles()) {
                    classes.addAll(ClassFinder.find(nestedFile, resource));
                }
                break block4;
            }
            if (!resource.endsWith(CLASS_SUFFIX)) break block4;
            boolean beginIndex = true;
            int endIndex = resource.length() - CLASS_SUFFIX.length();
            String className = resource.substring(1, endIndex);
            try {
                System.out.println(resource);
                System.out.println(className);
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        return classes;
    }
}

