/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Set;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.internal.jcommander.StateConverter;
import net.openesb.model.api.JBIComponent;
import net.openesb.model.api.State;
import net.openesb.sdk.model.ListComponentsRequest;

@Parameters(commandNames={"list-jbi-components"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.list-jbi-components.descr")
public class ListComponentsCommand
extends AbstractCommand {
    @Parameter(names={"--libraryname"}, descriptionKey="cli.list-jbi-components.param.libraryname", arity=1)
    private String libraryName;
    @Parameter(names={"--lifecyclestate"}, descriptionKey="cli.list-jbi-components.param.lifecyclestate", converter=StateConverter.class, arity=1)
    private State lifecycleState;
    @Parameter(names={"--assemblyname"}, descriptionKey="cli.list-jbi-components.param.assemblyname", arity=1)
    private String assemblyName;

    @Override
    protected void executeRequest() {
        ListComponentsRequest request = new ListComponentsRequest();
        request.setServiceAssemblyName(this.assemblyName);
        request.setSharedLibraryName(this.libraryName);
        request.setState(this.lifecycleState);
        Set<JBIComponent> components = this.getClient().listComponents(request);
        if (components.isEmpty()) {
            this.printMessage(this.getLocalizedString("cli.list-jbi-components.empty"));
        } else {
            for (JBIComponent component : components) {
                this.printMessage(component.getName());
            }
        }
    }
}

