/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.startup;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Bootstrap {
    private static final String JBI_JAR_NAME = "jbi.jar";
    private static final String JBI_EXT_JAR_NAME = "jbi-ext.jar";
    private List<String> mBlacklistJars = new ArrayList<String>();
    private ClassLoader mFrameworkClassLoader;
    private ClassLoader mExtensionClassLoader;
    private static final Logger mLog = Logger.getLogger(Bootstrap.class.getName());
    private Object openesbDaemon;
    private static Bootstrap daemon = null;
    private static final String OPENESB_HOME_PROP = "openesb.home";

    public Bootstrap() {
        this.mBlacklistJars.add(JBI_JAR_NAME);
        this.mBlacklistJars.add(JBI_EXT_JAR_NAME);
        this.openesbDaemon = null;
    }

    public void init(boolean stop) throws Exception {
        this.setOpenesbHome();
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.mFrameworkClassLoader);
        Class<?> fwClass = this.mFrameworkClassLoader.loadClass("net.openesb.standalone.startup.Container");
        Constructor<?> defaultConstructor = fwClass.getConstructors()[0];
        Object startupInstance = defaultConstructor.newInstance(stop);
        this.openesbDaemon = startupInstance;
    }

    private void initClassLoaders() {
        this.createExtensionClassLoader();
        this.createFrameworkClassLoader();
    }

    private void setOpenesbHome() {
        File openesbHomeDir;
        String installPath = System.getProperty(OPENESB_HOME_PROP);
        if (installPath == null) {
            File installDir = new File(System.getProperty("user.dir"));
            if (installDir.getName().equals("lib")) {
                installDir = installDir.getParentFile();
            }
            installPath = installDir.getAbsolutePath();
        }
        if (!(openesbHomeDir = new File(installPath)).isDirectory() || !new File(openesbHomeDir, "lib/jbi_rt.jar").exists()) {
            throw new RuntimeException("Invalid OpenESB Home: " + openesbHomeDir.getAbsolutePath());
        }
        System.setProperty(OPENESB_HOME_PROP, openesbHomeDir.getAbsolutePath());
    }

    public void start() throws Exception {
        if (this.openesbDaemon == null) {
            this.init(false);
        }
        Method method = this.openesbDaemon.getClass().getMethod("start", null);
        method.invoke(this.openesbDaemon, (Object[])null);
    }

    public void stop(String[] arguments) throws Exception {
        if (this.openesbDaemon == null) {
            this.init(true);
        }
        Method method = this.openesbDaemon.getClass().getMethod("stop", null);
        method.invoke(this.openesbDaemon, (Object[])null);
    }

    public static void main(String[] args) {
        if (daemon == null) {
            Bootstrap bootstrap;
            daemon = bootstrap = new Bootstrap();
        }
        try {
            String command = "start";
            if (args.length > 0) {
                command = args[args.length - 1];
            }
            if (command.equals("start")) {
                daemon.start();
            } else if (command.equals("stop")) {
                daemon.stop(args);
            } else {
                mLog.log(Level.WARNING, "Bootstrap: command \"{0}\" does not exist.", command);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private void createFrameworkClassLoader() {
        ArrayList<URL> cpList = new ArrayList<URL>();
        URL[] cpURLs = new URL[]{};
        File libDir = new File(System.getProperty(OPENESB_HOME_PROP), "lib");
        for (File lib : libDir.listFiles()) {
            try {
                if (this.mBlacklistJars.contains(lib.getName())) continue;
                mLog.log(Level.FINEST, "Framework classloader : loading library {0}", lib.getName());
                cpList.add(lib.toURI().toURL());
            }
            catch (MalformedURLException urlEx) {
                mLog.log(Level.WARNING, "Bad library URL: {0}", urlEx.getMessage());
            }
        }
        cpURLs = cpList.toArray(cpURLs);
        this.mFrameworkClassLoader = new URLClassLoader(cpURLs, this.mExtensionClassLoader);
    }

    private void createExtensionClassLoader() {
        ArrayList<URL> cpList = new ArrayList<URL>();
        URL[] cpURLs = new URL[]{};
        File libDir = new File(System.getProperty(OPENESB_HOME_PROP), "lib/ext");
        if (libDir.exists() || libDir.isDirectory()) {
            try {
                cpList.add(libDir.toURI().toURL());
                for (File lib : libDir.listFiles()) {
                    mLog.log(Level.FINEST, "Extension classloader : loading library {0}", lib.getName());
                    cpList.add(lib.toURI().toURL());
                }
            }
            catch (MalformedURLException urlEx) {
                mLog.log(Level.WARNING, "Bad library URL: {0}", urlEx.getMessage());
            }
        }
        cpURLs = cpList.toArray(cpURLs);
        this.mExtensionClassLoader = new URLClassLoader(cpURLs, this.getClass().getClassLoader());
    }
}

