/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.ServiceAssemblyService;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.management.jmx.utils.ServiceAssemblyConverter;
import net.openesb.management.jmx.utils.StateUtils;
import net.openesb.model.api.ServiceAssembly;
import net.openesb.model.api.manage.Task;

public class ServiceAssemblyServiceImpl
extends AbstractServiceImpl
implements ServiceAssemblyService {
    public Set<ServiceAssembly> findServiceAssemblies(String state, String componentName) throws ManagementException {
        List<ServiceAssemblyInfo> saInfoList = this.searchServiceAssemblies(state, componentName, false);
        HashSet<ServiceAssembly> assemblies = new HashSet<ServiceAssembly>(saInfoList.size());
        for (ServiceAssemblyInfo sAssembly : saInfoList) {
            assemblies.add(ServiceAssemblyConverter.convert(sAssembly, false));
        }
        return assemblies;
    }

    private List<ServiceAssemblyInfo> searchServiceAssemblies(String state, String componentName, boolean includeSUs) throws ManagementException {
        String compName = null;
        if (componentName != null) {
            compName = componentName.trim();
        }
        String[] saNames = new String[]{};
        if (compName == null || compName.length() <= 0) {
            ServiceAssemblyServiceImpl.getLogger().log(Level.FINE, "Getting all the deployed service assemblies with state {0}", state);
            try {
                saNames = this.getDeploymentServiceMBean().getDeployedServiceAssemblies();
            }
            catch (Exception e) {
                ServiceAssemblyServiceImpl.getLogger().log(Level.WARNING, "Unable to retrieve assemblies.", e);
            }
        } else {
            ServiceAssemblyServiceImpl.getLogger().log(Level.FINE, "Getting all the deployed service assemblies for the component {0}", compName);
            if (!this.isExistingComponent(compName)) {
                String[] args = new String[]{compName};
                throw this.createManagementException("rest.component.id.does.not.exist", args, null);
            }
            try {
                saNames = this.getDeploymentServiceMBean().getDeployedServiceAssembliesForComponent(compName);
            }
            catch (Exception e) {
                ServiceAssemblyServiceImpl.getLogger().log(Level.WARNING, "Unable to retrieve assemblies for component.", e);
            }
        }
        ArrayList<ServiceAssemblyInfo> saInfoByCompNameList = new ArrayList<ServiceAssemblyInfo>();
        for (int i = 0; i < saNames.length; ++i) {
            String saName = saNames[i];
            ServiceAssemblyServiceImpl.getLogger().log(Level.FINE, "Getting deployment descriptor for {0}", saName);
            try {
                String saDDText = this.getDeploymentServiceMBean().getServiceAssemblyDescriptor(saName);
                ServiceAssemblyInfo saInfo = ServiceAssemblyInfo.createFromServiceAssemblyDD((Reader)new StringReader(saDDText));
                this.updateServiceAssemblyInfoState(saInfo);
                saInfoByCompNameList.add(saInfo);
                continue;
            }
            catch (Exception e) {
                ServiceAssemblyServiceImpl.getLogger().log(Level.WARNING, "Unable to retrieve assembly descriptor", e);
            }
        }
        state = StateUtils.toFrameworkServiceAssemblyState(state);
        ArrayList<ServiceAssemblyInfo> saInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (state.equalsIgnoreCase("any")) {
            saInfoList.addAll(saInfoByCompNameList);
        } else {
            String uiState = StateUtils.toUiServiceAssemblyState(state);
            for (ServiceAssemblyInfo saInfo : saInfoByCompNameList) {
                if (!uiState.equalsIgnoreCase(saInfo.getState())) continue;
                saInfoList.add(saInfo);
            }
        }
        if (includeSUs) {
            for (ServiceAssemblyInfo saInfo : saInfoList) {
                this.updateEachServiceUnitInfoStateInServiceAssemblyInfo(saInfo);
            }
        }
        return saInfoByCompNameList;
    }

    public ServiceAssembly getServiceAssembly(String assemblyName) throws ManagementException {
        List<ServiceAssemblyInfo> saInfoList = this.searchServiceAssemblies(null, null, true);
        for (ServiceAssemblyInfo sAssembly : saInfoList) {
            if (!sAssembly.getName().equalsIgnoreCase(assemblyName)) continue;
            return ServiceAssemblyConverter.convert(sAssembly, true);
        }
        String[] args = new String[]{assemblyName};
        throw this.createComponentNotFoundException("rest.assembly.id.does.not.exist", args);
    }

    public String getDescriptorAsXml(String assemblyName, String serviceUnitName) throws ManagementException {
        this.checkServiceAssemblyExists(assemblyName);
        try {
            if (serviceUnitName == null) {
                return this.getDeploymentServiceMBean().getServiceAssemblyDescriptor(assemblyName);
            }
            return this.getDeploymentServiceMBean().getServiceUnitDescriptor(assemblyName, serviceUnitName);
        }
        catch (Exception e) {
            String[] args = new String[]{assemblyName};
            throw this.createManagementException("rest.assembly.descriptor.error", args, e);
        }
    }

    public Task start(String assemblyName) throws ManagementException {
        this.checkServiceAssemblyExists(assemblyName);
        try {
            String result = this.getDeploymentServiceMBean().start(assemblyName);
            if (result != null) {
                return this.getTaskFromString(assemblyName, result);
            }
            return null;
        }
        catch (Exception e) {
            String[] args = new String[]{assemblyName};
            throw this.createManagementException("rest.assembly.lifecycle.start.error", args, e);
        }
    }

    public Task stop(String assemblyName) throws ManagementException {
        this.checkServiceAssemblyExists(assemblyName);
        try {
            String result = this.getDeploymentServiceMBean().stop(assemblyName);
            if (result != null) {
                return this.getTaskFromString(assemblyName, result);
            }
            return null;
        }
        catch (Exception e) {
            String[] args = new String[]{assemblyName};
            throw this.createManagementException("rest.assembly.lifecycle.stop.error", args, e);
        }
    }

    public Task shutdown(String assemblyName, boolean force) throws ManagementException {
        this.checkServiceAssemblyExists(assemblyName);
        try {
            String result = this.getDeploymentServiceMBean().shutDown(assemblyName, force);
            if (result != null) {
                return this.getTaskFromString(assemblyName, result);
            }
            return null;
        }
        catch (Exception e) {
            String[] args = new String[]{assemblyName, Boolean.toString(force)};
            throw this.createManagementException("rest.assembly.lifecycle.shutdown.error", args, e);
        }
    }

    public Task undeploy(String assemblyName, boolean force) throws ManagementException {
        this.checkServiceAssemblyExists(assemblyName);
        try {
            String result = this.getDeploymentServiceMBean().undeploy(assemblyName, force);
            if (result != null) {
                return this.getTaskFromString(assemblyName, result);
            }
            return null;
        }
        catch (Exception e) {
            String[] args = new String[]{assemblyName, Boolean.toString(force)};
            throw this.createManagementException("rest.assembly.install.undeploy.error", args, e);
        }
    }

    public Task deploy(String serviceAssemblyZipUrl) throws ManagementException {
        try {
            String serviceAssemblyName = this.validateServiceAssembly(serviceAssemblyZipUrl);
            String result = this.getDeploymentServiceMBean().deploy(serviceAssemblyZipUrl);
            if (result != null) {
                return this.getTaskFromString(serviceAssemblyName, result);
            }
            return null;
        }
        catch (Exception e) {
            String[] args = new String[]{serviceAssemblyZipUrl};
            throw this.createManagementException("rest.assembly.install.deploy.error", args, e);
        }
    }

    private String validateServiceAssembly(String zipFilePath) {
        String name = null;
        try {
            URL url = new URL(zipFilePath);
            JBIArchive archive = new JBIArchive(url.getPath());
            if (archive.isServiceAssemblyArchive()) {
                ServiceAssemblyDD descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private void checkServiceAssemblyExists(String serviceAssemblyName) throws ManagementException {
        this.getServiceAssembly(serviceAssemblyName);
    }
}

