/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.management.system.ManagementContext;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.management.ObjectName;
import net.openesb.management.api.AdministrationService;
import net.openesb.management.api.ManagementException;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.model.api.Instance;
import net.openesb.model.api.Logger;

public class AdministrationServiceImpl
extends AbstractServiceImpl
implements AdministrationService {
    public Instance getInstance() throws ManagementException {
        Instance instance = new Instance();
        instance.setBuildNumber(this.getAdminServiceMBean().getBuildNumber());
        instance.setCopyright(this.getAdminServiceMBean().getCopyright());
        instance.setFullProductName(this.getAdminServiceMBean().getFullProductName());
        instance.setInstanceName(this.getAdminServiceMBean().getJbiInstanceName());
        instance.setMajorVersion(this.getAdminServiceMBean().getMajorVersion());
        instance.setMinorVersion(this.getAdminServiceMBean().getMinorVersion());
        instance.setShortProductName(this.getAdminServiceMBean().getShortProductName());
        instance.setSystemInfo(this.getAdminServiceMBean().getSystemInfo());
        return instance;
    }

    public Set<Logger> getLoggers() throws ManagementException {
        ObjectName[] objectNameLoggers = this.getSystemLoggerMBeans(this.getAdminServiceMBean().getJbiInstanceName());
        HashSet<Logger> loggers = new HashSet<Logger>(objectNameLoggers.length);
        for (ObjectName objectName : objectNameLoggers) {
            String loggerName = null;
            String logLevelString = null;
            String logDisplayName = null;
            try {
                AdministrationServiceImpl.getLogger().log(Level.FINE, "loggers: ObjectName = {0}", new Object[]{objectName});
                loggerName = (String)this.invokeMBeanOperation(objectName, "getLoggerName");
                AdministrationServiceImpl.getLogger().log(Level.FINE, "loggers[{0}]: name = {1}", new Object[]{objectName, loggerName});
                logLevelString = (String)this.invokeMBeanOperation(objectName, "getLogLevel");
                AdministrationServiceImpl.getLogger().log(Level.FINE, "level = {0}", logLevelString);
                logDisplayName = (String)this.invokeMBeanOperation(objectName, "getDisplayName");
                AdministrationServiceImpl.getLogger().log(Level.FINE, "displayName = {0}", logDisplayName);
                Logger runtimeLogger = new Logger(loggerName, Level.parse(logLevelString).getName());
                runtimeLogger.setLocalizedLevel(logLevelString);
                runtimeLogger.setDisplayName(logDisplayName);
                loggers.add(runtimeLogger);
            }
            catch (ManagementRemoteException exception) {
                AdministrationServiceImpl.getLogger().log(Level.SEVERE, "ManagementRemoteException", exception);
            }
            catch (RuntimeException exception) {
                AdministrationServiceImpl.getLogger().log(Level.SEVERE, "RuntimeException", exception);
            }
        }
        return loggers;
    }

    public void setLoggerLevel(String runtimeLoggerName, Level runtimeLoggerLevel) throws ManagementException {
        ObjectName[] objectNameLoggers;
        for (ObjectName objectName : objectNameLoggers = this.getSystemLoggerMBeans(this.getAdminServiceMBean().getJbiInstanceName())) {
            try {
                AdministrationServiceImpl.getLogger().log(Level.FINE, "loggers: ObjectName = {1}", new Object[]{objectName});
                String loggerName = (String)this.invokeMBeanOperation(objectName, "getLoggerName");
                if (!loggerName.equals(runtimeLoggerName)) continue;
                AdministrationServiceImpl.getLogger().log(Level.FINE, "Found the matching logger.");
                this.invokeMBeanOperation(objectName, this.setLevel(runtimeLoggerLevel));
            }
            catch (ManagementRemoteException exception) {
                AdministrationServiceImpl.getLogger().log(Level.SEVERE, "ManagementRemoteException", exception);
            }
            catch (RuntimeException exception) {
                AdministrationServiceImpl.getLogger().log(Level.SEVERE, "RuntimeException", exception);
            }
        }
    }

    public File getTempStore() {
        ManagementContext mc = new ManagementContext(this.getEnvironmentContext());
        return mc.getRepository().getTempStore();
    }
}

