/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.framework.ComponentLoggerMBean;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.management.AdminServiceMBean;
import com.sun.jbi.management.ComponentConfiguration;
import com.sun.jbi.management.ComponentExtensionMBean;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.management.DeploymentServiceMBean;
import com.sun.jbi.management.InstallationServiceMBean;
import com.sun.jbi.management.InstallerMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.ExceptionInfo;
import com.sun.jbi.management.message.JbiTask;
import com.sun.jbi.management.message.TaskResultDetailsElement;
import com.sun.jbi.management.message.TaskStatusMsg;
import com.sun.jbi.management.system.ConfigurationServiceMBean;
import com.sun.jbi.management.system.DeploymentServiceStatisticsMBean;
import com.sun.jbi.management.system.MessageServiceMBean;
import com.sun.jbi.messaging.MessageServiceStatisticsMBean;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import com.sun.jbi.util.ComponentConfigurationHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.openesb.management.api.ComponentNotFoundException;
import net.openesb.management.api.ManagementException;
import net.openesb.management.jmx.utils.I18NBundle;
import net.openesb.management.jmx.utils.StateUtils;
import net.openesb.model.api.State;
import net.openesb.model.api.manage.ComponentTask;
import net.openesb.model.api.manage.FrameworkTask;
import net.openesb.model.api.manage.Task;
import net.openesb.model.api.manage.TaskResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractServiceImpl {
    private static Logger sLogger = null;
    private static DeploymentServiceMBean deploymentService;
    private static DeploymentServiceStatisticsMBean deploymentServiceStatistics;
    private static InstallationServiceMBean installationService;
    private static InstallationServiceMBean installationServiceFacade;
    private static MessageServiceMBean messageService;
    private static ConfigurationServiceMBean configurationService;
    private static MessageServiceStatisticsMBean messageServiceStatistics;
    private static com.sun.jbi.management.system.AdminServiceMBean adminService;
    private static AdminServiceMBean adminServiceExtension;
    protected ComponentConfigurationHelper componentConfigurationHelper = new ComponentConfigurationHelper();
    private JAXBContext mJaxbContext;
    private JAXBContext mJbiDescriptorContext;
    private static I18NBundle I18NBUNDLE;
    protected static final String COMPONENT_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:component/jbi:identification/identification:VersionInfo";
    protected static final String SHARED_LIBRARY_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:shared-library/jbi:identification/identification:VersionInfo";
    protected static final String COMPONENT_VERSION_NS = "http://www.sun.com/jbi/descriptor/identification";
    protected static final String COMPONENT_VERSION_NS_NEW = "http://www.sun.com/jbi/descriptor/identification/v1.0";

    public static Logger getLogger() {
        if (sLogger == null) {
            sLogger = Logger.getLogger("net.openesb.management.jmx");
        }
        return sLogger;
    }

    protected PlatformContext getPlatformContext() {
        PlatformContext platformContext = null;
        com.sun.jbi.EnvironmentContext context = this.getEnvironmentContext();
        if (context != null) {
            platformContext = context.getPlatformContext();
        }
        return platformContext;
    }

    protected com.sun.jbi.EnvironmentContext getEnvironmentContext() {
        return EnvironmentContext.getInstance();
    }

    protected MBeanServer getPlatformContextMBeanServer() {
        return this.getPlatformContext().getMBeanServer();
    }

    protected String getPlatformContextTargetName() {
        return this.getPlatformContext().getTargetName();
    }

    protected synchronized com.sun.jbi.management.system.AdminServiceMBean getAdminServiceMBean() {
        if (adminService == null) {
            ObjectName adminServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName("AdminService", "AdministrationService");
            adminService = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), adminServiceObjectName, com.sun.jbi.management.system.AdminServiceMBean.class, false);
        }
        return adminService;
    }

    protected synchronized AdminServiceMBean getAdminServiceExtensionMBean() {
        if (adminServiceExtension == null) {
            ObjectName adminServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, this.getEnvironmentContext().getPlatformContext().getTargetName());
            adminServiceExtension = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), adminServiceObjectName, AdminServiceMBean.class, false);
        }
        return adminServiceExtension;
    }

    protected synchronized DeploymentServiceMBean getDeploymentServiceMBean() {
        if (deploymentService == null) {
            ObjectName deployServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, this.getEnvironmentContext().getPlatformContext().getInstanceName());
            deploymentService = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), deployServiceObjectName, DeploymentServiceMBean.class, false);
        }
        return deploymentService;
    }

    protected synchronized DeploymentServiceStatisticsMBean getDeploymentServiceStatisticsMBean() {
        if (deploymentServiceStatistics == null) {
            ObjectName deployServiceStatisticsObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName("DeploymentService", "Statistics", this.getEnvironmentContext().getPlatformContext().getInstanceName());
            deploymentServiceStatistics = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), deployServiceStatisticsObjectName, DeploymentServiceStatisticsMBean.class, false);
        }
        return deploymentServiceStatistics;
    }

    protected synchronized InstallationServiceMBean getInstallationServiceMBean() {
        if (installationService == null) {
            ObjectName installServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, this.getEnvironmentContext().getPlatformContext().getTargetName());
            installationService = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), installServiceObjectName, InstallationServiceMBean.class, false);
        }
        return installationService;
    }

    protected synchronized InstallationServiceMBean getInstallationServiceFacadeMBean() {
        if (installationServiceFacade == null) {
            ObjectName installServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName("InstallationService", "InstallationService");
            installationServiceFacade = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), installServiceObjectName, InstallationServiceMBean.class, false);
        }
        return installationServiceFacade;
    }

    protected synchronized MessageServiceMBean getMessageServiceMBean() {
        if (messageService == null) {
            ObjectName messageServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName("MessageService", "MessageService");
            messageService = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), messageServiceObjectName, MessageServiceMBean.class, false);
        }
        return messageService;
    }

    protected synchronized MessageServiceStatisticsMBean getMessageServiceStatisticsMBean() {
        if (messageServiceStatistics == null) {
            ObjectName messageStatisticsServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName("MessageService", "Statistics");
            messageServiceStatistics = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), messageStatisticsServiceObjectName, MessageServiceStatisticsMBean.class, false);
        }
        return messageServiceStatistics;
    }

    protected synchronized ConfigurationServiceMBean getConfigurationServiceMBean() {
        if (configurationService == null) {
            ObjectName configurationServiceObjectName = this.getEnvironmentContext().getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, MBeanNames.ServiceType.Logger, this.getEnvironmentContext().getPlatformContext().getTargetName());
            configurationService = MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), configurationServiceObjectName, ConfigurationServiceMBean.class, false);
        }
        return configurationService;
    }

    protected ComponentLifeCycleMBean getComponentLifecycleMBean(String component) throws ManagementException {
        ObjectName componentLifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(component);
        return MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), componentLifecycleObjectName, ComponentLifeCycleMBean.class, false);
    }

    protected ComponentExtensionMBean getComponentExtensionMBean(String component) throws ManagementException {
        ObjectName componentExtensionObjectName = this.getComponentExtensionMBeanObjectName(component);
        return MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), componentExtensionObjectName, ComponentExtensionMBean.class, false);
    }

    protected ComponentConfiguration getComponentConfigurationMBean(String component) throws ManagementException {
        ObjectName componentConfigurationObjectName = this.getComponentConfigurationMBeanObjectName(component);
        return MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), componentConfigurationObjectName, ComponentConfiguration.class, false);
    }

    protected InstallerMBean getComponentInstallerMBean(ObjectName componentInstallerObjectName) throws ManagementRemoteException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), componentInstallerObjectName, InstallerMBean.class, false);
    }

    protected ComponentLoggerMBean getComponentLoggerMBean(ObjectName componentLoggerObjectName) throws ManagementRemoteException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getPlatformContextMBeanServer(), componentLoggerObjectName, ComponentLoggerMBean.class, false);
    }

    protected ObjectName[] getSystemLoggerMBeans(String instanceName) {
        MBeanNames mbn = this.getEnvironmentContext().getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":JbiName=" + instanceName;
        tmp = tmp + ",ComponentType=System";
        tmp = tmp + ",ControlType=Logger";
        tmp = tmp + ",*";
        ObjectName mbeanPattern = null;
        try {
            mbeanPattern = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException mex) {
            return new ObjectName[0];
        }
        Set<ObjectName> resultSet = this.getEnvironmentContext().getMBeanServer().queryNames(mbeanPattern, null);
        ObjectName[] names = new ObjectName[]{};
        if (!resultSet.isEmpty()) {
            names = resultSet.toArray(names);
        } else {
            AbstractServiceImpl.getLogger().log(Level.FINE, "Logger MBeans with ObjectName pattern {0} not found.", tmp);
        }
        return names;
    }

    private synchronized JAXBContext getJaxbContext() throws Exception {
        if (this.mJaxbContext == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.message.JbiTaskResult").getClassLoader();
            this.mJaxbContext = JAXBContext.newInstance((String)"com.sun.jbi.management.message", (ClassLoader)cl);
        }
        return this.mJaxbContext;
    }

    protected synchronized JAXBContext getJbiDescriptorContext() throws Exception {
        if (this.mJbiDescriptorContext == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.descriptor.Jbi").getClassLoader();
            this.mJbiDescriptorContext = JAXBContext.newInstance((String)"com.sun.jbi.management.descriptor", (ClassLoader)cl);
        }
        return this.mJbiDescriptorContext;
    }

    private Object unmarshal(StreamSource input) throws Exception {
        Unmarshaller reader = this.getJaxbContext().createUnmarshaller();
        return reader.unmarshal((Source)input);
    }

    protected Task getTaskFromString(String component, String jbiTaskMsg) throws Exception {
        JbiTask jbiTask = this.getJbiTaskFromString(jbiTaskMsg);
        Task task = new Task();
        task.setComponent(component);
        FrameworkTask fwkTask = new FrameworkTask();
        fwkTask.setResult(this.convert(jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails()));
        task.setFrameworkTask(fwkTask);
        for (ComponentTaskResult compTaskResult : jbiTask.getJbiTaskResult().getComponentTaskResult()) {
            ComponentTask compTask = new ComponentTask();
            compTask.setComponent(compTaskResult.getComponentName());
            compTask.setResult(this.convert(compTaskResult.getComponentTaskResultDetails().getTaskResultDetails()));
            task.getComponentsTask().add(compTask);
        }
        return task;
    }

    private TaskResult convert(TaskResultDetailsElement details) {
        ArrayList<String> messages;
        TaskResult result = new TaskResult();
        result.setTaskId(details.getTaskId());
        result.setTaskResult(TaskResult.TaskResultType.convert((String)details.getTaskResult()));
        result.setMessageType(TaskResult.MessageType.convert((String)details.getMessageType()));
        if (details.getTaskStatusMsg() != null) {
            messages = new ArrayList<String>(details.getTaskStatusMsg().size());
            for (TaskStatusMsg msg : details.getTaskStatusMsg()) {
                messages.add(msg.getMsgLocInfo().getLocToken() + " : " + msg.getMsgLocInfo().getLocMessage());
            }
            result.setTaskStatusMsg(messages);
        }
        if (details.getExceptionInfo() != null) {
            messages = new ArrayList(details.getExceptionInfo().size());
            for (ExceptionInfo error : details.getExceptionInfo()) {
                messages.add(error.getMsgLocInfo().getLocToken() + " : " + error.getMsgLocInfo().getLocMessage());
            }
            result.setErrorMsg(messages);
        }
        return result;
    }

    private JbiTask getJbiTaskFromString(String jbiTaskMsg) throws Exception {
        StringBuilder strBuf = new StringBuilder(jbiTaskMsg);
        return (JbiTask)this.unmarshal(new StreamSource(new StringReader(strBuf.toString())));
    }

    protected String getComponentNameFromJmxObjectName(ObjectName jmxObjectName) {
        String componentName = null;
        try {
            componentName = jmxObjectName.getKeyProperty("ComponentName");
        }
        catch (NullPointerException nullEx) {
            componentName = null;
        }
        return componentName;
    }

    protected boolean isExistingComponent(String componentName) {
        List list = new ArrayList();
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        if (componentQuery != null) {
            list = componentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        }
        return list.contains(componentName);
    }

    private ObjectName getComponentLifeCycleMBeanObjectName(String componentName) throws ManagementException {
        AbstractServiceImpl.getLogger().log(Level.FINE, "Get Component Lifecycle MBean Name for component {0}", componentName);
        ObjectName lifecycleObjectNamePattern = null;
        try {
            lifecycleObjectNamePattern = JBIJMXObjectNames.getComponentLifeCycleMBeanObjectNamePattern((String)componentName, (String)this.getPlatformContextTargetName());
        }
        catch (MalformedObjectNameException ex) {
            String[] args = new String[]{componentName, this.getPlatformContextTargetName()};
            throw this.createManagementException("rest.component.lifecycle.mbean.bad.name", args, ex);
        }
        MBeanServer mbeanServer = this.getPlatformContextMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(lifecycleObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            String[] args = new String[]{componentName, this.getPlatformContextTargetName()};
            throw this.createManagementException("rest.component.lifecycle.mbean.not.found.with.query", args, null);
        }
        if (objectNames.size() > 1) {
            String[] args = new String[]{componentName, this.getPlatformContextTargetName()};
            throw this.createManagementException("rest.component.lifecycle.multiple.mbeans.found.with.query", args, null);
        }
        ObjectName lifecyleObjectName = objectNames.iterator().next();
        AbstractServiceImpl.getLogger().log(Level.FINE, "LifecyleMBean : {0}", lifecyleObjectName);
        return lifecyleObjectName;
    }

    private ObjectName getComponentExtensionMBeanObjectName(String componentName) throws ManagementException {
        AbstractServiceImpl.getLogger().log(Level.FINE, "Get Component Extension MBean Name for component {0}", componentName);
        ObjectName componentExtensionMBean = this.getAdminServiceExtensionMBean().getComponentExtensionFacadeMBean(componentName);
        AbstractServiceImpl.getLogger().log(Level.FINE, "ExtensionMBean : {0}", componentExtensionMBean);
        return componentExtensionMBean;
    }

    protected ObjectName getComponentConfigurationMBeanObjectName(String componentName) throws ManagementException {
        ObjectName configurationObjectName;
        AbstractServiceImpl.getLogger().log(Level.FINE, "Get Component Configuration MBean Name for component {0}", componentName);
        ComponentExtensionMBean extensionMBean = this.getComponentExtensionMBean(componentName);
        try {
            configurationObjectName = extensionMBean.getComponentConfigurationFacadeMBeanName(this.getPlatformContextTargetName());
        }
        catch (JBIException ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.config.mbean.not.found.error", args, (Exception)((Object)ex));
        }
        AbstractServiceImpl.getLogger().log(Level.FINE, "ConfigurationMBean : {0}", configurationObjectName);
        return configurationObjectName;
    }

    public Map<String, Object> getComponentConfigurationProperties(String componentName) throws ManagementException {
        ObjectName configurationObjectName = this.getComponentConfigurationMBeanObjectName(componentName);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            MBeanInfo mbeanInfo = this.getPlatformContextMBeanServer().getMBeanInfo(configurationObjectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                String key = attributeInfo.getName();
                if (key == null) continue;
                Object value = null;
                try {
                    value = this.getPlatformContextMBeanServer().getAttribute(configurationObjectName, key);
                }
                catch (Exception ex) {
                    String[] args = new String[]{componentName, configurationObjectName.toString()};
                    throw this.createManagementException("rest.component.config.mbean.error.get.attrs.error", args, ex);
                }
                if (value == null || key.equals("ApplicationVariables") || key.equals("ApplicationConfigurations")) continue;
                properties.put(key, value);
            }
        }
        catch (Exception ex) {
            String[] args = new String[]{componentName, configurationObjectName.toString()};
            throw this.createManagementException("rest.component.config.mbean.error.get.attrs.error", args, ex);
        }
        return properties;
    }

    protected boolean isAppVarsSupported(String componentName) throws ManagementException {
        AbstractServiceImpl.getLogger().log(Level.FINE, "isAppVarsSupported({0})", componentName);
        try {
            ObjectName componentConfigMBean = this.getComponentConfigurationMBeanObjectName(componentName);
            boolean isAppVarsSupported = (Boolean)this.invokeMBeanOperation(componentConfigMBean, "isAppVarsSupported", new Object[0], new String[0]);
            AbstractServiceImpl.getLogger().log(Level.FINE, "isAppVarsSupported(): result = {0}", isAppVarsSupported);
            return isAppVarsSupported;
        }
        catch (Exception ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.config.mbean.not.found.error", args, ex);
        }
    }

    protected boolean isAppConfigSupported(String componentName) throws ManagementException {
        AbstractServiceImpl.getLogger().log(Level.FINE, "isAppConfigSupported({0})", componentName);
        ObjectName componentConfigMBean = this.getComponentConfigurationMBeanObjectName(componentName);
        try {
            boolean isAppConfigSupported = (Boolean)this.invokeMBeanOperation(componentConfigMBean, "isAppConfigSupported", new Object[0], new String[0]);
            AbstractServiceImpl.getLogger().log(Level.FINE, "isAppConfigSupported(): result = {0}", isAppConfigSupported);
            return isAppConfigSupported;
        }
        catch (Exception ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.config.mbean.not.found.error", args, ex);
        }
    }

    protected boolean isComponentConfigSupported(String componentName) throws ManagementException {
        AbstractServiceImpl.getLogger().log(Level.FINE, "isComponentConfigSupported({0})", componentName);
        try {
            ObjectName componentConfigMBean = this.getComponentConfigurationMBeanObjectName(componentName);
            boolean isComponentConfigSupported = (Boolean)this.invokeMBeanOperation(componentConfigMBean, "isComponentConfigSupported", new Object[0], new String[0]);
            AbstractServiceImpl.getLogger().log(Level.FINE, "isComponentConfigSupported(): result = {0}", isComponentConfigSupported);
            return isComponentConfigSupported;
        }
        catch (Exception ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.config.mbean.not.found.error", args, ex);
        }
    }

    protected String setMBeanConfigAttributes(ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.getPlatformContextMBeanServer();
        return this.setMBeanConfigAttributes(mbeanServer, objectName, attrList);
    }

    protected AttributeList constructMBeanAttributes(ObjectName objectName, Map<String, Object> params) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.getPlatformContextMBeanServer();
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo attrInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(attrInfo.getName(), attrInfo);
            }
            for (String attrName : params.keySet()) {
                Object attrValueObj = params.get(attrName);
                Attribute attr = new Attribute(attrName, attrValueObj);
                attrList.add(attr);
            }
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return attrList;
    }

    protected String setMBeanConfigAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        try {
            return (String)mbeanServer.invoke(objectName, "setConfigurationAttributes", new Object[]{attrList}, new String[]{"javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName) throws ManagementRemoteException {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.getPlatformContextMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.invoke(objectName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected String setLevel(Level logLevel) {
        if (null == logLevel) {
            return "setDefault";
        }
        if (Level.OFF.equals(logLevel)) {
            return "setOff";
        }
        if (Level.SEVERE.equals(logLevel)) {
            return "setSevere";
        }
        if (Level.WARNING.equals(logLevel)) {
            return "setWarning";
        }
        if (Level.INFO.equals(logLevel)) {
            return "setInfo";
        }
        if (Level.CONFIG.equals(logLevel)) {
            return "setConfig";
        }
        if (Level.FINE.equals(logLevel)) {
            return "setFine";
        }
        if (Level.FINER.equals(logLevel)) {
            return "setFiner";
        }
        if (Level.FINEST.equals(logLevel)) {
            return "setFinest";
        }
        if (Level.ALL.equals(logLevel)) {
            return "setAll";
        }
        return "setDefault";
    }

    protected void updateServiceAssemblyInfoState(ServiceAssemblyInfo saInfo) {
        String saName = saInfo.getName();
        String frameworkState = "any";
        try {
            frameworkState = this.getDeploymentServiceMBean().getState(saName);
        }
        catch (Exception ex) {
            AbstractServiceImpl.getLogger().log(Level.FINE, "issue 30: state invalid: {0}", ex.getMessage());
            frameworkState = "unknown";
        }
        AbstractServiceImpl.getLogger().log(Level.FINE, "Framework State = {0} for Service Assembly = {1}", new Object[]{frameworkState, saName});
        String uiState = StateUtils.toUiServiceAssemblyState(frameworkState);
        saInfo.setState(uiState);
    }

    protected void updateEachServiceUnitInfoStateInServiceAssemblyInfo(ServiceAssemblyInfo saInfo) {
        List list = saInfo.getServiceUnitInfoList();
        if (list == null) {
            return;
        }
        for (ServiceUnitInfo suInfo : list) {
            this.updateServiceUnitInfoState(suInfo);
        }
    }

    protected void updateServiceUnitInfoState(ServiceUnitInfo suInfo) {
        suInfo.setState("Unknown");
        String compName = suInfo.getDeployedOn();
        String suName = suInfo.getName();
        try {
            String frameworkState = this.getDeploymentServiceMBean().getServiceUnitState(compName, suName);
            AbstractServiceImpl.getLogger().log(Level.FINE, "Framework State = {0} for Service UNIT {1}", new Object[]{frameworkState, suName});
            String uiState = StateUtils.toUiServiceUnitState(frameworkState);
            suInfo.setState(uiState);
        }
        catch (Exception ex) {
            AbstractServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
    }

    protected List getFrameworkComponentInfoListForSharedLibraryNames(Collection slibNameList) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                Iterator itr = slibNameList.iterator();
                while (itr.hasNext()) {
                    ComponentInfo componentInfo = componentQuery.getSharedLibraryInfo((String)itr.next());
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            AbstractServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
        return compInfoList;
    }

    protected Collection<String> getComponentNamesDependentOnSharedLibrary(String slibName) {
        List<String> componentNames = new ArrayList<String>();
        try {
            ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                componentNames = componentQuery.getDependentComponentIds(slibName);
            }
        }
        catch (Exception ex) {
            AbstractServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
        return componentNames;
    }

    protected void checkComponentExists(String componentName) throws ManagementException {
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        ComponentInfo componentInfo = null;
        if (componentQuery != null) {
            componentInfo = componentQuery.getComponentInfo(componentName);
        }
        if (componentInfo == null) {
            throw this.createComponentNotFoundException("rest.component.id.does.not.exist", new String[]{componentName});
        }
    }

    protected ManagementException createManagementException(String bundleKey, String[] args, Exception sourceException) {
        String message = AbstractServiceImpl.getI18NBundle().getMessage(bundleKey, args);
        if (sourceException != null) {
            AbstractServiceImpl.getLogger().log(Level.SEVERE, message, sourceException);
        } else {
            AbstractServiceImpl.getLogger().log(Level.SEVERE, message);
        }
        return new ManagementException(message, (Throwable)sourceException);
    }

    protected ManagementException createManagementException(String bundleKey, String[] args) {
        return this.createManagementException(bundleKey, args, null);
    }

    protected ManagementException createManagementException(String taskString) {
        try {
            return new ManagementException(this.getTaskFromString(null, taskString));
        }
        catch (Exception ex) {
            return new ManagementException(ex.getMessage());
        }
    }

    protected ComponentNotFoundException createComponentNotFoundException(String bundleKey, String[] args) {
        String message = AbstractServiceImpl.getI18NBundle().getMessage(bundleKey, args);
        AbstractServiceImpl.getLogger().log(Level.SEVERE, message);
        return new ComponentNotFoundException(message);
    }

    protected static I18NBundle getI18NBundle() {
        if (I18NBUNDLE == null) {
            I18NBUNDLE = new I18NBundle("net.openesb.management.jmx");
        }
        return I18NBUNDLE;
    }

    protected List<JBIComponentInfo> toUiComponentInfoList(List<ComponentInfo> frameworkCompList) throws ManagementException {
        ArrayList<JBIComponentInfo> uiCompList = new ArrayList<JBIComponentInfo>(frameworkCompList.size());
        for (ComponentInfo frameworkCompInfo : frameworkCompList) {
            JBIComponentInfo uiCompInfo = this.toUiComponentInfo(frameworkCompInfo);
            uiCompList.add(uiCompInfo);
        }
        return uiCompList;
    }

    protected JBIComponentInfo toUiComponentInfo(ComponentInfo frameworkCompInfo) throws ManagementException {
        String state = "Unknown";
        String componentName = frameworkCompInfo.getName();
        String componentDescription = frameworkCompInfo.getDescription();
        ComponentState componentStatus = ComponentState.UNKNOWN;
        ComponentType componentType = frameworkCompInfo.getComponentType();
        if (!(ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType))) {
            componentStatus = frameworkCompInfo.getStatus();
            state = StateUtils.toUiComponentInfoState(componentStatus);
        } else {
            try {
                state = this.getComponentLifecycleMBean(componentName).getCurrentState();
            }
            catch (ManagementException ex) {
                componentStatus = ComponentState.UNKNOWN;
                state = "Unknown";
            }
        }
        if ("Running".equals(state)) {
            state = "Started";
        }
        String type = StateUtils.toUiComponentInfoType(componentType);
        String componentVersion = State.UNKNOWN.name();
        String buildNumber = State.UNKNOWN.name();
        try {
            String descriptorXml = frameworkCompInfo.getInstallationDescriptor();
            InputSource inputSource = new InputSource(new StringReader(descriptorXml));
            String queryString = "";
            if (ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType)) {
                queryString = COMPONENT_VERSION_XPATH_QUERY;
            } else if (ComponentType.SHARED_LIBRARY.equals((Object)componentType)) {
                queryString = SHARED_LIBRARY_VERSION_XPATH_QUERY;
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new IdentificationNSContext());
            Node rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
            if (rtnNode != null) {
                Node buildAttr;
                NamedNodeMap attrs = rtnNode.getAttributes();
                Node verAttr = attrs.getNamedItem("specification-version");
                if (verAttr != null) {
                    componentVersion = verAttr.getNodeValue();
                }
                if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                    buildNumber = buildAttr.getNodeValue();
                }
            } else {
                inputSource = new InputSource(new StringReader(descriptorXml));
                xpath.setNamespaceContext(new IdentificationNewNSContext());
                rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
                if (rtnNode != null) {
                    Node buildAttr;
                    NamedNodeMap attrs = rtnNode.getAttributes();
                    Node verAttr = attrs.getNamedItem("component-version");
                    if (verAttr != null) {
                        componentVersion = verAttr.getNodeValue();
                    }
                    if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                        buildNumber = buildAttr.getNodeValue();
                    }
                }
            }
        }
        catch (Exception exp) {
            String[] args = new String[]{""};
            Exception exception = new Exception("ui.mbean.install.config.mbean.error.get.attrs.error");
            throw new ManagementException((Throwable)exception);
        }
        JBIComponentInfo compInfo = new JBIComponentInfo(type, state, componentName, componentDescription);
        compInfo.setComponentVersion(componentVersion);
        compInfo.setBuildNumber(buildNumber);
        return compInfo;
    }

    static {
        I18NBUNDLE = null;
    }

    class IdentificationNewNSContext
    implements NamespaceContext {
        IdentificationNewNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractServiceImpl.COMPONENT_VERSION_NS_NEW;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    class IdentificationNSContext
    implements NamespaceContext {
        IdentificationNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractServiceImpl.COMPONENT_VERSION_NS;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

