/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.SharedLibraryService;
import net.openesb.model.api.ComponentDescriptor;
import net.openesb.model.api.SharedLibrary;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;

@RequiresAuthentication
public class SharedLibraryResource
extends AbstractResource {
    @Inject
    private SharedLibraryService sharedLibraryService;
    private final String sharedLibraryName;

    public SharedLibraryResource(String sharedLibraryName) {
        this.sharedLibraryName = sharedLibraryName;
    }

    @GET
    @Produces(value={"application/json"})
    public SharedLibrary getSharedLibrary() throws ManagementException {
        return this.sharedLibraryService.getSharedLibrary(this.sharedLibraryName);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/json"})
    public ComponentDescriptor getComponentDescriptor() throws ManagementException {
        return this.sharedLibraryService.getDescriptor(this.sharedLibraryName);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getComponentDescriptorAsXML() throws ManagementException {
        return this.sharedLibraryService.getDescriptorAsXml(this.sharedLibraryName);
    }

    @DELETE
    public Response uninstall() throws ManagementException {
        this.sharedLibraryService.uninstall(this.sharedLibraryName);
        return Response.ok().build();
    }
}

