/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ComponentService;
import net.openesb.management.api.ComponentType;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.JBIComponent;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.ComponentResource;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/components")
@RequiresAuthentication
public class ComponentsResource
extends AbstractResource {
    @Inject
    private ComponentService componentService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    public Set<JBIComponent> listComponents(@QueryParam(value="type") String type, @QueryParam(value="state") String state, @QueryParam(value="library") String sharedLibraryName, @QueryParam(value="assembly") String serviceAssemblyName) throws ManagementException {
        ComponentType componentType = ComponentType.BINDINGS_AND_ENGINES;
        if (type != null && type.trim().length() > 0) {
            if (type.equalsIgnoreCase(ComponentType.BINDING.name())) {
                componentType = ComponentType.BINDING;
            } else if (type.equalsIgnoreCase(ComponentType.ENGINE.name())) {
                componentType = ComponentType.ENGINE;
            }
        }
        TreeSet<JBIComponent> components = new TreeSet<JBIComponent>(new Comparator<JBIComponent>(){

            @Override
            public int compare(JBIComponent comp1, JBIComponent comp2) {
                return comp1.getName().compareTo(comp2.getName());
            }
        });
        components.addAll(this.componentService.findComponents(componentType, state, sharedLibraryName, serviceAssemblyName));
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public Response install(@FormDataParam(value="component") InputStream is, @FormDataParam(value="component") FormDataContentDisposition fileDisposition) throws ManagementException {
        File compArchive = null;
        try {
            compArchive = this.createTemporaryFile(is, fileDisposition.getFileName());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "I/O errors while uploading the component archive.", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
        if (compArchive != null) {
            String componentName = this.componentService.install(compArchive.getAbsolutePath());
            return Response.ok().entity((Object)componentName).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{component}")
    public ComponentResource getComponentResource(@PathParam(value="component") String componentName) {
        return (ComponentResource)this.resourceContext.initResource((Object)new ComponentResource(componentName));
    }
}

