/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.provider;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;

@Provider
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper defaultObjectMapper = ObjectMapperProvider.createDefaultMapper();

    public ObjectMapper getContext(Class<?> type) {
        return this.defaultObjectMapper;
    }

    private static ObjectMapper createDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        AnnotationIntrospector ai = AnnotationIntrospector.pair((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()), (AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.setAnnotationIntrospector(ai);
        SimpleModule customModule = new SimpleModule("OpenesbModule", new Version(1, 0, 0, null));
        customModule.addSerializer((JsonSerializer)new QNameSerializer());
        mapper.registerModule((Module)customModule);
        return mapper;
    }

    private static class QNameSerializer
    extends StdSerializer<QName> {
        private QNameSerializer() {
            super(QName.class);
        }

        public void serialize(QName value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("namespaceURI", value.getNamespaceURI());
            jgen.writeStringField("localPart", value.getLocalPart());
            jgen.writeEndObject();
        }
    }
}

