/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.model.ui.resolver;

import com.sun.jbi.management.descriptor.Connection;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.descriptor.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openesb.rest.api.model.ui.resolver.ConnectionPoint;

public abstract class Resolver<V> {
    private Map<ConnectionPoint, V> mapLink;
    private String targetComponent;
    private Jbi jbiServiceUnit;

    public Resolver(Jbi jbiServiceUnit, String targetComponent) {
        this.jbiServiceUnit = jbiServiceUnit;
        this.targetComponent = targetComponent;
        this.mapLink = this.map(jbiServiceUnit);
    }

    public V resolve(Connection connection) {
        ConnectionPoint providerConnectionLink = this.toConnectionPoint(connection);
        return this.mapLink.get(providerConnectionLink);
    }

    protected Map<ConnectionPoint, V> map(Jbi jbi) {
        HashMap<ConnectionPoint, V> res = new HashMap<ConnectionPoint, V>();
        Services services = this.jbiServiceUnit.getServices();
        if (services != null) {
            for (V consumes : this.extractEntities(services)) {
                res.put(this.toConnectionPoint(consumes), consumes);
            }
        }
        return res;
    }

    public Jbi getJbiServiceUnit() {
        return this.jbiServiceUnit;
    }

    public String getTargetComponent() {
        return this.targetComponent;
    }

    protected abstract ConnectionPoint toConnectionPoint(Connection var1);

    protected abstract ConnectionPoint toConnectionPoint(V var1);

    protected abstract List<V> extractEntities(Services var1);
}

