/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.service.ui;

import com.sun.jbi.management.descriptor.Connection;
import com.sun.jbi.management.descriptor.Consumer;
import com.sun.jbi.management.descriptor.Consumes;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.descriptor.Provider;
import com.sun.jbi.management.descriptor.Provides;
import com.sun.jbi.management.descriptor.ServiceAssembly;
import com.sun.jbi.management.descriptor.ServiceUnit;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.ManagementFactory;
import net.openesb.management.api.ServiceAssemblyService;
import net.openesb.rest.api.model.ui.Connector;
import net.openesb.rest.api.model.ui.Model;
import net.openesb.rest.api.model.ui.resolver.ConsumesResolver;
import net.openesb.rest.api.model.ui.resolver.Link;
import net.openesb.rest.api.model.ui.resolver.ProvidesResolver;
import net.openesb.rest.api.service.ui.MapService;
import net.openesb.rest.utils.ConnectionPointBuilder;
import net.openesb.rest.utils.Mapper;
import net.openesb.rest.utils.UIDUtils;

public class MapServiceImpl
implements MapService {
    private static final String ENGINE_SUFFIX = "-engine";
    private ServiceAssemblyService serviceAssemblyService = ManagementFactory.getServiceAssemblyService();
    private JAXBContext mJbiDescriptorContext;
    private static final Logger LOG = Logger.getLogger(MapServiceImpl.class.getPackage().getName());

    protected synchronized JAXBContext getJbiDescriptorContext() throws Exception {
        if (this.mJbiDescriptorContext == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.descriptor.Jbi").getClassLoader();
            this.mJbiDescriptorContext = JAXBContext.newInstance((String)"com.sun.jbi.management.descriptor", (ClassLoader)cl);
        }
        return this.mJbiDescriptorContext;
    }

    @Override
    public Model getMapModel(String assemblyName) throws ManagementException {
        LOG.info("getMapModel " + assemblyName);
        Model model = new Model();
        try {
            Unmarshaller unmarshaller = this.getJbiDescriptorContext().createUnmarshaller();
            String descriptorContent = this.serviceAssemblyService.getDescriptorAsXml(assemblyName, null);
            StringReader reader = new StringReader(descriptorContent);
            Jbi jbi = (Jbi)unmarshaller.unmarshal((Reader)reader);
            ServiceAssembly serviceAssembly = jbi.getServiceAssembly();
            List serviceUnits = serviceAssembly.getServiceUnit();
            ArrayList<ConsumesResolver> consumesResolvers = new ArrayList<ConsumesResolver>();
            ArrayList<ProvidesResolver> providesResolvers = new ArrayList<ProvidesResolver>();
            if (serviceUnits != null) {
                for (ServiceUnit serviceUnit : serviceUnits) {
                    String suName = serviceUnit.getIdentification().getName();
                    reader = new StringReader(this.serviceAssemblyService.getDescriptorAsXml(assemblyName, suName));
                    Jbi serviceUnitJbi = (Jbi)unmarshaller.unmarshal((Reader)reader);
                    String target = serviceUnit.getTarget().getComponentName();
                    consumesResolvers.add(new ConsumesResolver(serviceUnitJbi, target));
                    providesResolvers.add(new ProvidesResolver(serviceUnitJbi, target));
                    if (serviceUnitJbi.getServices().isBindingComponent()) continue;
                    model.getAssemblies().add(Mapper.getCasa(suName, serviceUnitJbi));
                }
            }
            HashMap<String, Connector> connectorsMap = new HashMap<String, Connector>();
            for (Connection connection : serviceAssembly.getConnections().getConnection()) {
                Connector connector;
                Connector connector2;
                int nbResolution = 0;
                Consumer consumer = connection.getConsumer();
                Provider provider = connection.getProvider();
                Link link = new Link(ConnectionPointBuilder.getConnectionPoint(consumer), ConnectionPointBuilder.getConnectionPoint(provider));
                for (ProvidesResolver providesResolver : providesResolvers) {
                    net.openesb.rest.api.model.ui.Provides provides = new net.openesb.rest.api.model.ui.Provides((Provides)providesResolver.resolve(connection));
                    if (provides.getTarget() == null) continue;
                    ++nbResolution;
                    if (providesResolver.getTargetComponent().endsWith(ENGINE_SUFFIX)) {
                        LOG.log(Level.FINE, "Ignoring provides : [{}] [{}] [{}]", new Object[]{provides.getDisplayName(), provides.getProcessName(), provides.getTarget().getInterfaceName()});
                        continue;
                    }
                    link.setType(providesResolver.getTargetComponent());
                    connector2 = new Connector();
                    connector2.setType(providesResolver.getTargetComponent());
                    connector2.setName(provides.getTarget().getInterfaceName().getLocalPart());
                    connector2.setConnectionPoint(ConnectionPointBuilder.getConnectionPoint(provides.getTarget()));
                    connectorsMap.put(UIDUtils.getUID(provides.getTarget()), connector2);
                    LOG.log(Level.FINE, "[P][{}]Provides resolved {} ({})", new Object[]{nbResolution, provides.getTarget().getEndpointName(), connection.getProvider().getServiceName()});
                }
                if (nbResolution == 0) {
                    LOG.log(Level.FINE, "Unresolved provide : {}", connection.getProvider().getEndpointName());
                    connector = new Connector();
                    connector.setType("sun-bpel-engine");
                    connector.setName(provider.getEndpointName());
                    connector.setConnectionPoint(ConnectionPointBuilder.getConnectionPoint(provider));
                    connectorsMap.put(UIDUtils.getUID(provider), connector);
                }
                nbResolution = 0;
                for (ConsumesResolver consumeResolver : consumesResolvers) {
                    net.openesb.rest.api.model.ui.Consumes consumes = new net.openesb.rest.api.model.ui.Consumes((Consumes)consumeResolver.resolve(connection));
                    if (consumes.getTarget() == null) continue;
                    ++nbResolution;
                    if (consumeResolver.getTargetComponent().endsWith(ENGINE_SUFFIX)) {
                        LOG.log(Level.FINE, "Ignoring consumes : [{}] [{}] [{}]", new Object[]{consumes.getDisplayName(), consumes.getProcessName(), consumes.getTarget().getInterfaceName()});
                        continue;
                    }
                    link.setType(consumeResolver.getTargetComponent());
                    connector2 = new Connector();
                    connector2.setType(consumeResolver.getTargetComponent());
                    connector2.setName(consumes.getTarget().getInterfaceName().getLocalPart());
                    connector2.setConnectionPoint(ConnectionPointBuilder.getConnectionPoint(consumes.getTarget()));
                    connectorsMap.put(UIDUtils.getUID(consumes.getTarget()), connector2);
                    LOG.log(Level.FINE, "[C][{}]Consumer resolved {} ({})", new Object[]{nbResolution, consumes.getTarget().getEndpointName(), connection.getConsumer().getServiceName()});
                }
                if (nbResolution == 0) {
                    LOG.log(Level.FINE, "Unresolved consumes : {}", connection.getConsumer().getEndpointName());
                    connector = new Connector();
                    connector.setType("sun-bpel-engine");
                    connector.setName(connection.getConsumer().getInterfaceName().getLocalPart());
                    connector.setConnectionPoint(ConnectionPointBuilder.getConnectionPoint(connection.getConsumer()));
                    connectorsMap.put(UIDUtils.getUID(connection.getConsumer()), connector);
                }
                model.getLinks().add(link);
            }
            model.getConnectors().addAll(connectorsMap.values());
        }
        catch (Exception jaxbe) {
            LOG.log(Level.SEVERE, "Unable to create map for service assembly", jaxbe);
        }
        return model;
    }
}

