/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.SharedLibraryService;
import net.openesb.model.api.SharedLibrary;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.SharedLibraryResource;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="libraries")
@RequiresAuthentication
public class SharedLibrariesResource
extends AbstractResource {
    @Inject
    private SharedLibraryService sharedLibraryService;
    @Inject
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    public Set<SharedLibrary> listSharedLibraries(@QueryParam(value="component") String componentName) throws ManagementException {
        TreeSet<SharedLibrary> libraries = new TreeSet<SharedLibrary>(new Comparator<SharedLibrary>(){

            @Override
            public int compare(SharedLibrary lib1, SharedLibrary lib2) {
                return lib1.getName().compareTo(lib2.getName());
            }
        });
        libraries.addAll(this.sharedLibraryService.findSharedLibraries(componentName));
        return libraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response install(@FormDataParam(value="sharedLibrary") InputStream is, @FormDataParam(value="sharedLibrary") FormDataContentDisposition fileDisposition) throws ManagementException {
        File slArchive = null;
        try {
            slArchive = this.createTemporaryFile(is, fileDisposition.getFileName());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "I/O errors while uploading the sharedlibraries archive.", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
        if (slArchive != null) {
            String sharedLibraryName = this.sharedLibraryService.install(slArchive.toURI().toString());
            return Response.ok().entity((Object)sharedLibraryName).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{sharedLibrary}")
    public SharedLibraryResource getSharedLibraryResource(@PathParam(value="sharedLibrary") String sharedLibraryName) {
        return (SharedLibraryResource)this.resourceContext.initResource((Object)new SharedLibraryResource(sharedLibraryName));
    }
}

