/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.openesb.management.api.JvmMetricsService;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.json.MetricsModule;

@Path(value="jvm")
@RequiresAuthentication
public class JVMInformationsResource {
    @Inject
    private JvmMetricsService jvmMetricsService;
    private static final ObjectMapper mapper = new ObjectMapper().registerModules(new Module[]{new MetricsModule()});

    @GET
    public Map<String, Object> getInformations() {
        return this.jvmMetricsService.getInformations();
    }

    @Path(value="gc")
    @GET
    @Produces(value={"application/json"})
    public String getGarbageCollectorMetricsResource() throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this.jvmMetricsService.getGarbageCollector());
    }

    @Path(value="memory")
    @GET
    @Produces(value={"application/json"})
    public String getMemoryUsageMetricsResource() throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this.jvmMetricsService.getMemoryUsage());
    }

    @Path(value="thread")
    @GET
    @Produces(value={"application/json"})
    public String getThreadStatesMetricsResource() throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this.jvmMetricsService.getThreadStates());
    }
}

