/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import net.openesb.management.api.ComponentService;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.Logger;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.LoggerLevelParam;

@RequiresAuthentication
public class ComponentLoggersResource
extends AbstractResource {
    @Inject
    private ComponentService componentService;
    private final String componentName;

    public ComponentLoggersResource(String componentName) {
        this.componentName = componentName;
    }

    @GET
    @Produces(value={"application/json"})
    public Set<Logger> getLoggers() throws ManagementException {
        TreeSet<Logger> loggers = new TreeSet<Logger>(new Comparator<Logger>(){

            @Override
            public int compare(Logger log1, Logger log2) {
                return log1.getName().compareTo(log2.getName());
            }
        });
        loggers.addAll(this.componentService.getLoggers(this.componentName));
        return loggers;
    }

    @PUT
    @Produces(value={"application/json"})
    public Set<Logger> setLevel(@QueryParam(value="logger") String loggerName, @QueryParam(value="level") LoggerLevelParam level) throws ManagementException {
        this.componentService.setLoggerLevel(this.componentName, loggerName, level.getLevel());
        return this.getLoggers();
    }
}

