/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.ApplicationConfiguration;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;

@RequiresAuthentication
public class ComponentApplicationConfigurationResource
extends AbstractResource {
    @Inject
    private ConfigurationService configurationService;
    private final String componentName;

    public ComponentApplicationConfigurationResource(String componentName) {
        this.componentName = componentName;
    }

    @GET
    @Produces(value={"application/json"})
    public Set<String> getApplicationConfigurations() throws ManagementException {
        return new TreeSet<String>(this.configurationService.getApplicationConfigurations(this.componentName));
    }

    @GET
    @Path(value="{applicationConfigurationName}")
    @Produces(value={"application/json"})
    public ApplicationConfiguration getApplicationConfiguration(@PathParam(value="applicationConfigurationName") String applicationConfigurationName) throws ManagementException {
        return this.configurationService.getApplicationConfiguration(this.componentName, applicationConfigurationName);
    }

    @DELETE
    @Path(value="{applicationConfigurationName}")
    @Produces(value={"application/json"})
    public Set<String> deleteApplicationConfiguration(@PathParam(value="applicationConfigurationName") String applicationConfigurationName) throws ManagementException {
        this.configurationService.deleteApplicationConfiguration(this.componentName, applicationConfigurationName);
        return this.getApplicationConfigurations();
    }

    @POST
    @Consumes(value={"application/json"})
    public void updateApplicationConfiguration(ApplicationConfiguration applicationConfiguration) throws ManagementException {
        this.configurationService.updateApplicationConfiguration(this.componentName, applicationConfiguration);
    }

    @PUT
    @Consumes(value={"application/json"})
    public void addApplicationConfiguration(ApplicationConfiguration applicationConfiguration) throws ManagementException {
        this.configurationService.addApplicationConfiguration(this.componentName, applicationConfiguration);
    }
}

