/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.AppVariable;
import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiUpdateApplicationVariablesTask
extends JbiTargetTask {
    private static final String APPVARIABLE_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.appvariable.successful";
    private static final String APPVARIABLE_FAILED_STATUS_KEY = "jbi.ui.ant.set.appvariable.failed";
    private static final String APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.appvariable.partial.success";
    private List mAppVariableList = null;
    private String mAppVariablesFile = null;
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public String getAppVariables() {
        return this.mAppVariablesFile;
    }

    public void setAppVariables(String appVariablesFile) {
        this.mAppVariablesFile = appVariablesFile;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeUpdateApplicationVariables(String componentName) throws BuildException {
        try {
            String target = this.getValidTarget();
            if (componentName == null || componentName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing Update Application Variables ....");
            this.logDebug("Update  application variables, component name: " + componentName + " target: " + target);
            List appVariableList = this.getAppVariableList();
            Properties varsProps = new Properties();
            for (AppVariable appVar : appVariableList) {
                if (("" + appVar.getName()).compareTo("") == 0) continue;
                String valueString = null;
                if (appVar.getName() == null || "".equals(appVar.getName())) continue;
                valueString = appVar.getType() != null && appVar.getType().compareTo("") != 0 ? "[" + appVar.getType() + "]" + appVar.getValue() : appVar.getValue();
                varsProps.setProperty(appVar.getName(), valueString);
            }
            String appVariablesFile = this.getAppVariables();
            if (appVariablesFile != null && appVariablesFile.compareTo("") != 0) {
                this.logDebug("the params file is " + appVariablesFile);
                Properties theProp = this.loadParamsFromFile(new File(appVariablesFile));
                varsProps.putAll((Map<?, ?>)theProp);
            }
            if (varsProps.size() == 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.no.input.appvariable.data.found", null);
                throw new BuildException(msg, this.getLocation());
            }
            String rtnXml = this.getJBIAdminCommands().setApplicationVariables(componentName, target, varsProps);
            JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)rtnXml);
            if (mgmtMsg.isFailedMsg()) {
                throw new Exception(rtnXml);
            }
            this.printTaskSuccess(mgmtMsg);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing Set Configuration Task....");
        String compName = this.getComponentName();
        this.executeUpdateApplicationVariables(compName);
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPVARIABLE_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPVARIABLE_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getAppVariableList() {
        if (this.mAppVariableList == null) {
            this.mAppVariableList = new ArrayList();
        }
        return this.mAppVariableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    public AppVariable createAppVariable() {
        AppVariable appVariable = new AppVariable();
        this.getAppVariableList().add(appVariable);
        return appVariable;
    }
}

