/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Param;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiUpdateApplicationConfigurationTask
extends JbiTargetTask {
    private static final String APPCONFIG_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.appconfig.successful";
    private static final String APPCONFIG_FAILED_STATUS_KEY = "jbi.ui.ant.set.appconfig.failed";
    private static final String APPCONFIG_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.appconfig.partial.success";
    private List mParamList = null;
    private String mParamsFile = null;
    private String mComponentName = null;
    private String mName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getParams() {
        return this.mParamsFile;
    }

    public void setParams(String paramsFile) {
        this.mParamsFile = paramsFile;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeUpdateApplicationConfiguration(String componentName) throws BuildException {
        try {
            String paramsFile;
            String appConfigName = this.getName();
            String target = this.getValidTarget();
            if (componentName == null || componentName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            if (appConfigName == null || appConfigName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.set.appconfig.no.name.error", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing Set Application Configuration ....");
            List paramList = this.getParamList();
            Properties appConfigParamProps = new Properties();
            for (Param param : paramList) {
                if (("" + param.getName()).compareTo("") != 0) {
                    if (param.getValue() != null && param.getValue().compareTo("") != 0) {
                        appConfigParamProps.setProperty(param.getName(), param.getValue());
                        continue;
                    }
                    if (param.getAppVariable() != null && param.getAppVariable().compareTo("") != 0) {
                        appConfigParamProps.setProperty(param.getName(), "$" + param.getValue());
                        continue;
                    }
                    appConfigParamProps.setProperty(param.getName(), param.getValue());
                    continue;
                }
                this.logDebug("the input param name is empty.");
            }
            if (appConfigParamProps.size() == 0) {
                this.logDebug("No nested param element is found in input.");
            }
            if ((paramsFile = this.getParams()) != null && paramsFile.compareTo("") != 0) {
                appConfigParamProps.putAll((Map<?, ?>)this.loadParamsFromFile(new File(paramsFile)));
            } else {
                this.logDebug("No File based Parameters passed to set application configuration Task via nested params element");
            }
            if (appConfigParamProps.size() == 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.no.input.appconfig.param.data.found", null);
                throw new BuildException(msg, this.getLocation());
            }
            this.logDebug("component name: " + componentName + " Application Configuration name: " + appConfigName + " target: " + target);
            this.debugPrintParams(appConfigParamProps);
            String rtnXml = this.getJBIAdminCommands().setApplicationConfiguration(componentName, target, appConfigName, appConfigParamProps);
            JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)rtnXml);
            if (mgmtMsg.isFailedMsg()) {
                this.throwBuildException(mgmtMsg);
            } else {
                this.printTaskSuccess(mgmtMsg);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing Set Configuration Task....");
        String compName = this.getComponentName();
        this.executeUpdateApplicationConfiguration(compName);
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPCONFIG_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPCONFIG_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return APPCONFIG_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList();
        }
        return this.mParamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    public Param createParam() {
        Param param = new Param();
        this.getParamList().add(param);
        return param;
    }
}

