/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Param;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiSetRuntimeConfigurationTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.set.configuration.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.set.configuration.failed";
    private static final String PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.configuration.partial.success";
    private List mParamList;
    private String mParamsFile = null;

    public String getParams() {
        return this.mParamsFile;
    }

    public void setParams(String paramsFile) {
        this.mParamsFile = paramsFile;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeSetRuntimeConfiguration() throws BuildException {
        this.logDebug("Executing Set Runtime Configuration ....");
        String target = this.getValidTarget();
        boolean restartRequired = false;
        try {
            Properties params = this.getParamsAsProperties();
            if (params.size() == 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.input.runtine.configuration.param.data.found", null);
                throw new BuildException(msg, this.getLocation());
            }
            this.debugPrintParams(params);
            restartRequired = this.getJBIAdminCommands().setRuntimeConfiguration(params, target);
            String i18nKey = restartRequired ? "jbi.ui.ant.task.info.config.restart.required" : "jbi.ui.ant.task.info.config.done.on.target";
            Object[] args = new Object[]{target};
            this.printTaskSuccess(this.createFormatedSuccessJbiResultMessage(i18nKey, args));
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing Set Runtime Configuration Task....");
        this.executeSetRuntimeConfiguration();
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList();
        }
        return this.mParamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    protected Properties getParamsAsProperties() throws BuildException {
        Properties props = new Properties();
        for (Param param : this.getParamList()) {
            String name = ("" + param.getName()).trim();
            String value = ("" + param.getValue()).trim();
            if (name.length() <= 0) continue;
            props.setProperty(name, value);
        }
        Properties paramsProps = null;
        paramsProps = null;
        String paramsFile = this.getParams();
        if (paramsFile != null && paramsFile.compareTo("") != 0) {
            paramsProps = this.loadParamsFromFile(new File(paramsFile));
            props.putAll((Map<?, ?>)paramsProps);
        } else {
            this.logDebug("No File based Parameters passed to installer Task via nested params element");
        }
        return props;
    }

    public Param createParam() {
        Param param = new Param();
        this.getParamList().add(param);
        return param;
    }
}

