/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiQueryTask;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class JbiListServiceAssembliesTask
extends JbiQueryTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.service.assemblies.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.service.assemblies.failed";
    private String mServiceAssemblyName;
    private String mState;
    private String mComponentName;
    private boolean mDescriptor;

    public String getServiceAssemblyName() {
        return this.mServiceAssemblyName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.mServiceAssemblyName = serviceAssemblyName;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        this.mState = state;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public boolean getDescriptor() {
        return this.mDescriptor;
    }

    public void setDescriptor(boolean descriptor) {
        this.mDescriptor = descriptor;
    }

    @Override
    public void executeTask() throws BuildException {
        this.initXmlOutput(ServiceAssemblyInfo.writeAsXmlTextWithProlog(new ArrayList()));
        this.validateTaskPropertyForStateValue(this.getState());
        String target = this.getValidTarget();
        try {
            String result;
            String descriptor = null;
            String name = this.getServiceAssemblyName();
            if (null != name && name.length() > 0) {
                result = this.getJBIAdminCommands().showServiceAssembly(name, this.toServiceAssemblyInfoState(this.getState()), this.getComponentName(), target);
                this.setSingleQueryResultType();
                if (this.mDescriptor && (descriptor = this.getJBIAdminCommands().getServiceAssemblyDeploymentDescriptor(name)) == null) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.service.assembly.descriptor.not.found", new String[]{name});
                    throw new Exception(errMsg);
                }
            } else {
                if (this.mDescriptor) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.service.assembly.descriptor.single.only", null);
                    throw new Exception(errMsg);
                }
                result = this.getJBIAdminCommands().listServiceAssemblies(this.toServiceAssemblyInfoState(this.getState()), this.getComponentName(), target);
            }
            this.printDeploymentQueryResults(result);
            if (descriptor != null) {
                this.printMessage("");
                this.printMessage(this.getI18NBundle().getMessage("jbi.ui.ant.print.sa.descriptor"));
                this.printMessage(descriptor);
                this.printMessage("");
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getEmptyQueryResultI18NKey() {
        return "jbi.ui.ant.print.no.service.assemblies";
    }

    @Override
    protected String getQueryResultHeaderI18NKey() {
        return "jbi.ui.ant.print.sasm.header";
    }

    @Override
    protected String getQueryResultHeaderSeparatorI18NKey() {
        return "jbi.ui.ant.print.sasm.header.separator";
    }

    @Override
    protected String getQueryResultPageSeparatorI18NKey() {
        return "jbi.ui.ant.print.sasm.info.separator";
    }

    @Override
    protected String getEmptyQueryResultI18NMessage() {
        if (this.getQueryResultType() == 2) {
            return this.getI18NBundle().getMessage("jbi.ui.ant.print.no.sasm.with.name", (Object)this.getServiceAssemblyName());
        }
        return this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey());
    }
}

