/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.utils.OutputUtils;
import net.openesb.model.api.ServiceAssembly;
import net.openesb.model.api.ServiceUnit;
import net.openesb.sdk.model.GetServiceAssemblyRequest;

@Parameters(commandNames={"show-jbi-service-assembly"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.show-jbi-service-assembly.descr")
public class ShowServiceAssemblyCommand
extends AbstractCommand {
    @Parameter(descriptionKey="cli.show-jbi-service-assembly.param.serviceassemblyname", required=true, arity=1)
    private List<String> serviceAssemblyNames;

    @Override
    protected void executeRequest() throws Exception {
        String serviceAssemblyName = this.serviceAssemblyNames.iterator().next();
        if (serviceAssemblyName != null) {
            GetServiceAssemblyRequest request = new GetServiceAssemblyRequest(serviceAssemblyName);
            ServiceAssembly assembly = this.getClient().getServiceAssembly(request);
            String assemblyName = assembly.getName();
            String assemblyDescription = OutputUtils.multiLineFormat(assembly.getDescription(), 70, 14).trim();
            String assemblyState = assembly.getState().toString();
            String header = this.getLocalizedString("cli.serviceassembly.header");
            this.printMessage(header);
            this.printMessage(OutputUtils.createFillString('-', header.length()));
            this.printMessage(this.getLocalizedString("cli.serviceassembly.name", new Object[]{assemblyName}));
            this.printMessage(this.getLocalizedString("cli.serviceassembly.state", new Object[]{assemblyDescription}));
            this.printMessage(this.getLocalizedString("cli.serviceassembly.description", new Object[]{assemblyState}));
            String indentString = "    ";
            this.printMessage("");
            String serviceUnitsHeader = this.getLocalizedString("cli.serviceunit.header");
            this.printMessage(indentString + serviceUnitsHeader);
            this.printMessage(indentString + OutputUtils.createFillString('-', serviceUnitsHeader.length()));
            boolean firstTime = true;
            for (ServiceUnit serviceUnit : assembly.getServiceUnits()) {
                String suState = serviceUnit.getState().toString();
                String suDepoyedOn = serviceUnit.getDeployedOn();
                String suName = serviceUnit.getName();
                String suDescription = OutputUtils.multiLineFormat(serviceUnit.getDescription(), 50, 18);
                if (!firstTime) {
                    this.printMessage("");
                }
                this.printMessage(indentString + this.getLocalizedString("cli.serviceunit.name", new Object[]{suName}));
                this.printMessage(indentString + this.getLocalizedString("cli.serviceunit.state", new Object[]{suState}));
                this.printMessage(indentString + this.getLocalizedString("cli.serviceunit.deployedon", new Object[]{suDepoyedOn}));
                this.printMessage(indentString + this.getLocalizedString("cli.serviceunit.description", new Object[]{suDescription}));
                firstTime = false;
            }
        }
    }
}

