/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import java.util.Set;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.utils.OutputUtils;
import net.openesb.model.api.ComponentConfiguration;
import net.openesb.model.api.JBIComponent;
import net.openesb.model.api.Logger;
import net.openesb.model.api.State;
import net.openesb.sdk.model.GetComponentDescriptorRequest;
import net.openesb.sdk.model.GetComponentRequest;
import net.openesb.sdk.model.ListComponentConfigurationsRequest;
import net.openesb.sdk.model.ListComponentLoggersRequest;

@Parameters(separators="=", commandNames={"show-jbi-component"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.show-jbi-component.descr")
public class ShowComponentCommand
extends AbstractCommand {
    @Parameter(descriptionKey="cli.show-jbi-component.param.componentname", required=true, arity=1)
    private List<String> componentNames;
    @Parameter(names={"--descriptor"}, descriptionKey="cli.show-jbi-component.param.descriptor")
    private boolean descriptor = false;
    @Parameter(names={"--loggers"}, descriptionKey="cli.show-jbi-component.param.loggers")
    private boolean loggers = false;
    @Parameter(names={"--configuration"}, descriptionKey="cli.show-jbi-component.param.configuration")
    private boolean configuration = false;

    @Override
    protected void executeRequest() throws Exception {
        String componentName = this.componentNames.iterator().next();
        if (componentName != null) {
            GetComponentRequest request = new GetComponentRequest(componentName);
            JBIComponent component = this.getClient().getComponent(request);
            String componentState = component.getState().toString();
            String componentVersion = component.getVersion();
            String componentBuildNumber = component.getBuildNumber();
            String componentDescription = OutputUtils.multiLineFormat(component.getDescription(), 70, 14).trim();
            String header = this.getLocalizedString("cli.component.header");
            this.printMessage(header);
            this.printMessage(OutputUtils.createFillString('-', header.length()));
            this.printMessage(this.getLocalizedString("cli.component.name", new Object[]{componentName}));
            this.printMessage(this.getLocalizedString("cli.component.state", new Object[]{componentState}));
            this.printMessage(this.getLocalizedString("cli.component.version", new Object[]{componentVersion}));
            this.printMessage(this.getLocalizedString("cli.component.buildnumber", new Object[]{componentBuildNumber}));
            this.printMessage(this.getLocalizedString("cli.component.description", new Object[]{componentDescription}));
            if (this.loggers) {
                this.displayOptionHeader("cli.component.loggers.header", 0);
                ListComponentLoggersRequest requestLoggers = new ListComponentLoggersRequest(componentName);
                Set<Logger> loggers = this.getClient().listComponentLoggers(requestLoggers);
                this.displayNameValuePairs(loggers, 0);
            }
            if (this.configuration) {
                this.displayOptionHeader("cli.component.configuration.header", 0);
                ListComponentConfigurationsRequest requestConf = new ListComponentConfigurationsRequest(componentName);
                Set<ComponentConfiguration> configurations = this.getClient().listComponentConfigurations(requestConf);
                if (configurations.isEmpty()) {
                    if (component.getState().equals((Object)State.SHUTDOWN)) {
                        this.printMessage(this.getLocalizedString("cli.show-jbi-component.warning"));
                    }
                } else {
                    this.displayNameValuePairs(configurations, 0);
                }
            }
            if (this.descriptor) {
                this.displayOptionHeader("cli.component.descriptor.header", 0);
                GetComponentDescriptorRequest requestDescr = new GetComponentDescriptorRequest(componentName);
                String result = this.getClient().getComponentDescriptor(requestDescr);
                this.displayDescriptor(result);
            }
        }
    }
}

