/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.Definitions;
import com.sun.jbi.wsdl2.Description;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.WsdlWriter;
import com.sun.jbi.wsdl2.impl.DescriptionImpl;
import com.sun.jbi.wsdl2.impl.WsdlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class WsdlFactory
implements com.sun.jbi.wsdl2.WsdlFactory {
    private static final String PROPERTY_NAME = "com.sun.jbi.wsdl2.WsdlFactory";
    private static final String PROPERTY_FILE_NAME = "jbi.wsdl2.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.sun.jbi.wsdl2.impl.WsdlFactory";
    private static String sFullPropertyFileName = null;

    @Override
    public com.sun.jbi.wsdl2.WsdlReader newWsdlReader() {
        return new WsdlReader();
    }

    @Override
    public WsdlWriter newWsdlWriter() {
        return new com.sun.jbi.wsdl2.impl.WsdlWriter();
    }

    @Override
    public Description newDescription(String tns) {
        DescriptionImpl result = DescriptionImpl.Factory.newInstance("");
        if (tns != null) {
            result.setTargetNamespace(tns);
        }
        return result;
    }

    @Override
    public Definitions newDefinitions(String tns) {
        return (Definitions)this.newDescription(tns);
    }

    public static WsdlFactory newInstance() throws WsdlException {
        String factoryImplName = WsdlFactory.findFactoryImplName();
        return WsdlFactory.newInstance(factoryImplName);
    }

    public static WsdlFactory newInstance(String factoryImplName) throws WsdlException {
        if (factoryImplName != null) {
            try {
                Class<?> cl = Class.forName(factoryImplName);
                return (WsdlFactory)cl.newInstance();
            }
            catch (Exception ex) {
                throw new WsdlException("Cannot instantiate WsdlFactory implementation\n\tclass name = {0}\n\terror      = {2}: {1}\n", new Object[]{factoryImplName, ex.getMessage(), ex.getClass().getName()});
            }
        }
        throw new WsdlException("Unable to find name of WsdlFactory implementation.");
    }

    private static String findFactoryImplName() {
        String factoryImplName = null;
        try {
            factoryImplName = System.getProperty(PROPERTY_NAME);
            if (factoryImplName != null) {
                return factoryImplName;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String propFileName = WsdlFactory.getFullPropertyFileName();
        if (propFileName != null) {
            try {
                Properties properties = new Properties();
                File propFile = new File(propFileName);
                FileInputStream fis = new FileInputStream(propFile);
                properties.load(fis);
                fis.close();
                factoryImplName = properties.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (sFullPropertyFileName == null) {
            try {
                String javaHome = System.getProperty("java.home");
                sFullPropertyFileName = javaHome + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return sFullPropertyFileName;
    }
}

