/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util.monitoring;

import com.sun.jbi.monitoring.StatisticsBase;
import com.sun.jbi.util.jmx.MBeanUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.jbi.JBIException;
import javax.management.ObjectName;

public class StatisticsBaseImpl
implements StatisticsBase {
    private boolean mEnabled = true;
    private String mKey;
    private StatisticsBase mParent;
    private Hashtable mChildren;
    private ObjectName mMBeanName;

    public StatisticsBaseImpl(String key) {
        this.mKey = key;
    }

    @Override
    public String getKey() {
        return this.mKey;
    }

    @Override
    public void setParent(StatisticsBase parent) {
        this.mParent = parent;
    }

    @Override
    public StatisticsBase getParent() {
        return this.mParent;
    }

    @Override
    public void addChild(StatisticsBase child) {
        if (null == this.mChildren) {
            this.mChildren = new Hashtable();
        }
        if (null != child) {
            child.setParent(this);
            this.mChildren.put(child.getKey(), child);
        }
    }

    @Override
    public StatisticsBase getChild(String key) {
        StatisticsBase child = null;
        if (null != this.mChildren) {
            child = (StatisticsBase)this.mChildren.get(key);
        }
        return child;
    }

    @Override
    public List getChildren() {
        if (null != this.mChildren) {
            return new ArrayList(this.mChildren.values());
        }
        return new ArrayList();
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public void setDisabled() {
        this.mEnabled = false;
        if (null != this.mChildren) {
            for (StatisticsBase child : this.mChildren.values()) {
                child.setDisabled();
            }
        }
    }

    @Override
    public void setEnabled() {
        this.mEnabled = true;
        if (null != this.mChildren) {
            for (StatisticsBase child : this.mChildren.values()) {
                child.setEnabled();
            }
        }
    }

    @Override
    public void registerMBean(Class interfaceClass, Object instance, ObjectName mbeanName) throws JBIException {
        this.mMBeanName = mbeanName;
        MBeanUtils.registerStandardMBean(interfaceClass, instance, mbeanName, true);
    }

    @Override
    public void unregisterMBean() throws JBIException {
        MBeanUtils.unregisterMBean(this.mMBeanName);
    }
}

