/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client.jmxremote;

import com.sun.jbi.ui.client.JMXConnectionImpl;
import com.sun.jbi.ui.client.JMXConnectionProperties;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.JMXConnectionException;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.common.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class RemoteJMXConnectionImpl
extends JMXConnectionImpl {
    private JMXConnector mJmxConnector = null;
    private JMXServiceURL mJmxUrl = null;
    private String mHost = null;
    private String mPassword = null;
    private String mPort = null;
    private String mUrl = null;
    private String mUsername = null;

    public RemoteJMXConnectionImpl() throws JMXConnectionException {
        this(new Properties());
    }

    public RemoteJMXConnectionImpl(String host, String port, String username, String password) throws JMXConnectionException {
        Properties props = JMXConnectionProperties.getJMXConnectionPropertyMap(null, host, port, username, password);
        this.initConnectionProperties(props);
    }

    public RemoteJMXConnectionImpl(Properties connProps) throws JMXConnectionException {
        this.initConnectionProperties(connProps);
    }

    @Override
    public void closeConnection() throws JMXConnectionException {
        this.mMBeanServerConnection = null;
        this.mJmxUrl = null;
        if (this.mJmxConnector != null) {
            try {
                this.mJmxConnector.close();
                this.mJmxConnector = null;
            }
            catch (Exception ex) {
                throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.close.error", null, ex), null);
            }
            finally {
                this.mJmxConnector = null;
            }
        }
    }

    @Override
    public void openConnection() throws JMXConnectionException {
        if (this.mMBeanServerConnection != null) {
            return;
        }
        String url = null;
        try {
            url = JMXConnectionProperties.getInstance().getConnectionURL(this.getUrl(), this.getHost(), this.getPort());
            ToolsLogManager.getClientLogger().log(Level.FINE, "JMX URL : {0}", url);
            this.mJmxUrl = new JMXServiceURL(url);
        }
        catch (Exception ex) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.error", new Object[]{url}, ex), null);
        }
        try {
            Map env = this.getCredentialsMap();
            this.mJmxConnector = JMXConnectorFactory.connect(this.mJmxUrl, env);
        }
        catch (IOException ioEx) {
            this.mJmxUrl = null;
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.io.error", new Object[]{url}, ioEx), null);
        }
        catch (SecurityException secEx) {
            this.mJmxUrl = null;
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.security.error", new Object[]{url}, secEx), null);
        }
        catch (Exception ex) {
            this.mJmxUrl = null;
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.error", new Object[]{url}, ex), null);
        }
        try {
            this.mMBeanServerConnection = this.mJmxConnector.getMBeanServerConnection();
        }
        catch (Exception ex) {
            try {
                this.closeConnection();
            }
            catch (Exception closeEx) {
                Util.logDebug(ToolsLogManager.getClientLogger(), closeEx);
                this.mMBeanServerConnection = null;
            }
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.error", new Object[]{url}, ex), null);
        }
    }

    protected Map getCredentialsMap() {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String username = this.getUsername();
        String password = this.getPassword();
        if (username == null) {
            username = JMXConnectionProperties.getInstance().getDefaultUserName();
        }
        if (password == null) {
            password = JMXConnectionProperties.getInstance().getDefaultPassword();
        }
        ToolsLogManager.getClientLogger().log(Level.FINE, "username,password  : {0} : {1}", new Object[]{username, password});
        String[] credentials = new String[]{username, password};
        env.put("jmx.remote.credentials", credentials);
        return env;
    }

    protected void setHost(String aHost) {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        this.mHost = aHost;
    }

    protected String getHost() {
        return this.mHost;
    }

    protected void setPassword(String aPassword) {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        this.mPassword = aPassword;
    }

    protected String getPassword() {
        return this.mPassword;
    }

    protected void setPort(String aPort) {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        this.mPort = aPort;
    }

    protected String getPort() {
        return this.mPort;
    }

    protected void setUrl(String aUrl) {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        this.mUrl = aUrl;
    }

    protected String getUrl() {
        return this.mUrl;
    }

    protected void setUsername(String aUsername) {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        this.mUsername = aUsername;
    }

    protected String getUsername() {
        return this.mUsername;
    }

    protected void initConnectionProperties(Properties connProps) throws JMXConnectionException {
        String url = connProps.getProperty("com.sun.jbi.tools.remote.jmx.url");
        String host = connProps.getProperty("com.sun.jbi.tools.remote.jmx.host");
        String port = connProps.getProperty("com.sun.jbi.tools.remote.jmx.port");
        String username = connProps.getProperty("com.sun.jbi.tools.remote.jmx.username");
        String password = connProps.getProperty("com.sun.jbi.tools.remote.jmx.password");
        this.setUrl(url);
        this.setHost(host);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
        this.validatePortValue(port);
    }

    protected void validatePortValue(String port) throws JMXConnectionException {
        if (port == null) {
            return;
        }
        int portValue = -1;
        try {
            portValue = Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(RemoteJMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.open.error.invalid.port", new Object[]{port}, ex), null);
        }
    }
}

