/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;

public class MessageImpl
implements NormalizedMessage {
    private HashMap mAttachments;
    private HashMap mProperties;
    private Source mContent;

    public MessageImpl() {
        this(null, new HashMap());
    }

    MessageImpl(Source content, HashMap properties) {
        this.mContent = content;
        this.mProperties = properties;
        this.mAttachments = new HashMap();
    }

    public Source getContent() {
        return this.mContent;
    }

    public void setContent(Source content) {
        this.mContent = content;
    }

    public Object getProperty(String name) {
        return this.mProperties.get(name);
    }

    HashMap getProperties() {
        return this.mProperties;
    }

    void setProperties(HashMap map) {
        this.mProperties = map;
    }

    public Set getPropertyNames() {
        return this.mProperties.keySet();
    }

    public void setProperty(String name, Object value) {
        this.mProperties.put(name, value);
    }

    public void setSecuritySubject(Subject subject) {
        this.setProperty("javax.jbi.security.subject", subject);
    }

    public Subject getSecuritySubject() {
        return (Subject)this.getProperty("javax.jbi.security.subject");
    }

    public void addAttachment(String id, DataHandler content) throws MessagingException {
        this.mAttachments.put(id, content);
    }

    public DataHandler getAttachment(String id) {
        return (DataHandler)this.mAttachments.get(id);
    }

    public Set getAttachmentNames() {
        return this.mAttachments.keySet();
    }

    public void removeAttachment(String id) throws MessagingException {
        this.mAttachments.remove(id);
    }

    void setAttachmentMap(HashMap attachments) {
        this.mAttachments = attachments;
    }

    HashMap getAttachmentMap() {
        return this.mAttachments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("            Message Content(Type): ");
        sb.append(this.mContent == null ? "null" : this.mContent.getClass().getName());
        sb.append("\n            Properties Count:   ");
        sb.append(this.mProperties.size());
        sb.append("\n");
        for (Map.Entry me : this.mProperties.entrySet()) {
            sb.append("              Name: ");
            sb.append((String)me.getKey());
            if (me.getValue() instanceof String) {
                sb.append("\n              Value: ");
                sb.append((String)me.getValue());
            } else if (me.getValue() != null) {
                sb.append("\n              Value(Type): ");
                sb.append(me.getValue().getClass().getName());
            }
            sb.append("\n");
        }
        sb.append("            Attachments Count:  ");
        sb.append(this.mAttachments.size());
        sb.append("\n");
        for (Map.Entry me : this.mAttachments.entrySet()) {
            sb.append("              Name: ");
            sb.append((String)me.getKey());
            sb.append("\n              DataSource(Type) : ");
            sb.append(((DataHandler)me.getValue()).getDataSource().getClass().getName());
            sb.append("\n");
        }
        return sb.toString();
    }
}

