/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class InstallerConfiguration
implements DynamicMBean {
    private boolean mReadOnly;
    private ConcurrentHashMap<String, Object> mAttributes;
    private MBeanInfo mMBeanInfo;
    private ObjectName mMBeanName;

    public InstallerConfiguration(MBeanInfo mbeanInfo, ObjectName mbeanName) {
        this.mMBeanInfo = mbeanInfo != null ? mbeanInfo : new MBeanInfo("javax.management.DynamicMBean", "", null, null, null, null);
        this.mMBeanName = mbeanName;
        this.mAttributes = new ConcurrentHashMap();
    }

    public ObjectName getObjectName() {
        return this.mMBeanName;
    }

    public AttributeList getAttributeList() {
        AttributeList list = new AttributeList();
        for (Map.Entry<String, Object> attr : this.mAttributes.entrySet()) {
            list.add(new Attribute(attr.getKey(), attr.getValue()));
        }
        return list;
    }

    public int getAttributeCount() {
        return this.mAttributes.size();
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public void setReadOnly() {
        this.mReadOnly = true;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.mAttributes.get(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.isReadOnly()) {
            this.mAttributes.put(attribute.getName(), attribute.getValue());
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("invoke");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (!this.isReadOnly()) {
            for (Object attribute : attributes) {
                Attribute attr = (Attribute)attribute;
                this.mAttributes.put(attr.getName(), attr.getValue());
            }
        }
        return attributes;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String name : attributes) {
            if (!this.mAttributes.containsKey(name)) continue;
            list.add(new Attribute(name, this.mAttributes.get(name)));
        }
        return list;
    }
}

