/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentFramework;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.Operation;
import com.sun.jbi.framework.OperationCounter;
import com.sun.jbi.framework.StringTranslator;
import javax.jbi.JBIException;

class ComponentOperation
extends Operation {
    private Component mComponent;
    private boolean mNotify;
    private int mOperation;
    private EnvironmentContext mEnv;
    private StringTranslator mTranslator;
    public static final int INITIALIZE = 1;
    public static final int STARTUP = 2;
    public static final int SHUTDOWN = 3;

    ComponentOperation(Component component, int operation) {
        super(null, null);
        this.init(component, operation);
    }

    ComponentOperation(OperationCounter counter, Component component, int operation) {
        super(counter, null);
        this.init(component, operation);
    }

    ComponentOperation(OperationCounter counter, Component component, int operation, boolean notify) {
        super(counter, null);
        this.init(component, operation);
        this.mNotify = notify;
    }

    void init(Component component, int operation) {
        this.mEnv = EnvironmentContext.getInstance();
        this.mTranslator = (StringTranslator)this.mEnv.getStringTranslatorFor(this);
        if (null == component) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "component"));
        }
        this.mComponent = component;
        if (1 != operation && 2 != operation && 3 != operation) {
            throw new IllegalArgumentException(this.mTranslator.getString("INVALID_ARGUMENT", "operation", operation));
        }
        this.mOperation = operation;
    }

    Component getComponent() {
        return this.mComponent;
    }

    int getOperation() {
        return this.mOperation;
    }

    @Override
    Object process(Object[] argumentList) throws Throwable {
        ComponentFramework cf = this.mEnv.getComponentFramework();
        try {
            if (this.mComponent.isBinding() || this.mComponent.isEngine()) {
                if (1 == this.mOperation) {
                    cf.initializeComponent(this.mComponent);
                } else if (2 == this.mOperation) {
                    cf.startComponent(this.mComponent);
                } else if (3 == this.mOperation) {
                    cf.shutdownComponent(this.mComponent);
                }
            } else {
                cf.getLogger().warning(this.mTranslator.getString("CF_COMP_UNRECOGNIZED_TYPE", this.mComponent.getName(), this.mComponent.getComponentType().toString()));
            }
        }
        catch (JBIException jbiEx) {
            cf.getLogger().warning(jbiEx.getMessage());
        }
        if (this.mNotify) {
            this.mEnv.getManagementService().updateComponentState(this.mComponent.getName());
        }
        return null;
    }
}

