/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.node.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openesb.standalone.settings.ImmutableSettings;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.utils.I18NBundle;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class InstanceSettingsPreparer {
    private static final Logger LOG = Logger.getLogger(InstanceSettingsPreparer.class.getPackage().getName());
    private static final String CONFIG_FILE = "openesb.config";
    private static final String mInstallRoot = System.getProperty("openesb.home");

    public static Settings prepareSettings() {
        ImmutableSettings settings;
        String configFile = System.getProperty(CONFIG_FILE);
        if (configFile == null) {
            configFile = mInstallRoot + File.separatorChar + "config/openesb.yaml";
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("SETTINGS_LOAD_CONFIGURATION", configFile));
        }
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(), new Representer(), new DumperOptions(), new Resolver(){

                protected void addImplicitResolvers() {
                }
            });
            FileInputStream input = new FileInputStream(new File(configFile));
            Map configurations = (Map)yaml.load((InputStream)input);
            settings = new ImmutableSettings(configurations);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("SETTINGS_CONFIGURATION_LOADED", configFile));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("SETTINGS_CONFIGURATION_FAILURE", configFile));
            settings = new ImmutableSettings(null);
        }
        return settings;
    }
}

