/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.naming.jndi;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.openesb.standalone.naming.jaxb.Context;
import net.openesb.standalone.utils.I18NBundle;
import org.xml.sax.SAXException;

public final class JAXBContextReader {
    private static final Logger LOG = Logger.getLogger(JAXBContextReader.class.getName());
    private final Unmarshaller unmarshaller;

    public JAXBContextReader() throws Exception {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            String mInstallRoot = System.getProperty("openesb.home");
            String schemaFile = mInstallRoot + File.separatorChar + "config" + File.separatorChar + "context.xsd";
            Schema schema = sf.newSchema(new File(schemaFile));
            JAXBContext jc = JAXBContext.newInstance((String)"net.openesb.standalone.naming.jaxb");
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
            this.unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return false;
                }
            });
        }
        catch (SAXException saxe) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("NAMING_CONTEXT_SCHEMA_FAILURE"));
            throw saxe;
        }
        catch (JAXBException jaxbe) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("NAMING_CONTEXT_JAXB_FAILURE"));
            throw jaxbe;
        }
    }

    public Context getContext(URL contextUrl) throws Exception {
        Context context = (Context)((JAXBElement)this.unmarshaller.unmarshal(contextUrl)).getValue();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("NAMING_UNMARSHAL_SUCCESS"));
        }
        return context;
    }
}

