/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.jmx.JmxDefaultTransaction;
import com.atomikos.icatch.admin.jmx.JmxHeuristicTransaction;
import com.atomikos.icatch.admin.jmx.JmxLogAdministrator;
import com.atomikos.icatch.admin.jmx.JmxPreparedTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransactionServiceMBean;
import com.atomikos.icatch.system.Configuration;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxTransactionService
implements JmxTransactionServiceMBean,
MBeanRegistration {
    private MBeanServer server;
    private ObjectName[] beans;
    private boolean heuristicsOnly;

    private JmxTransaction createMBean(AdminTransaction tx) {
        JmxTransaction ret = null;
        switch (tx.getState()) {
            case 0: {
                ret = new JmxPreparedTransaction(tx);
                break;
            }
            case 2: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 1: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 3: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 4: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            default: {
                ret = new JmxDefaultTransaction(tx);
            }
        }
        return ret;
    }

    private synchronized void unregisterBeans() {
        try {
            if (this.beans != null) {
                for (int i = 0; i < this.beans.length; ++i) {
                    if (!this.server.isRegistered(this.beans[i])) continue;
                    this.server.unregisterMBean(this.beans[i]);
                }
            }
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.beans = null;
    }

    private AdminTransaction[] filterHeuristics(AdminTransaction[] txs) {
        ArrayList<AdminTransaction> ret = new ArrayList<AdminTransaction>();
        block6: for (int i = 0; i < txs.length; ++i) {
            AdminTransaction next = txs[i];
            switch (next.getState()) {
                case 2: {
                    ret.add(next);
                    continue block6;
                }
                case 1: {
                    ret.add(next);
                    continue block6;
                }
                case 3: {
                    ret.add(next);
                    continue block6;
                }
                case 4: {
                    ret.add(next);
                    continue block6;
                }
            }
        }
        return ret.toArray(new AdminTransaction[0]);
    }

    public synchronized ObjectName[] getTransactions() {
        this.unregisterBeans();
        LogControl logControl = JmxLogAdministrator.getInstance().getLogControl();
        if (logControl == null) {
            throw new RuntimeException("LogControl is null: transaction service not running?");
        }
        AdminTransaction[] transactions = logControl.getAdminTransactions();
        if (this.heuristicsOnly) {
            transactions = this.filterHeuristics(transactions);
        }
        this.beans = new ObjectName[transactions.length];
        for (int i = 0; i < transactions.length; ++i) {
            try {
                this.beans[i] = new ObjectName("atomikos.transactions", "TID", transactions[i].getTid());
                JmxTransaction bean = this.createMBean(transactions[i]);
                this.server.registerMBean(bean, this.beans[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.beans;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        JmxLogAdministrator admin = JmxLogAdministrator.getInstance();
        Configuration.addLogAdministrator(admin);
        if (name == null) {
            name = new ObjectName("atomikos", "name", "TransactionService");
        }
        return name;
    }

    public void postRegister(Boolean arg0) {
    }

    public void preDeregister() throws Exception {
        this.unregisterBeans();
    }

    public void postDeregister() {
    }

    public void setHeuristicsOnly(boolean heuristicsOnly) {
        this.heuristicsOnly = heuristicsOnly;
    }

    public boolean getHeuristicsOnly() {
        return this.heuristicsOnly;
    }
}

