/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx.utils;

import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;

public class StateUtils {
    protected static final int ANY_FRAMEWORK_COMPONENT_STATE = -1;
    protected static final String FRAMEWORK_SA_STARTED_STATE = "Started";
    protected static final String FRAMEWORK_SA_STOPPED_STATE = "Stopped";
    protected static final String FRAMEWORK_SA_SHUTDOWN_STATE = "Shutdown";
    public static final String FRAMEWORK_SA_ANY_STATE = "any";
    protected static final String FRAMEWORK_SU_STARTED_STATE = "started";
    protected static final String FRAMEWORK_SU_STOPPED_STATE = "stopped";
    protected static final String FRAMEWORK_SU_SHUTDOWN_STATE = "shutdown";
    public static final String FRAMEWORK_SU_UNKNOWN_STATE = "unknown";
    public static final String RUNNING_STATE = "Running";

    public static String toFrameworkServiceAssemblyState(String uiState) {
        if (uiState == null) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        String saState = uiState.trim();
        if (saState.length() <= 0) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        if (FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_STARTED_STATE;
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_STOPPED_STATE;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_SHUTDOWN_STATE;
        }
        return FRAMEWORK_SA_ANY_STATE;
    }

    public static String toUiServiceUnitState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String suState = frameworkState.trim();
        if (suState.length() <= 0) {
            return "Unknown";
        }
        uiState = FRAMEWORK_SU_STARTED_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_STARTED_STATE : (FRAMEWORK_SU_STOPPED_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SU_SHUTDOWN_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    public static String toUiServiceAssemblyState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String saState = frameworkState.trim();
        if (saState.length() <= 0) {
            return "Unknown";
        }
        uiState = FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_STARTED_STATE : (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    public static ComponentState toFrameworkComponentInfoState(String uiCompState) {
        if (uiCompState == null) {
            return ComponentState.UNKNOWN;
        }
        String compState = uiCompState.trim();
        if (compState.length() <= 0) {
            return ComponentState.UNKNOWN;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.SHUTDOWN;
        }
        if (FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.STARTED;
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.STOPPED;
        }
        return ComponentState.UNKNOWN;
    }

    public static String toUiComponentInfoType(ComponentType frameworkCompType) {
        String uiType = FRAMEWORK_SU_UNKNOWN_STATE;
        switch (frameworkCompType) {
            case BINDING: {
                uiType = "binding-component";
                break;
            }
            case ENGINE: {
                uiType = "service-engine";
                break;
            }
            case SHARED_LIBRARY: {
                uiType = "shared-library";
                break;
            }
            default: {
                uiType = FRAMEWORK_SU_UNKNOWN_STATE;
            }
        }
        return uiType;
    }

    public static String toUiComponentInfoState(ComponentState frameworkCompState) {
        String uiState = "Unknown";
        switch (frameworkCompState) {
            case SHUTDOWN: {
                uiState = FRAMEWORK_SA_SHUTDOWN_STATE;
                break;
            }
            case STARTED: {
                uiState = FRAMEWORK_SA_STARTED_STATE;
                break;
            }
            case STOPPED: {
                uiState = FRAMEWORK_SA_STOPPED_STATE;
                break;
            }
            default: {
                uiState = "Unknown";
            }
        }
        return uiState;
    }
}

