/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.StatisticsService;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.model.api.ConsumingEndpointStatistics;
import net.openesb.model.api.EndpointStatistics;
import net.openesb.model.api.ProvidingEndpointStatistics;
import net.openesb.model.api.Statistic;
import net.openesb.model.api.metric.Metric;

public class StatisticsServiceImpl
extends AbstractServiceImpl
implements StatisticsService {
    static String COMPONENT_LAST_RESTART_TIME_ATTR = "LastRestartTime";
    static String COMPONENT_ACTIVE_ENDPOINTS = "ActiveEndpoints";
    static String COMPONENT_RECEIVE_REQUEST = "ReceiveRequest";
    static String COMPONENT_SEND_REQUEST = "SendRequest";
    static String COMPONENT_RECEIVE_REPLY = "ReceiveReply";
    static String COMPONENT_SEND_REPLY = "SendReply";
    static String COMPONENT_RECEIVE_DONE = "ReceiveDONE";
    static String COMPONENT_SEND_DONE = "SendDONE";
    static String COMPONENT_RECEIVE_FAULT = "ReceiveFault";
    static String COMPONENT_SEND_FAULT = "SendFault";
    static String COMPONENT_RECEIVE_ERROR = "ReceiveERROR";
    static String COMPONENT_SEND_ERROR = "SendERROR";
    static String COMPONENT_ACTIVE_EXCHANGE = "ActiveExchanges";
    static String COMPONENT_ACTIVE_EXCHANGE_MAX = "MaxActiveExchanges";
    static String COMPONENT_QUEUED_EXCHANGE = "QueuedExchanges";
    static String COMPONENT_QUEUED_EXCHANGE_MAX = "MaxQueuedExchanges";
    static String COMPONENT_RESPONSE_TIME = "ResponseTimeAvg (ns)";
    static String COMPONENT_COMPONENT_TIME = "ComponentTimeAvg (ns)";
    static String COMPONENT_CHANNEL_TIME = "ChannelTimeAvg (ns)";
    static String COMPONENT_NMR_TIME = "NMRTimeAvg (ns)";
    static String OWNING_COMPONENT = "OwningChannel";
    static String PROVIDER_ACTIVATION_TIMESTAMP = "ActivationTimestamp";
    static String COMPONENT_STATUS_TIME = "StatusTimeAvg (ns)";
    static String[] ENDPOINT_STATS_PROVIDER_ITEM_NAMES = new String[]{PROVIDER_ACTIVATION_TIMESTAMP, COMPONENT_RECEIVE_REQUEST, COMPONENT_SEND_REPLY};

    public Map<String, Metric> getEndpointStatistics(String endpointName) throws ManagementException {
        CompositeData epDataStats = this.getMessageServiceStatisticsMBean().getEndpointStatistics(endpointName);
        boolean isProvider = true;
        try {
            epDataStats.getAll(ENDPOINT_STATS_PROVIDER_ITEM_NAMES);
        }
        catch (InvalidKeyException invalidKeyException) {
            StatisticsServiceImpl.getLogger().log(Level.FINE, "All provider items are not present, could be consuming endpoint");
            isProvider = false;
        }
        return this.convert(epDataStats);
    }

    public Map<String, Metric> getComponentStatistics(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        CompositeData compData = this.getMessageServiceStatisticsMBean().getDeliveryChannelStatistics(componentName);
        return this.convert(compData);
    }

    public Map<String, Metric> getServiceAssemblyStatistics(String serviceAssemblyName) throws ManagementException {
        try {
            CompositeData assemblyData = this.getDeploymentServiceStatisticsMBean().getServiceAssemblyStatistics(serviceAssemblyName);
            return this.convert(assemblyData);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    private Map<String, Metric> convert(CompositeData compositeData) {
        CompositeType compositeType = compositeData.getCompositeType();
        HashMap<String, Statistic> metrics = new HashMap<String, Statistic>(compositeType.keySet().size());
        for (String statKey : compositeType.keySet()) {
            Map<String, Metric> value = compositeData.get(statKey);
            if (value instanceof CompositeData) {
                value = this.convert((CompositeData)((Object)value));
            }
            String description = compositeType.getDescription(statKey);
            metrics.put(statKey, new Statistic(statKey, value, description));
        }
        return Collections.unmodifiableMap(metrics);
    }

    private EndpointStatistics composeProviderEndpointStats(CompositeData endpointStats) {
        ProvidingEndpointStatistics stats = new ProvidingEndpointStatistics();
        Date activationTime = null;
        long upTime = 0L;
        Long activationTimeStamp = (Long)endpointStats.get(PROVIDER_ACTIVATION_TIMESTAMP);
        if (activationTimeStamp != null) {
            activationTime = new Date(activationTimeStamp);
            upTime = System.currentTimeMillis() - activationTime.getTime();
        }
        stats.setActivationTime(activationTime);
        stats.setUpTime(upTime);
        stats.setReceivedRequests(((Long)endpointStats.get(COMPONENT_RECEIVE_REQUEST)).longValue());
        stats.setSentReplies(((Long)endpointStats.get(COMPONENT_SEND_REPLY)).longValue());
        return stats;
    }

    private EndpointStatistics composeConsumerEndpointStats(CompositeData endpointStats) {
        ConsumingEndpointStatistics stats = new ConsumingEndpointStatistics();
        stats.setSentRequests(((Long)endpointStats.get(COMPONENT_SEND_REQUEST)).longValue());
        stats.setReceivedReplies(((Long)endpointStats.get(COMPONENT_RECEIVE_REPLY)).longValue());
        return stats;
    }
}

