/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.openesb.management.api.JvmMetricsService;
import net.openesb.model.api.metric.Gauge;
import net.openesb.model.api.metric.Metric;
import net.openesb.model.api.metric.RatioGauge;

public class JvmMetricsServiceImpl
implements JvmMetricsService {
    private static final int STACK_TRACE_DEPTH = 0;
    private static final int MAX_STACK_TRACE_DEPTH = 100;
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> garbageCollectors;
    private final ThreadMXBean threads = ManagementFactory.getThreadMXBean();
    private final RuntimeMXBean runtimeMxBean;
    private final MemoryMXBean memoryMxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public JvmMetricsServiceImpl() {
        this.garbageCollectors = new ArrayList<GarbageCollectorMXBean>(ManagementFactory.getGarbageCollectorMXBeans());
        this.runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        this.memoryMxBean = ManagementFactory.getMemoryMXBean();
        this.memoryPools = ManagementFactory.getMemoryPoolMXBeans();
    }

    public Map<String, Object> getInformations() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("name", this.runtimeMxBean.getName());
        infos.put("spec.name", this.runtimeMxBean.getSpecName());
        infos.put("spec.vendor", this.runtimeMxBean.getSpecVendor());
        infos.put("spec.version", this.runtimeMxBean.getSpecVersion());
        infos.put("vm.name", this.runtimeMxBean.getVmName());
        infos.put("vm.vendor", this.runtimeMxBean.getVmVendor());
        infos.put("vm.version", this.runtimeMxBean.getVmVersion());
        infos.put("mgmt.spec.version", this.runtimeMxBean.getManagementSpecVersion());
        infos.put("system.properties", this.runtimeMxBean.getSystemProperties());
        return Collections.unmodifiableMap(infos);
    }

    public Map<String, Metric> getMemoryUsage() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        gauges.put("total.init", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getInit() + JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("total.used", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getUsed() + JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("total.max", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getMax() + JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("total.committed", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getCommitted() + JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.init", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getInit();
            }
        });
        gauges.put("heap.used", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("heap.max", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getMax();
            }
        });
        gauges.put("heap.committed", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("heap.usage", new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = JvmMetricsServiceImpl.this.memoryMxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of((double)usage.getUsed(), (double)usage.getMax());
            }
        });
        gauges.put("non-heap.init", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put("non-heap.used", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put("non-heap.max", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put("non-heap.committed", new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put("non-heap.usage", new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = JvmMetricsServiceImpl.this.memoryMxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of((double)usage.getUsed(), (double)usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = JvmMetricsServiceImpl.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("-"));
            gauges.put(JvmMetricsServiceImpl.name(poolName, "usage"), new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    long max = pool.getUsage().getMax() == -1L ? pool.getUsage().getCommitted() : pool.getUsage().getMax();
                    return RatioGauge.Ratio.of((double)pool.getUsage().getUsed(), (double)max);
                }
            });
            gauges.put(JvmMetricsServiceImpl.name(poolName, "max"), new Gauge<Long>(){

                public Long getValue() {
                    return pool.getUsage().getMax();
                }
            });
            gauges.put(JvmMetricsServiceImpl.name(poolName, "used"), new Gauge<Long>(){

                public Long getValue() {
                    return pool.getUsage().getUsed();
                }
            });
            gauges.put(JvmMetricsServiceImpl.name(poolName, "committed"), new Gauge<Long>(){

                public Long getValue() {
                    return pool.getUsage().getCommitted();
                }
            });
            gauges.put(JvmMetricsServiceImpl.name(poolName, "init"), new Gauge<Long>(){

                public Long getValue() {
                    return pool.getUsage().getInit();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }

    public Map<String, Metric> getGarbageCollector() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        for (final GarbageCollectorMXBean gc : this.garbageCollectors) {
            String name = WHITESPACE.matcher(gc.getName()).replaceAll("-");
            gauges.put(JvmMetricsServiceImpl.name(name, "count"), new Gauge<Long>(){

                public Long getValue() {
                    return gc.getCollectionCount();
                }
            });
            gauges.put(JvmMetricsServiceImpl.name(name, "time"), new Gauge<Long>(){

                public Long getValue() {
                    return gc.getCollectionTime();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }

    public Map<String, Metric> getThreadStates() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        for (final Thread.State state : Thread.State.values()) {
            gauges.put(JvmMetricsServiceImpl.name(state.toString().toLowerCase(), "count"), new Gauge<Object>(){

                public Object getValue() {
                    return JvmMetricsServiceImpl.this.getThreadCount(state);
                }
            });
        }
        gauges.put("count", new Gauge<Integer>(){

            public Integer getValue() {
                return JvmMetricsServiceImpl.this.threads.getThreadCount();
            }
        });
        gauges.put("daemon.count", new Gauge<Integer>(){

            public Integer getValue() {
                return JvmMetricsServiceImpl.this.threads.getDaemonThreadCount();
            }
        });
        gauges.put("deadlock.count", new Gauge<Integer>(){

            public Integer getValue() {
                return JvmMetricsServiceImpl.this.getDeadlockedThreads().size();
            }
        });
        gauges.put("deadlocks", new Gauge<Set<String>>(){

            public Set<String> getValue() {
                return JvmMetricsServiceImpl.this.getDeadlockedThreads();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }

    private Set<String> getDeadlockedThreads() {
        long[] ids = this.threads.findDeadlockedThreads();
        if (ids != null) {
            HashSet<String> deadlocks = new HashSet<String>();
            for (ThreadInfo info : this.threads.getThreadInfo(ids, 100)) {
                StringBuilder stackTrace = new StringBuilder();
                for (StackTraceElement element : info.getStackTrace()) {
                    stackTrace.append("\t at ").append(element.toString()).append(String.format("%n", new Object[0]));
                }
                deadlocks.add(String.format("%s locked on %s (owned by %s):%n%s", info.getThreadName(), info.getLockName(), info.getLockOwnerName(), stackTrace.toString()));
            }
            return Collections.unmodifiableSet(deadlocks);
        }
        return Collections.emptySet();
    }

    private static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        JvmMetricsServiceImpl.append(builder, name);
        if (names != null) {
            for (String s : names) {
                JvmMetricsServiceImpl.append(builder, s);
            }
        }
        return builder.toString();
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }
}

