/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.jbi.management.ComponentConfiguration;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.ManagementException;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.model.api.ApplicationConfiguration;
import net.openesb.model.api.ApplicationVariable;
import net.openesb.model.api.Configuration;

public class ConfigurationServiceImpl
extends AbstractServiceImpl
implements ConfigurationService {
    public Set<net.openesb.model.api.ComponentConfiguration> getComponentConfiguration(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isComponentConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.config.not.supported", new String[]{componentName}, null);
        }
        try {
            Map<String, Object> configurations = this.getComponentConfigurationProperties(componentName);
            HashSet<net.openesb.model.api.ComponentConfiguration> structuredConfigurations = new HashSet<net.openesb.model.api.ComponentConfiguration>(configurations.size());
            for (Map.Entry<String, Object> config : configurations.entrySet()) {
                structuredConfigurations.add(new net.openesb.model.api.ComponentConfiguration(config.getKey(), config.getValue()));
            }
            return structuredConfigurations;
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    public Set<ApplicationVariable> getApplicationVariables(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppVarsSupported(componentName)) {
            throw this.createManagementException("rest.component.app.vars.not.supported", new String[]{componentName}, null);
        }
        try {
            Map<String, String> variables = this.retrieveApplicationVariables(componentName);
            HashSet<ApplicationVariable> structVariables = new HashSet<ApplicationVariable>(variables.size());
            for (Map.Entry<String, String> variable : variables.entrySet()) {
                structVariables.add(new ApplicationVariable(variable.getKey(), this.componentConfigurationHelper.getAppVarValue(variable.getValue()), this.componentConfigurationHelper.getAppVarType(variable.getValue(), "string")));
            }
            return structVariables;
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    private Map<String, String> retrieveApplicationVariables(String component) throws Exception {
        ComponentConfiguration config = this.getComponentConfigurationMBean(component);
        TabularData datas = config.getApplicationVariables();
        Properties props = this.componentConfigurationHelper.convertToApplicationVariablesProperties(datas);
        return new HashMap<Object, Object>(props);
    }

    public void updateComponentConfiguration(String componentName, Set<net.openesb.model.api.ComponentConfiguration> configurations) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isComponentConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.config.not.supported", new String[]{componentName}, null);
        }
        Set<net.openesb.model.api.ComponentConfiguration> oldConfigurations = this.getComponentConfiguration(componentName);
        HashSet<net.openesb.model.api.ComponentConfiguration> newConfigurations = new HashSet<net.openesb.model.api.ComponentConfiguration>(oldConfigurations.size());
        newConfigurations.addAll(configurations);
        newConfigurations.addAll(oldConfigurations);
        try {
            ObjectName ojbName = this.getComponentConfigurationMBeanObjectName(componentName);
            AttributeList attrs = this.constructMBeanAttributes(ojbName, this.convert(newConfigurations));
            this.setMBeanConfigAttributes(ojbName, attrs);
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    private Map<String, Object> convert(Set<net.openesb.model.api.ComponentConfiguration> configurations) {
        HashMap<String, Object> map = new HashMap<String, Object>(configurations.size());
        for (net.openesb.model.api.ComponentConfiguration config : configurations) {
            map.put(config.getName(), config.getValue());
        }
        return map;
    }

    public void updateApplicationVariable(String componentName, Set<ApplicationVariable> appVariables) throws ManagementException {
        this.checkComponentExists(componentName);
        ConfigurationServiceImpl.getLogger().log(Level.FINE, "updateApplicationVariable({0},{1})", new Object[]{componentName, appVariables});
        if (!this.isAppVarsSupported(componentName)) {
            throw this.createManagementException("rest.component.app.vars.not.supported", new String[]{componentName}, null);
        }
        ComponentConfiguration configurationMBean = this.getComponentConfigurationMBean(componentName);
        if (appVariables != null) {
            for (ApplicationVariable appVariable : appVariables) {
                try {
                    configurationMBean.setApplicationVariable(appVariable.getName(), this.convertApplicationVariable(appVariable));
                }
                catch (Exception ex) {
                    String[] args = new String[]{appVariable.getName(), componentName};
                    if (ex instanceof UndeclaredThrowableException) {
                        ex = (Exception)((UndeclaredThrowableException)ex).getUndeclaredThrowable();
                    }
                    throw this.createManagementException("rest.component.set.app.vars.error", args, ex);
                }
            }
        }
    }

    public void addApplicationVariable(String componentName, Set<ApplicationVariable> appVariables) throws ManagementException {
        this.checkComponentExists(componentName);
        ConfigurationServiceImpl.getLogger().log(Level.FINE, "addApplicationVariable({0},{1})", new Object[]{componentName, appVariables});
        if (!this.isAppVarsSupported(componentName)) {
            throw this.createManagementException("rest.component.app.vars.not.supported", new String[]{componentName}, null);
        }
        ComponentConfiguration configurationMBean = this.getComponentConfigurationMBean(componentName);
        if (appVariables != null) {
            for (ApplicationVariable appVariable : appVariables) {
                try {
                    configurationMBean.addApplicationVariable(appVariable.getName(), this.convertApplicationVariable(appVariable));
                }
                catch (Exception ex) {
                    String[] args = new String[]{appVariable.getName(), componentName};
                    if (ex instanceof UndeclaredThrowableException) {
                        ex = (Exception)((UndeclaredThrowableException)ex).getUndeclaredThrowable();
                    }
                    throw this.createManagementException("rest.component.add.app.vars.error", args, ex);
                }
            }
        }
    }

    private CompositeData convertApplicationVariable(ApplicationVariable appVariable) {
        try {
            return this.componentConfigurationHelper.createApplicationVariableComposite(appVariable.getName(), appVariable.getValue(), appVariable.getType());
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, "convertApplicationVariable(" + appVariable + ")", ex);
            return null;
        }
    }

    public void deleteApplicationVariables(String componentName, String[] appVariableNames) throws ManagementException {
        this.checkComponentExists(componentName);
        ConfigurationServiceImpl.getLogger().log(Level.FINE, "deleteApplicationVariables({0},{1})", new Object[]{componentName, appVariableNames});
        if (!this.isAppVarsSupported(componentName)) {
            throw this.createManagementException("rest.component.app.vars.not.supported", new String[]{componentName}, null);
        }
        ComponentConfiguration configurationMBean = this.getComponentConfigurationMBean(componentName);
        if (appVariableNames != null) {
            for (String appVariableName : appVariableNames) {
                try {
                    configurationMBean.deleteApplicationVariable(appVariableName);
                }
                catch (Exception ex) {
                    String[] args = new String[]{appVariableName, componentName};
                    throw this.createManagementException("rest.component.del.app.vars.error", args, ex);
                }
            }
        }
    }

    public Configuration getConfigurationSchema(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentConfiguration configurationMBean = this.getComponentConfigurationMBean(componentName);
        try {
            String schema = configurationMBean.retrieveConfigurationDisplayData();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(schema);
            return (Configuration)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            throw new ManagementException("error : " + e.getMessage());
        }
    }

    private Map<String, Properties> retrieveApplicationConfigurations(String component) throws Exception {
        ComponentConfiguration config = this.getComponentConfigurationMBean(component);
        TabularData datas = config.getApplicationConfigurations();
        return this.getApplicationConfigurationsMap(datas);
    }

    private Map<String, Properties> getApplicationConfigurationsMap(TabularData td) {
        HashMap<String, Properties> configMap = new HashMap<String, Properties>();
        Set<?> configKeys = td.keySet();
        if (configKeys != null) {
            for (Object configKey : configKeys) {
                List keyList = (List)configKey;
                Object[] index = new String[keyList.size()];
                index = keyList.toArray(index);
                CompositeData cd = td.get(index);
                Properties configProps = this.componentConfigurationHelper.convertCompositeDataToProperties(cd);
                configMap.put((String)index[0], configProps);
            }
        }
        return configMap;
    }

    public Set<String> getApplicationConfigurations(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.app.config.not.supported", new String[]{componentName}, null);
        }
        try {
            Map<String, Properties> configurations = this.retrieveApplicationConfigurations(componentName);
            return configurations.keySet();
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    public ApplicationConfiguration getApplicationConfiguration(String componentName, String configurationName) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.app.config.not.supported", new String[]{componentName}, null);
        }
        Map<String, Properties> configurationsMap = null;
        try {
            configurationsMap = this.retrieveApplicationConfigurations(componentName);
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
        Properties appConfigurationProp = configurationsMap.get(configurationName);
        if (appConfigurationProp != null) {
            ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration(configurationName);
            HashSet<net.openesb.model.api.ComponentConfiguration> configurations = new HashSet<net.openesb.model.api.ComponentConfiguration>(appConfigurationProp.size());
            for (Map.Entry<Object, Object> appConfig : appConfigurationProp.entrySet()) {
                configurations.add(new net.openesb.model.api.ComponentConfiguration(appConfig.getKey().toString(), appConfig.getValue()));
            }
            applicationConfiguration.setConfigurations(configurations);
            return applicationConfiguration;
        }
        throw this.createManagementException("rest.component.app.config.does.not.exist", new String[]{componentName, configurationName}, null);
    }

    public void deleteApplicationConfiguration(String componentName, String configurationName) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.app.config.not.supported", new String[]{componentName}, null);
        }
        if (!this.checkApplicationConfigurationExists(componentName, configurationName)) {
            throw this.createManagementException("rest.component.app.config.does.not.exist", new String[]{componentName, configurationName}, null);
        }
        ComponentConfiguration config = this.getComponentConfigurationMBean(componentName);
        try {
            config.deleteApplicationConfiguration(configurationName);
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    public void updateApplicationConfiguration(String componentName, ApplicationConfiguration appConfiguration) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.app.config.not.supported", new String[]{componentName}, null);
        }
        if (!this.checkApplicationConfigurationExists(componentName, appConfiguration.getName())) {
            throw this.createManagementException("rest.component.app.config.does.not.exist", new String[]{componentName, appConfiguration.getName()}, null);
        }
        ComponentConfiguration config = this.getComponentConfigurationMBean(componentName);
        try {
            config.setApplicationConfiguration(appConfiguration.getName(), this.convertApplicationConfigurations(appConfiguration.getConfigurations()));
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    public void addApplicationConfiguration(String componentName, ApplicationConfiguration appConfiguration) throws ManagementException {
        this.checkComponentExists(componentName);
        if (!this.isAppConfigSupported(componentName)) {
            throw this.createManagementException("rest.component.app.config.not.supported", new String[]{componentName}, null);
        }
        if (this.checkApplicationConfigurationExists(componentName, appConfiguration.getName())) {
            throw this.createManagementException("rest.component.app.config.already.exists", new String[]{componentName, appConfiguration.getName()}, null);
        }
        ComponentConfiguration config = this.getComponentConfigurationMBean(componentName);
        try {
            config.addApplicationConfiguration(appConfiguration.getName(), this.convertApplicationConfigurations(appConfiguration.getConfigurations()));
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            throw new ManagementException(ex.getMessage());
        }
    }

    private Properties convertApplicationConfigurations(Set<net.openesb.model.api.ComponentConfiguration> configurations) {
        Properties props = new Properties();
        for (net.openesb.model.api.ComponentConfiguration config : configurations) {
            props.setProperty(config.getName(), config.getValue().toString());
        }
        return props;
    }

    private boolean checkApplicationConfigurationExists(String componentName, String configurationName) {
        try {
            Map<String, Properties> configurations = this.retrieveApplicationConfigurations(componentName);
            return configurations.containsKey(configurationName);
        }
        catch (Exception ex) {
            ConfigurationServiceImpl.getLogger().log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

