/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.SharedLibraryService;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.management.jmx.utils.SharedLibraryConverter;
import net.openesb.model.api.ComponentDescriptor;
import net.openesb.model.api.SharedLibrary;

public class SharedLibraryServiceImpl
extends AbstractServiceImpl
implements SharedLibraryService {
    public Set<SharedLibrary> findSharedLibraries(String componentName) throws ManagementException {
        if (componentName != null && !componentName.trim().isEmpty()) {
            this.checkComponentExists(componentName);
        }
        List frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraries(componentName);
        List<JBIComponentInfo> uiCompInfoList = this.toUiComponentInfoList(frameworkCompInfoList);
        HashSet<SharedLibrary> libraries = new HashSet<SharedLibrary>(uiCompInfoList.size());
        for (JBIComponentInfo compInfo : uiCompInfoList) {
            libraries.add(SharedLibraryConverter.convert(compInfo));
        }
        return libraries;
    }

    public String getDescriptorAsXml(String sharedLibraryName) throws ManagementException {
        this.checkSharedLibraryExists(sharedLibraryName);
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        if (componentQuery != null) {
            ComponentInfo retrievedInfo = componentQuery.getSharedLibraryInfo(sharedLibraryName);
            return retrievedInfo.getInstallationDescriptor();
        }
        return null;
    }

    private void checkSharedLibraryExists(String sharedLibraryName) {
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        ComponentInfo componentInfo = null;
        if (componentQuery != null) {
            componentInfo = componentQuery.getSharedLibraryInfo(sharedLibraryName);
        }
        if (componentInfo == null) {
            throw this.createComponentNotFoundException("rest.library.id.does.not.exist", new String[]{sharedLibraryName});
        }
    }

    private List getFrameworkComponentInfoListForSharedLibraries(String componentName) throws ManagementException {
        String compName = null;
        if (componentName != null && componentName.trim().length() > 0) {
            compName = componentName.trim();
        }
        SharedLibraryServiceImpl.getLogger().log(Level.FINE, "getFrameworkComponentInfoForSharedLibraries: Params : {0}", componentName);
        List slibNames = new ArrayList();
        ComponentQuery componentQuery = null;
        if (compName == null) {
            SharedLibraryServiceImpl.getLogger().log(Level.FINE, "Listing All Shared Libraries in the system");
            componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                slibNames = componentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
            }
        } else {
            SharedLibraryServiceImpl.getLogger().log(Level.FINE, "Listing Shared Libraries for the component {0}", compName);
            componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                ComponentInfo componentInfo = componentQuery.getComponentInfo(compName);
                if (componentInfo == null) {
                    Exception exception = new Exception("ui.mbean.component.id.does.not.exist");
                    throw new ManagementException((Throwable)exception);
                }
                slibNames = componentInfo.getSharedLibraryNames();
            }
        }
        return this.getFrameworkComponentInfoListForSharedLibraryNames(slibNames);
    }

    public String install(String slZipURL) throws ManagementException {
        try {
            return this.getInstallationServiceMBean().installSharedLibrary(slZipURL);
        }
        catch (Exception e) {
            throw this.createManagementException(e.getMessage());
        }
    }

    public void uninstall(String sharedLibraryName) throws ManagementException {
        this.checkSharedLibraryExists(sharedLibraryName);
        try {
            this.getInstallationServiceMBean().uninstallSharedLibrary(sharedLibraryName);
        }
        catch (Exception e) {
            throw this.createManagementException(e.getMessage());
        }
    }

    public SharedLibrary getSharedLibrary(String sharedLibraryName) throws ManagementException {
        this.checkSharedLibraryExists(sharedLibraryName);
        Set<SharedLibrary> libraries = this.findSharedLibraries(null);
        for (SharedLibrary library : libraries) {
            if (!library.getName().equalsIgnoreCase(sharedLibraryName)) continue;
            library.setComponentDependencies(new HashSet<String>(this.getComponentNamesDependentOnSharedLibrary(sharedLibraryName)));
            return library;
        }
        return null;
    }

    public ComponentDescriptor getDescriptor(String sharedLibraryName) throws ManagementException {
        this.checkSharedLibraryExists(sharedLibraryName);
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        if (componentQuery != null) {
            ComponentInfo retrievedInfo = componentQuery.getSharedLibraryInfo(sharedLibraryName);
            ComponentDescriptor info = new ComponentDescriptor();
            info.setName(retrievedInfo.getName());
            info.setDescription(retrievedInfo.getDescription());
            info.setBootstrapClassLoaderSelfFirst(retrievedInfo.isBootstrapClassLoaderSelfFirst());
            info.setBootstrapClassName(retrievedInfo.getBootstrapClassName());
            info.setBootstrapClassPathElements(retrievedInfo.getBootstrapClassPathElements());
            info.setClassLoaderSelfFirst(retrievedInfo.isClassLoaderSelfFirst());
            info.setClassPathElements(retrievedInfo.getClassPathElements());
            info.setComponentClassName(retrievedInfo.getComponentClassName());
            info.setInstallRoot(retrievedInfo.getInstallRoot());
            info.setSharedLibraries(retrievedInfo.getSharedLibraryNames());
            info.setWorkspaceRoot(retrievedInfo.getWorkspaceRoot());
            return info;
        }
        return null;
    }
}

