/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.Definitions;
import com.sun.jbi.wsdl2.Description;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.impl.DOMUtilities;
import com.sun.jbi.wsdl2.impl.DescriptionImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.ns.wsdl.DescriptionDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class WsdlReader
implements com.sun.jbi.wsdl2.WsdlReader {
    private final String OLD_NS_STRING = "www.w3.org/2006/01/wsdl";
    private final String NEW_NS_STRING = "www.w3.org/ns/wsdl";
    private final Logger mLogger = Logger.getLogger("com.sun.jbi.wsdl2.logger");

    WsdlReader() {
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    @Override
    public Description readDescription(String wsdlUri) throws WsdlException, MalformedURLException, IOException {
        return this.readDescription(null, wsdlUri);
    }

    @Override
    public Definitions readWsdl(String wsdlURI) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(wsdlURI);
    }

    @Override
    public Description readDescription(String contextUri, String wsdlUri) throws WsdlException, MalformedURLException, IOException {
        Object result = null;
        URL contextURL = contextUri != null ? WsdlReader.getURL(null, contextUri) : null;
        URL wsdlURL = WsdlReader.getURL(contextURL, wsdlUri);
        DescriptionDocument defDoc = null;
        try {
            try {
                defDoc = DescriptionDocument.Factory.parse(wsdlURL);
            }
            catch (Exception exp) {
                this.mLogger.fine("May not be the final WSDL 2.0 version, let's try 2006.01");
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                Document doc = domBuilder.parse(wsdlURL.toString());
                this.recursivelyUpdate(doc);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer trans = transFactory.newTransformer();
                StringWriter strWriter = new StringWriter();
                StreamResult resultStream = new StreamResult(strWriter);
                trans.transform(new DOMSource(doc), resultStream);
                domFactory.setNamespaceAware(true);
                DocumentBuilder domBuilder1 = domFactory.newDocumentBuilder();
                Document newDoc = domBuilder1.parse(new StringBufferInputStream(strWriter.getBuffer().toString()));
                defDoc = DescriptionDocument.Factory.parse(newDoc);
                strWriter.close();
            }
            WsdlReader.validate(defDoc);
        }
        catch (XmlException ex) {
            throw new WsdlException(ex.getMessage());
        }
        catch (SAXException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (ParserConfigurationException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (TransformerConfigurationException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (TransformerException exp) {
            throw new WsdlException(exp.getMessage());
        }
        return DescriptionImpl.Factory.getInstance(defDoc, wsdlURL.toExternalForm());
    }

    private void recursivelyUpdate(Node theNode) {
        NamedNodeMap attrs = theNode.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                String attrValue = "" + attr.getNodeValue();
                attrValue = attrValue.replace("www.w3.org/2006/01/wsdl", "www.w3.org/ns/wsdl");
                attr.setNodeValue(attrValue);
            }
        }
        NodeList nodeList = theNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            this.recursivelyUpdate(childNode);
        }
    }

    @Override
    public Definitions readWsdl(String contextURI, String wsdlURI) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(contextURI, wsdlURI);
    }

    private static void validate(DescriptionDocument defDoc) throws WsdlException {
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errorList = new ArrayList();
        validateOptions.setErrorListener(errorList);
        boolean isValid = defDoc.validate(validateOptions);
        if (!isValid) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                XmlError error = (XmlError)errorList.get(i);
                if (i > 0) {
                    sb.append("\n\n");
                }
                sb.append("Message: ");
                sb.append(error.getMessage());
                sb.append("\n");
                sb.append("Location of invalid XML: ");
                sb.append(error.getCursorLocation().xmlText());
                sb.append("\n\n");
            }
            throw new WsdlException(sb.toString());
        }
    }

    @Override
    public Description readDescription(String documentBaseUri, Document document) throws WsdlException, IOException {
        return this.readDescription(documentBaseUri, document.getDocumentElement());
    }

    @Override
    public Definitions readWsdl(String documentBaseURI, Document document) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, document);
    }

    @Override
    public Description readDescription(String documentBaseUri, Element element) throws WsdlException, IOException {
        DescriptionDocument defDoc = null;
        try {
            try {
                defDoc = DescriptionDocument.Factory.parse(element);
            }
            catch (Exception exp) {
                this.mLogger.fine("May not be the final WSDL 2.0 version, let's try 2006.01");
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder tmpBuilder = domFactory.newDocumentBuilder();
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer trans = transFactory.newTransformer();
                StringWriter strWriter = new StringWriter();
                StreamResult tmpStream = new StreamResult(strWriter);
                trans.transform(new DOMSource(element), tmpStream);
                domFactory.setNamespaceAware(false);
                Document tmpElement = tmpBuilder.parse(new StringBufferInputStream(strWriter.getBuffer().toString()));
                strWriter.close();
                this.recursivelyUpdate(tmpElement);
                strWriter = new StringWriter();
                StreamResult resultStream = new StreamResult(strWriter);
                trans.transform(new DOMSource(tmpElement), resultStream);
                domFactory.setNamespaceAware(true);
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                Document newElement = domBuilder.parse(new StringBufferInputStream(strWriter.getBuffer().toString()));
                defDoc = DescriptionDocument.Factory.parse(newElement);
                strWriter.close();
            }
            WsdlReader.validate(defDoc);
        }
        catch (XmlException ex) {
            throw new WsdlException(ex.getMessage());
        }
        catch (SAXException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (ParserConfigurationException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (TransformerConfigurationException exp) {
            throw new WsdlException(exp.getMessage());
        }
        catch (TransformerException exp) {
            throw new WsdlException(exp.getMessage());
        }
        return DescriptionImpl.Factory.getInstance(defDoc, documentBaseUri);
    }

    @Override
    public Definitions readWsdl(String documentBaseURI, Element definitionsElement) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, definitionsElement);
    }

    @Override
    public Description readDescription(String documentBaseURI, InputSource inputSource) throws WsdlException, IOException {
        return this.readDescription(documentBaseURI, DOMUtilities.getDocument(documentBaseURI, inputSource));
    }

    @Override
    public Definitions readWsdl(String documentBaseURI, InputSource inputSource) throws WsdlException, MalformedURLException, IOException {
        return (Definitions)this.readDescription(documentBaseURI, inputSource);
    }

    static URL getURL(URL contextURL, String specification) throws MalformedURLException {
        File tempFile;
        if (contextURL != null && (tempFile = new File(specification)).isAbsolute()) {
            return tempFile.toURL();
        }
        try {
            return new URL(contextURL, specification);
        }
        catch (MalformedURLException e) {
            if (contextURL == null) {
                return new File(specification).toURL();
            }
            throw e;
        }
    }
}

