/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.AbstractJMXClient;
import com.sun.jbi.ui.client.RemoteJBIAdminCommands;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.JMXConnectionException;
import java.util.Properties;

public abstract class RemoteJBIAdminCommandsFactory {
    public static final String FACTORY_IMPL_CLASS_PROP = "com.sun.jbi.ui.client.RemoteJBIAdminCommandsFactory";
    public static final String FACTORY_IMPL_CLASS = "com.sun.jbi.internal.ui.client.RemoteJBIAdminCommandsFactoryImpl";

    protected RemoteJBIAdminCommandsFactory() {
    }

    public static RemoteJBIAdminCommandsFactory newInstance() {
        String factoryImplClass = System.getProperty(FACTORY_IMPL_CLASS_PROP, FACTORY_IMPL_CLASS);
        RemoteJBIAdminCommandsFactory impl = null;
        try {
            impl = (RemoteJBIAdminCommandsFactory)Class.forName(factoryImplClass).newInstance();
        }
        catch (Exception ex) {
            impl = new DefaultFactoryImpl();
        }
        return impl;
    }

    public abstract RemoteJBIAdminCommands createRemoteJBIAdminCommands(Properties var1) throws JMXConnectionException;

    public static class DefaultRemoteJBIAdminCommandsImpl
    extends AbstractJMXClient
    implements RemoteJBIAdminCommands {
        private String mHost = null;

        public DefaultRemoteJBIAdminCommandsImpl(Properties connProps) {
            this.mHost = connProps.getProperty("com.sun.jbi.tools.remote.jmx.host");
        }

        @Override
        public String remoteDeployServiceAssembly(String zipFilePath) throws JBIRemoteException {
            String msg = JBIResultXmlBuilder.createFailedJbiResultXml(DefaultRemoteJBIAdminCommandsImpl.getI18NBundle(), "jbi.ui.client.remote.deploy.not.supported", new Object[]{this.mHost});
            throw new JBIRemoteException(new UnsupportedOperationException(msg));
        }

        @Override
        public String remoteInstallComponent(String zipFilePath, Properties params) throws JBIRemoteException {
            String msg = null;
            msg = params != null && params.size() > 0 ? JBIResultXmlBuilder.createFailedJbiResultXml(DefaultRemoteJBIAdminCommandsImpl.getI18NBundle(), "jbi.ui.client.remote.install.component.with.params.not.supported", new Object[]{this.mHost}) : JBIResultXmlBuilder.createFailedJbiResultXml(DefaultRemoteJBIAdminCommandsImpl.getI18NBundle(), "jbi.ui.client.remote.install.component.not.supported", new Object[]{this.mHost});
            throw new JBIRemoteException(new UnsupportedOperationException(msg));
        }

        @Override
        public String remoteInstallComponent(String zipFilePath) throws JBIRemoteException {
            String msg = JBIResultXmlBuilder.createFailedJbiResultXml(DefaultRemoteJBIAdminCommandsImpl.getI18NBundle(), "jbi.ui.client.remote.install.component.not.supported", new Object[]{this.mHost});
            throw new JBIRemoteException(new UnsupportedOperationException(msg));
        }

        @Override
        public String remoteInstallSharedLibrary(String zipFilePath) throws JBIRemoteException {
            String msg = JBIResultXmlBuilder.createFailedJbiResultXml(DefaultRemoteJBIAdminCommandsImpl.getI18NBundle(), "jbi.ui.client.remote.install.slib.not.supported", new Object[]{this.mHost});
            throw new JBIRemoteException(new UnsupportedOperationException(msg));
        }
    }

    private static class DefaultFactoryImpl
    extends RemoteJBIAdminCommandsFactory {
        @Override
        public RemoteJBIAdminCommands createRemoteJBIAdminCommands(Properties connProps) throws JMXConnectionException {
            return new DefaultRemoteJBIAdminCommandsImpl(connProps);
        }

        public String toString() {
            return "Default RemoteJBIAdminCommandsFactory Implementation";
        }
    }
}

