/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.management.ComponentMessageHolder;
import com.sun.jbi.management.DeploymentServiceMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.ee.ApplicationInterceptor;
import com.sun.jbi.management.ee.JavaEEApplicationInterceptor;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.management.ObjectName;

public class DeploymentService
extends Facade
implements DeploymentServiceMBean {
    private static final String JAVA_EE_SE = "sun-javaee-engine";
    private static final String DEPLOY = "deploy";
    private static final String UNDEPLOY = "undeploy";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String SHUT_DOWN = "shutDown";
    private static final String GET_SA_DESCRIPTOR = "ServiceAssemblyDescriptor";
    private static final String GET_SU_DESCRIPTOR = "ServiceUnitDescriptor";
    private static final String CURRENT_STATE = "CurrentState";
    private ApplicationInterceptor mInterceptor;

    public DeploymentService(EnvironmentContext ctx, String target) throws ManagementException {
        super(ctx, target);
        this.mInterceptor = new JavaEEApplicationInterceptor(ctx);
    }

    public String deploy(String serviceAssemblyZipUrl) throws Exception {
        try {
            return this.deployServiceAssembly(serviceAssemblyZipUrl);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    private String deployServiceAssembly(String serviceAssemblyZipUrl) throws ManagementException {
        boolean wasPreRegistered = false;
        Archive saArchive = this.validateArchive(serviceAssemblyZipUrl, ArchiveType.SERVICE_ASSEMBLY, DEPLOY);
        String saName = saArchive.getJbiXml(false).getServiceAssembly().getIdentification().getName();
        if (this.mTarget.equals("domain")) {
            this.serviceAssemblyRegistrationCheck(DEPLOY, saName, false);
            this.addServiceAssemblyToDomain(DEPLOY, saName, saArchive);
            this.performJavaEEProcessing(saName, DEPLOY);
            return this.mMsgBuilder.buildFrameworkMessage(DEPLOY, MessageBuilder.TaskResult.SUCCESS);
        }
        boolean isRegistered = false;
        try {
            isRegistered = this.getGenericQuery().isServiceAssemblyRegistered(saName);
        }
        catch (RegistryException rex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)rex)));
            String errMsg = this.mMsgBuilder.buildExceptionMessage("deployServiceAssembly", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
        if (!isRegistered) {
            this.addServiceAssemblyToDomain(DEPLOY, saName, saArchive);
        } else {
            File newFile = new File(serviceAssemblyZipUrl);
            File domainFile = new File(this.getRegistry().getRepository().findArchive(ArchiveType.SERVICE_ASSEMBLY, saName));
            this.archiveEqualityCheck(newFile, domainFile, ArchiveType.SERVICE_ASSEMBLY, saName);
            wasPreRegistered = true;
        }
        try {
            return this.deployServiceAssemblyToTarget(saName, serviceAssemblyZipUrl);
        }
        catch (ManagementException mex) {
            if (!wasPreRegistered) {
                this.removeServiceAssemblyFromDomain(DEPLOY, saName);
            }
            throw mex;
        }
    }

    public String undeploy(String serviceAssemblyName) throws Exception {
        return this.undeploy(serviceAssemblyName, false, false);
    }

    public String start(String serviceAssemblyName) throws Exception {
        try {
            serviceAssemblyName = serviceAssemblyName.trim();
            String response = null;
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException(START);
            } else {
                this.serviceAssemblyDeploymentCheck(serviceAssemblyName);
                this.performJavaEEProcessing(serviceAssemblyName, START);
                response = this.startServiceAssemblyOnTarget(serviceAssemblyName);
            }
            return response;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public String stop(String serviceAssemblyName) throws Exception {
        try {
            String response = null;
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException(STOP);
            } else {
                this.serviceAssemblyDeploymentCheck(serviceAssemblyName);
                this.performJavaEEProcessing(serviceAssemblyName, STOP);
                response = this.stopServiceAssemblyOnTarget(serviceAssemblyName);
            }
            return response;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public String shutDown(String serviceAssemblyName) throws Exception {
        return this.shutDown(serviceAssemblyName, false);
    }

    public boolean canDeployToComponent(String componentName) {
        boolean canDeploy;
        block8: {
            canDeploy = false;
            try {
                if ("domain".equals(this.mTarget)) {
                    canDeploy = false;
                    break block8;
                }
                if (this.isComponentInstalled(componentName) && this.mEnvCtx.isStartOnDeployEnabled()) {
                    canDeploy = true;
                    break block8;
                }
                if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                    canDeploy = ComponentState.STARTED.equals((Object)this.getComponentState(componentName, this.mTarget));
                    break block8;
                }
                ComponentType compType = this.getComponentType(componentName);
                if (compType == null) break block8;
                ObjectName facadeComponentLCMBean = null;
                facadeComponentLCMBean = this.mMBeanNames.getComponentMBeanName(componentName, compType, MBeanNames.ComponentServiceType.ComponentLifeCycle, this.mTarget);
                try {
                    String state = (String)this.mMBeanSvr.getAttribute(facadeComponentLCMBean, CURRENT_STATE);
                    ComponentState effState = ComponentState.valueOfLifeCycleState(state);
                    if (effState == ComponentState.STARTED) {
                        canDeploy = true;
                    }
                }
                catch (Exception ex) {
                    this.mLog.fine(MessageHelper.getMsgString(ex));
                    canDeploy = false;
                }
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
                canDeploy = false;
            }
        }
        return canDeploy;
    }

    public String[] getDeployedServiceUnitList(String componentName) throws Exception {
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
        ArrayList<String> sus = new ArrayList<String>();
        if (compInfo != null) {
            List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                sus.add(suInfo.getName());
            }
        }
        return sus.toArray(new String[sus.size()]);
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        List<String> saList = this.getServiceAssemblyQuery().getServiceAssemblies();
        return saList.toArray(new String[saList.size()]);
    }

    public String getServiceAssemblyDescriptor(String serviceAssemblyName) throws Exception {
        try {
            this.serviceAssemblyRegistrationCheck(GET_SA_DESCRIPTOR, serviceAssemblyName, true);
            String jbiXml = null;
            try {
                jbiXml = this.getGenericQuery().getServiceAssemblyDeploymentDescriptor(serviceAssemblyName);
            }
            catch (RegistryException rex) {
                String response = this.mMsgBuilder.buildExceptionMessage(GET_SA_DESCRIPTOR, (Throwable)((Object)rex));
                throw new ManagementException(response);
            }
            if (jbiXml == null) {
                String[] params = new String[]{serviceAssemblyName};
                this.mMsgBuilder.throwManagementException(GET_SA_DESCRIPTOR, "JBI_ADMIN_FAILED_GET_SERVICE_ASSEMBLY_DESCRIPTOR", params);
            }
            return jbiXml;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public String getServiceUnitDescriptor(String serviceAssemblyName, String serviceUnitName) throws Exception {
        try {
            this.serviceAssemblyRegistrationCheck(GET_SA_DESCRIPTOR, serviceAssemblyName, true);
            String jbiXml = null;
            try {
                jbiXml = this.getGenericQuery().getServiceUnitDeploymentDescriptor(serviceAssemblyName, serviceUnitName);
            }
            catch (RegistryException rex) {
                String response = this.mMsgBuilder.buildExceptionMessage(GET_SU_DESCRIPTOR, (Throwable)((Object)rex));
                throw new ManagementException(response);
            }
            if (jbiXml == null) {
                String[] params = new String[]{serviceAssemblyName, serviceAssemblyName};
                this.mMsgBuilder.throwManagementException(GET_SU_DESCRIPTOR, "JBI_ADMIN_FAILED_GET_SERVICE_UNIT_DESCRIPTOR", params);
            }
            return jbiXml;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) throws Exception {
        if ("domain".equals(this.mTarget)) {
            List<String> allTargets = this.getAllTargets();
            ArrayList<String> allSAs = new ArrayList<String>();
            for (String target : allTargets) {
                String[] currentSAs;
                for (String sa : currentSAs = this.getDeployedServiceAssembliesForComponent(target, componentName)) {
                    if (allSAs.contains(sa)) continue;
                    allSAs.add(sa);
                }
            }
            return allSAs.toArray(new String[allSAs.size()]);
        }
        return this.getDeployedServiceAssembliesForComponent(this.mTarget, componentName);
    }

    @Override
    public String getServiceAssemblyName(String serviceUnitName, String componentName) throws Exception {
        String serviceAssemblyName = null;
        if ("domain".equals(this.mTarget)) {
            this.throwNotSupportedManagementException("getServiceAssemblyName");
        } else {
            ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
            if (compInfo != null) {
                List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
                for (ServiceUnitInfo suInfo : suList) {
                    if (!suInfo.getName().equals(serviceUnitName)) continue;
                    serviceAssemblyName = suInfo.getServiceAssemblyName();
                }
            }
        }
        return serviceAssemblyName;
    }

    public String[] getComponentsForDeployedServiceAssembly(String serviceAssemblyName) throws Exception {
        List allComponents = this.getComponentQuery().getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        ArrayList<String> comps = new ArrayList<String>();
        for (String compName : allComponents) {
            ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(compName);
            if (compInfo == null) continue;
            List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                if (!suInfo.getServiceAssemblyName().equals(serviceAssemblyName)) continue;
                comps.add(compName);
            }
        }
        return comps.toArray(new String[comps.size()]);
    }

    public boolean isDeployedServiceUnit(String componentName, String serviceUnitName) throws Exception {
        boolean isDeployed = false;
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
        if (compInfo != null) {
            List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                if (!suInfo.getName().equals(serviceUnitName)) continue;
                isDeployed = true;
            }
        }
        return isDeployed;
    }

    public String getState(String serviceAssemblyName) throws Exception {
        try {
            if ("domain".equals(this.mTarget)) {
                return this.getStateFromAllTargets(serviceAssemblyName);
            }
            return this.getStateFromTarget(serviceAssemblyName);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public String getServiceUnitState(String componentName, String serviceUnitName) throws JBIException {
        try {
            if ("domain".equals(this.mTarget)) {
                return this.getServiceUnitStateFromAllTargets(componentName, serviceUnitName);
            }
            return this.getServiceUnitStateFromTarget(componentName, serviceUnitName);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public String deployFromRepository(String serviceAssemblyName) throws JBIException {
        try {
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException("deployFromRepository()");
            }
            this.serviceAssemblyRegistrationCheck(DEPLOY, serviceAssemblyName, true);
            Archive saArchive = this.getRegistry().getRepository().getArchive(ArchiveType.SERVICE_ASSEMBLY, serviceAssemblyName);
            String serviceAssemblyZipUrl = saArchive.getPath();
            this.mLog.log(Level.FINE, "Deploying service assembly from repository {0} to target {1}", new Object[]{serviceAssemblyZipUrl, this.mTarget});
            return this.deployServiceAssemblyToTarget(serviceAssemblyName, serviceAssemblyZipUrl);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public String undeploy(String serviceAssemblyName, boolean force) throws Exception {
        return this.undeploy(serviceAssemblyName, force, false);
    }

    @Override
    public String undeploy(String serviceAssemblyName, boolean force, boolean keep) throws Exception {
        try {
            this.serviceAssemblyRegistrationCheck(UNDEPLOY, serviceAssemblyName, true);
            if (this.mTarget.equals("domain")) {
                if (this.getGenericQuery().isServiceAssemblyDeployed(serviceAssemblyName)) {
                    String[] params = new String[]{serviceAssemblyName};
                    this.mMsgBuilder.throwManagementException(UNDEPLOY, "JBI_ADMIN_SERVICE_ASSEMBLY_IS_DEPLOYED", params);
                }
                this.performJavaEEProcessing(serviceAssemblyName, UNDEPLOY);
                this.removeServiceAssemblyFromDomain(UNDEPLOY, serviceAssemblyName);
                return this.mMsgBuilder.buildFrameworkMessage(UNDEPLOY, MessageBuilder.TaskResult.SUCCESS);
            }
            String response = this.undeployServiceAssemblyFromTarget(serviceAssemblyName, force);
            if (!this.getGenericQuery().isServiceAssemblyDeployed(serviceAssemblyName) && !keep) {
                this.removeServiceAssemblyFromDomain(UNDEPLOY, serviceAssemblyName);
            }
            return response;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public String shutDown(String serviceAssemblyName, boolean force) throws Exception {
        try {
            String response = null;
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException(SHUT_DOWN);
            } else {
                this.serviceAssemblyDeploymentCheck(serviceAssemblyName);
                this.performJavaEEProcessing(serviceAssemblyName, SHUT_DOWN);
                response = this.shutDownServiceAssemblyOnTarget(serviceAssemblyName, force);
            }
            return response;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    private void serviceAssemblyRegistrationCheck(String taskId, String serviceAssemblyName, boolean throwExWhenNotRegistered) throws ManagementException {
        String[] params;
        boolean registered = false;
        try {
            registered = this.getGenericQuery().isServiceAssemblyRegistered(serviceAssemblyName);
        }
        catch (RegistryException rex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("serviceAssemblyRegistrationCheck", (Throwable)((Object)rex)));
        }
        if (!registered && throwExWhenNotRegistered) {
            params = new String[]{serviceAssemblyName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_UNKNOWN_SERVICE_ASSEMBLY", params);
        }
        if (registered && !throwExWhenNotRegistered) {
            params = new String[]{serviceAssemblyName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_KNOWN_SERVICE_ASSEMBLY", params);
        }
    }

    private void addServiceAssemblyToDomain(String taskId, String saName, Archive saArchive) throws ManagementException {
        try {
            this.getRegistry().getRepository().addArchive(saArchive);
            this.getUpdater().addServiceAssembly(saName, saArchive.getFileName(), saArchive.getUploadTimestamp());
        }
        catch (RegistryException ex) {
            String[] params = new String[]{saName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_SERVICE_ASSEMBLY", params);
        }
        catch (RepositoryException ex) {
            String[] params = new String[]{saName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_SERVICE_ASSEMBLY", params);
        }
    }

    private void removeServiceAssemblyFromDomain(String taskId, String saName) throws ManagementException {
        try {
            this.getUpdater().removeServiceAssembly("domain", saName);
            this.getRegistry().getRepository().removeArchive(ArchiveType.SERVICE_ASSEMBLY, saName);
        }
        catch (RegistryException ex) {
            String[] params = new String[]{saName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_SERVICE_ASSEMBLY", params);
        }
        catch (RepositoryException ex) {
            String[] params = new String[]{saName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_SERVICE_ASSEMBLY", params);
        }
    }

    private String deployServiceAssemblyToTarget(String saName, String saZipUrl) throws ManagementException {
        String response = null;
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_DEPLOYING_SERVICE_ASSEMBLY_TO_TARGET", saName, this.mTarget));
        this.targetComponentsInstallationCheck(saName, true);
        this.performJavaEEProcessing(saName, DEPLOY);
        List<ServiceUnitInfo> suList = new ArrayList<ServiceUnitInfo>();
        try {
            this.autoStartComponents(saName);
            response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.deployServiceAssemblyToInstance(saName, saZipUrl, this.mTarget) : this.deployServiceAssemblyToCluster(saName, saZipUrl, this.mTarget);
            suList = this.mMsgBuilder.getSuccessfulServiceUnits(response, this.getServiceUnitList(saName, "domain"));
            this.addServiceUnitsToTarget(suList);
            MessageBuilder.Message msg = this.mMsgBuilder.createMessage(response);
            if (msg.isSuccess()) {
                this.addServiceAssemblyToTarget(saName);
            }
            String string = response;
            return string;
        }
        catch (ManagementException mex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            throw mex;
        }
        finally {
            if (this.isComponentInstalled(JAVA_EE_SE)) {
                List<ServiceUnitInfo> suRollbackList = this.getJavaEEFailedServiceUnits(this.getServiceUnitList(saName, "domain"), suList);
                this.undoJavaEEProcessing(DEPLOY, saName, suRollbackList);
            }
        }
    }

    private String undeployServiceAssemblyFromTarget(String saName, boolean force) throws ManagementException {
        this.serviceAssemblyDeploymentCheck(saName);
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_UNDEPLOYING_SERVICE_ASSEMBLY_FROM_TARGET", saName, this.mTarget));
        this.performJavaEEProcessing(saName, UNDEPLOY);
        String response = null;
        response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.undeployServiceAssemblyFromInstance(saName, this.mTarget, force) : this.undeployServiceAssemblyFromCluster(saName, this.mTarget, force);
        List<ServiceUnitInfo> suList = this.mMsgBuilder.getSuccessfulServiceUnits(response, this.getServiceUnitList(saName, this.mTarget));
        this.removeServiceUnitsFromTarget(suList);
        MessageBuilder.Message msg = this.mMsgBuilder.createMessage(response);
        if (msg.isSuccess()) {
            this.removeServiceAssemblyFromTarget(saName);
        }
        return response;
    }

    private List<ServiceUnitInfo> getJavaEEFailedServiceUnits(List<ServiceUnitInfo> allSus, List<ServiceUnitInfo> sccsSus) {
        ArrayList<ServiceUnitInfo> rollbackSus = new ArrayList<ServiceUnitInfo>();
        block0: for (ServiceUnitInfo suInfo : allSus) {
            if (!suInfo.getTargetComponent().equals(JAVA_EE_SE)) continue;
            rollbackSus.add(suInfo);
            boolean succeeded = false;
            for (ServiceUnitInfo sccsInfo : sccsSus) {
                if (!sccsInfo.getName().equals(suInfo.getName())) continue;
                System.out.append("Removing service unit " + suInfo.getName() + " from rollback list");
                rollbackSus.remove(suInfo);
                continue block0;
            }
        }
        return rollbackSus;
    }

    private boolean isServiceUnitDeployedToComponentOnTarget(String componentName, String serviceUnitName) throws ManagementException {
        boolean isServiceUnitDeployed = false;
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
        if (compInfo != null) {
            List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                if (!suInfo.getName().equals(serviceUnitName)) continue;
                isServiceUnitDeployed = true;
                break;
            }
        }
        return isServiceUnitDeployed;
    }

    private void serviceUnitDeploymentCheck(String componentName, String serviceUnitName) throws ManagementException {
        if (!this.isServiceUnitDeployedToComponentOnTarget(componentName, serviceUnitName)) {
            Object[] params = new String[]{serviceUnitName, componentName, this.mTarget};
            String msg = this.mTranslator.getString("JBI_ADMIN_SERVICE_UNIT_NOT_DEPLOYED_ON_TARGET", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("serviceUnitDeploymentCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(msg), (String[])params, MessageBuilder.getMessageToken(msg));
            throw new ManagementException(jbiMsg);
        }
    }

    private boolean isServiceAssemblyDeployedOnTarget(String saName) throws ManagementException {
        try {
            List<String> servers = this.getGenericQuery().getServersDeployingServiceAssembly(saName);
            if (servers.contains(this.mTarget)) {
                return true;
            }
            List<String> clusters = this.getGenericQuery().getClustersDeployingServiceAssembly(saName);
            return clusters.contains(this.mTarget);
        }
        catch (RegistryException rex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("isServiceAssemblyDeployedOnTarget", (Throwable)((Object)rex)));
        }
    }

    private void serviceAssemblyDeploymentCheck(String saName) throws ManagementException {
        if (!this.isServiceAssemblyDeployedOnTarget(saName)) {
            Object[] params = new String[]{saName, this.mTarget};
            String msg = this.mTranslator.getString("JBI_ADMIN_SERVICE_ASSEMBLY_NOT_DEPLOYED_ON_TARGET", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("serviceAssemblyDeploymentCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(msg), (String[])params, MessageBuilder.getMessageToken(msg));
            throw new ManagementException(jbiMsg);
        }
    }

    private void serviceAssemblyShutdownCheck(String saName, String instanceName, boolean force) throws ManagementException {
        String saState = "Shutdown";
        try {
            saState = this.getStateFromInstance(saName, instanceName);
        }
        catch (ManagementException mex) {
            if (force) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
                return;
            }
            throw mex;
        }
        if (!"Shutdown".equals(saState)) {
            Object[] params = new String[]{saName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_SERVICE_ASSEMBLY_NOT_SHUTDOWN", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("serviceAssemblyShutdownCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiMsg);
        }
    }

    private ObjectName getRemotedeploymentServiceObjectName(String instanceName) {
        MBeanNames mbnNames = this.mMgtCtx.getMBeanNames(instanceName);
        return mbnNames.getSystemServiceMBeanName("DeploymentService", "DeploymentService");
    }

    private void targetComponentsInstallationCheck(String saName, boolean isDeploy) throws ManagementException {
        List<String> comps = null;
        comps = isDeploy ? this.getTargetComponents("domain", saName) : this.getTargetComponents(this.mTarget, saName);
        for (String compName : comps) {
            if (this.isComponentInstalled(compName)) continue;
            String errMsg = this.mTranslator.getString("JBI_ADMIN_SERVICE_ASSEMBLY_TARGET_NOT_INSTALLED", compName, this.mTarget);
            String mmsg = this.mMsgBuilder.buildFrameworkMessage("targetComponentsInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{compName, this.mTarget}, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(mmsg);
        }
    }

    private void targetComponentsRunningCheck(String saName, String instanceName) throws ManagementException {
        List<String> comps = this.getTargetComponents("domain", saName);
        for (String compName : comps) {
            ComponentState state = this.getComponentState(compName, instanceName);
            if (ComponentState.STARTED == state) continue;
            String errMsg = null;
            errMsg = ComponentState.UNKNOWN == state ? this.mTranslator.getString("JBI_ADMIN_COMPONENT_NOT_INSTALLED_ON_INSTANCE", compName, instanceName) : this.mTranslator.getString("JBI_ADMIN_SERVICE_ASSEMBLY_TARGET_NOT_STARTED", compName, instanceName);
            String mmsg = this.mMsgBuilder.buildFrameworkMessage("targetComponentsRunningCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{compName, instanceName}, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(mmsg);
        }
    }

    private void targetComponentsDownCheck(String saName, String instanceName, boolean force) throws ManagementException {
        List<String> comps = this.getTargetComponents(this.mTarget, saName);
        for (String compName : comps) {
            ComponentState state = this.getComponentState(compName, instanceName);
            if ((ComponentState.SHUTDOWN != state || force) && ComponentState.UNKNOWN != state) continue;
            String errMsg = this.mTranslator.getString("JBI_ADMIN_SERVICE_ASSEMBLY_TARGET_INCORRECT_STATE", compName);
            String mmsg = this.mMsgBuilder.buildFrameworkMessage("targetComponentsDownCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{compName, state.toString()}, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(mmsg);
        }
    }

    private List<String> getTargetComponents(String target, String saName) throws ManagementException {
        ServiceAssemblyQuery saQuery = null;
        try {
            saQuery = this.getRegistry().getServiceAssemblyQuery(target);
        }
        catch (RegistryException rex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("getTargetComponents", (Throwable)((Object)rex)));
        }
        ArrayList<String> components = new ArrayList<String>();
        ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(saName);
        if (saInfo != null) {
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                components.add(suInfo.getTargetComponent());
            }
        }
        return components;
    }

    private String startServiceAssemblyOnTarget(String serviceAssemblyName) throws ManagementException {
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_STARTING_SERVICE_ASSEMBLY_ON_TARGET", serviceAssemblyName, this.mTarget));
        String response = null;
        response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.startServiceAssemblyOnInstance(serviceAssemblyName, this.mTarget) : this.startServiceAssemblyOnCluster(serviceAssemblyName, this.mTarget);
        List<ServiceUnitInfo> suList = this.mMsgBuilder.getSuccessfulServiceUnits(response, this.getServiceUnitList(serviceAssemblyName, this.mTarget));
        this.setServiceUnitsStateOnTarget(ServiceUnitState.STARTED, suList);
        return response;
    }

    private String stopServiceAssemblyOnTarget(String serviceAssemblyName) throws ManagementException {
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_STOPPING_SERVICE_ASSEMBLY_ON_TARGET", serviceAssemblyName, this.mTarget));
        String response = null;
        response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.stopServiceAssemblyOnInstance(serviceAssemblyName, this.mTarget) : this.stopServiceAssemblyOnCluster(serviceAssemblyName, this.mTarget);
        List<ServiceUnitInfo> suList = this.mMsgBuilder.getSuccessfulServiceUnits(response, this.getServiceUnitList(serviceAssemblyName, this.mTarget));
        this.setServiceUnitsStateOnTarget(ServiceUnitState.STOPPED, suList);
        return response;
    }

    private String shutDownServiceAssemblyOnTarget(String serviceAssemblyName, boolean force) throws ManagementException {
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_SHUTTING_DOWN_SERVICE_ASSEMBLY_ON_TARGET", serviceAssemblyName, this.mTarget));
        String response = null;
        response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.shutDownServiceAssemblyOnInstance(serviceAssemblyName, this.mTarget, force) : this.shutDownServiceAssemblyOnCluster(serviceAssemblyName, this.mTarget, force);
        List<ServiceUnitInfo> suList = this.mMsgBuilder.getSuccessfulServiceUnits(response, this.getServiceUnitList(serviceAssemblyName, this.mTarget));
        this.setServiceUnitsStateOnTarget(ServiceUnitState.SHUTDOWN, suList);
        return response;
    }

    private String getStateFromTarget(String serviceAssemblyName) throws ManagementException {
        this.serviceAssemblyDeploymentCheck(serviceAssemblyName);
        String state = null;
        state = this.mPlatform.isStandaloneServer(this.mTarget) ? this.getStateFromInstance(serviceAssemblyName, this.mTarget) : this.getStateFromCluster(serviceAssemblyName, this.mTarget);
        return state;
    }

    private String deployServiceAssemblyToInstance(String saName, String saZipUrl, String instanceName) throws ManagementException {
        String response = null;
        if (!this.isInstanceRunning(instanceName)) {
            return this.buildSuccessMessage(saName, DEPLOY, "domain");
        }
        this.targetComponentsRunningCheck(saName, instanceName);
        saZipUrl = !this.mPlatform.getAdminServerName().equals(this.mTarget) ? this.uploadFile(instanceName, saZipUrl) : this.toFileURL(saZipUrl);
        Object[] params = new Object[]{saZipUrl};
        String[] sign = new String[]{"java.lang.String"};
        response = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), DEPLOY, params, sign, instanceName);
        return response;
    }

    private String deployServiceAssemblyToCluster(String saName, String saZipUrl, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.deployServiceAssemblyToInstance(saName, saZipUrl, instance);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage(DEPLOY, responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.buildSuccessMessage(saName, DEPLOY, "domain");
        return response;
    }

    private String undeployServiceAssemblyFromInstance(String saName, String instanceName, boolean force) throws ManagementException {
        String response = null;
        if (this.isInstanceRunning(instanceName)) {
            if (!this.isServiceAssemblyDeployedInInstance(saName, instanceName)) {
                String msg = this.mTranslator.getString("JBI_ADMIN_SA_NOT_DEPLOYED_IN_INSTANCE", saName, instanceName);
                String[] parameters = new String[]{saName, instanceName};
                this.mLog.fine(msg);
                return this.mMsgBuilder.buildFrameworkMessage(UNDEPLOY, MessageBuilder.TaskResult.SUCCESS, MessageBuilder.MessageType.INFO, MessageBuilder.getMessageString(msg), parameters, MessageBuilder.getMessageToken(msg));
            }
        } else {
            return this.buildSuccessMessage(saName, UNDEPLOY, this.mPlatform.getTargetName(instanceName));
        }
        this.serviceAssemblyShutdownCheck(saName, instanceName, force);
        this.targetComponentsInstallationCheck(saName, false);
        this.targetComponentsDownCheck(saName, instanceName, force);
        Object[] params = new Object[]{saName, force};
        String[] sign = new String[]{"java.lang.String", "boolean"};
        response = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), UNDEPLOY, params, sign, instanceName);
        return response;
    }

    private String undeployServiceAssemblyFromCluster(String saName, String clusterName, boolean force) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.undeployServiceAssemblyFromInstance(saName, instance, force);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage(UNDEPLOY, responseMap, exceptionMap, true);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        return this.buildSuccessMessage(saName, UNDEPLOY, clusterName);
    }

    private String stopServiceAssemblyOnInstance(String serviceAssemblyName, String instanceName) throws ManagementException {
        String response = null;
        if (!this.isInstanceRunning(instanceName)) {
            return this.buildSuccessMessage(serviceAssemblyName, STOP, this.mPlatform.getTargetName(instanceName));
        }
        Object[] params = new Object[]{serviceAssemblyName};
        String[] sign = new String[]{"java.lang.String"};
        response = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), STOP, params, sign, instanceName);
        return response;
    }

    private String stopServiceAssemblyOnCluster(String saName, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.stopServiceAssemblyOnInstance(saName, instance);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage(STOP, responseMap, exceptionMap, true);
            if (msg.isSuccess() && this.getServiceAssemblyState(saName) == ServiceAssemblyState.STOPPED) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.buildSuccessMessage(saName, STOP, clusterName);
        return response;
    }

    private String shutDownServiceAssemblyOnInstance(String serviceAssemblyName, String instanceName, boolean force) throws ManagementException {
        String response = null;
        if (!this.isInstanceRunning(instanceName)) {
            return this.buildSuccessMessage(serviceAssemblyName, SHUT_DOWN, this.mPlatform.getTargetName(instanceName));
        }
        Object[] params = new Object[]{serviceAssemblyName, force};
        String[] sign = new String[]{"java.lang.String", "boolean"};
        response = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), SHUT_DOWN, params, sign, instanceName);
        return response;
    }

    private String shutDownServiceAssemblyOnCluster(String saName, String clusterName, boolean force) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.shutDownServiceAssemblyOnInstance(saName, instance, force);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage(SHUT_DOWN, responseMap, exceptionMap, true);
            if (msg.isSuccess() && this.getServiceAssemblyState(saName) == ServiceAssemblyState.SHUTDOWN) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.buildSuccessMessage(saName, SHUT_DOWN, clusterName);
        return response;
    }

    private String startServiceAssemblyOnInstance(String serviceAssemblyName, String instanceName) throws ManagementException {
        String response = null;
        if (!this.isInstanceRunning(instanceName)) {
            return this.buildSuccessMessage(serviceAssemblyName, START, this.mPlatform.getTargetName(instanceName));
        }
        Object[] params = new Object[]{serviceAssemblyName};
        String[] sign = new String[]{"java.lang.String"};
        response = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), START, params, sign, instanceName);
        return response;
    }

    private String startServiceAssemblyOnCluster(String saName, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.startServiceAssemblyOnInstance(saName, instance);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage(START, responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.buildSuccessMessage(saName, START, clusterName);
        return response;
    }

    private String getStateFromInstance(String serviceAssemblyName, String instanceName) throws ManagementException {
        String state = null;
        if (this.isInstanceRunning(instanceName)) {
            Object[] params = new Object[]{serviceAssemblyName};
            String[] sign = new String[]{"java.lang.String"};
            state = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), "getState", params, sign, instanceName);
        } else {
            state = ServiceAssemblyState.convertState(ServiceAssemblyState.SHUTDOWN);
        }
        this.mLog.log(Level.FINEST, "State of service assembly {0} on instance {1} is {2}", new Object[]{serviceAssemblyName, instanceName, state});
        return state;
    }

    private String getStateFromCluster(String saName, String clusterName) throws ManagementException {
        String state = ServiceAssemblyState.convertState(ServiceAssemblyState.SHUTDOWN);
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            ArrayList<ServiceAssemblyState> statesInCluster = new ArrayList<ServiceAssemblyState>();
            for (String instance : instances) {
                try {
                    if (this.isInstanceRunning(instance)) {
                        String instState = this.getStateFromInstance(saName, instance);
                        statesInCluster.add(ServiceAssemblyState.valueOfDeploymentServiceState(instState));
                        continue;
                    }
                    statesInCluster.add(ServiceAssemblyState.SHUTDOWN);
                }
                catch (ManagementException mex) {
                    this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
                    statesInCluster.add(ServiceAssemblyState.UNKNOWN);
                }
            }
            this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_STATE_OF_SERVICE_ASSEMBLY_IN_CLUSTER", saName, clusterName, ((Object)statesInCluster).toString()));
            ServiceAssemblyState effState = ServiceAssemblyState.getEffectiveServiceAssemblyState(statesInCluster);
            state = ServiceAssemblyState.convertState(effState);
        }
        return state;
    }

    private String getServiceUnitStateFromTarget(String componentName, String serviceUnitName) throws ManagementException {
        this.componentInstallationCheck(componentName, false);
        this.serviceUnitDeploymentCheck(componentName, serviceUnitName);
        String state = null;
        state = this.mPlatform.isStandaloneServer(this.mTarget) ? this.getServiceUnitStateFromInstance(componentName, serviceUnitName, this.mTarget) : this.getServiceUnitStateFromCluster(componentName, serviceUnitName, this.mTarget);
        return state;
    }

    private String getServiceUnitStateFromInstance(String componentName, String serviceUnitName, String instanceName) throws ManagementException {
        String state = null;
        if (this.isInstanceRunning(instanceName)) {
            Object[] params = new Object[]{componentName, serviceUnitName};
            String[] sign = new String[]{"java.lang.String", "java.lang.String"};
            state = (String)this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), "getServiceUnitState", params, sign, instanceName);
        } else {
            state = ServiceUnitState.convertState(ServiceUnitState.SHUTDOWN);
        }
        this.mLog.log(Level.FINEST, "State of service unit {0} on instance {1} is {2}", new Object[]{serviceUnitName, instanceName, state});
        return state;
    }

    private String getServiceUnitStateFromCluster(String componentName, String serviceUnitName, String clusterName) throws ManagementException {
        String state = ServiceUnitState.convertState(ServiceUnitState.SHUTDOWN);
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            ArrayList<ServiceUnitState> statesInCluster = new ArrayList<ServiceUnitState>();
            for (String instance : instances) {
                try {
                    if (this.isInstanceRunning(instance)) {
                        String instState = this.getServiceUnitStateFromInstance(componentName, serviceUnitName, instance);
                        statesInCluster.add(ServiceUnitState.valueOfDeploymentServiceState(instState));
                        continue;
                    }
                    statesInCluster.add(ServiceUnitState.SHUTDOWN);
                }
                catch (ManagementException mex) {
                    this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
                    statesInCluster.add(ServiceUnitState.UNKNOWN);
                }
            }
            Object[] params = new String[]{serviceUnitName, componentName, clusterName, ((Object)statesInCluster).toString()};
            this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_STATE_OF_SERVICE_UNIT_IN_CLUSTER", params));
            ServiceUnitState effState = ServiceUnitState.getEffectiveServiceAssemblyState(statesInCluster);
            state = ServiceUnitState.convertState(effState);
        }
        return state;
    }

    private void addServiceUnitsToTarget(List<ServiceUnitInfo> suList) throws ManagementException {
        if (!this.mPlatform.getAdminServerName().equals(this.mTarget)) {
            try {
                for (ServiceUnitInfo suInfo : suList) {
                    if (this.isDeployedServiceUnit(suInfo.getTargetComponent(), suInfo.getName())) {
                        this.mLog.log(Level.FINE, "Service unit {0} is already registered", suInfo.getName());
                        continue;
                    }
                    this.getUpdater().addServiceUnitToComponent(this.mTarget, suInfo.getTargetComponent(), suInfo);
                }
            }
            catch (Exception rex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("addServiceUnitsToTarget", rex);
                throw new ManagementException(msg);
            }
        }
    }

    private void removeServiceUnitsFromTarget(List<ServiceUnitInfo> suList) throws ManagementException {
        if (!this.mPlatform.getAdminServerName().equals(this.mTarget)) {
            try {
                for (ServiceUnitInfo suInfo : suList) {
                    this.getUpdater().removeServiceUnitFromComponent(this.mTarget, suInfo.getTargetComponent(), suInfo.getName());
                }
            }
            catch (RegistryException rex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("removeServiceUnitsFromTarget", (Throwable)((Object)rex));
                throw new ManagementException(msg);
            }
        }
    }

    private void setServiceUnitsStateOnTarget(ServiceUnitState state, List<ServiceUnitInfo> suList) throws ManagementException {
        if (!this.mPlatform.getAdminServerName().equals(this.mTarget)) {
            try {
                for (ServiceUnitInfo suInfo : suList) {
                    this.getUpdater().setServiceUnitState(this.mTarget, state, suInfo.getTargetComponent(), suInfo.getName());
                }
            }
            catch (RegistryException rex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("setServiceUnitsStateOnTarget", (Throwable)((Object)rex));
                throw new ManagementException(msg);
            }
        }
    }

    private void addServiceAssemblyToTarget(String saName) throws ManagementException {
        if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
            try {
                if (!this.getRegistry().getServiceAssemblyQuery(this.mTarget).getServiceAssemblies().contains(saName)) {
                    this.getUpdater().addServiceAssembly(this.mTarget, saName);
                }
            }
            catch (RegistryException rex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("addServiceAssemblyToTarget", (Throwable)((Object)rex));
                throw new ManagementException(msg);
            }
        }
    }

    private void removeServiceAssemblyFromTarget(String saName) throws ManagementException {
        if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
            try {
                this.getUpdater().removeServiceAssembly(this.mTarget, saName);
            }
            catch (RegistryException rex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("removeServiceAssemblyFromTarget", (Throwable)((Object)rex));
                throw new ManagementException(msg);
            }
        }
    }

    List<ServiceUnitInfo> getServiceUnitList(String saName, String target) {
        ServiceAssemblyQuery saQuery;
        ArrayList<ServiceUnitInfo> suList = new ArrayList<ServiceUnitInfo>();
        try {
            saQuery = this.getRegistry().getServiceAssemblyQuery(target);
        }
        catch (RegistryException rex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)rex)));
            return suList;
        }
        ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(saName);
        if (saInfo != null) {
            return saInfo.getServiceUnitList();
        }
        return suList;
    }

    private String buildSuccessMessage(String saName, String taskId, String target) throws ManagementException {
        ArrayList<ComponentMessageHolder> compMsgs = new ArrayList<ComponentMessageHolder>();
        List<ServiceUnitInfo> suList = this.getServiceUnitList(saName, target);
        for (ServiceUnitInfo suInfo : suList) {
            ComponentMessageHolder compMsg = new ComponentMessageHolder(MessageBuilder.MessageType.INFO.toString());
            compMsg.setComponentName(suInfo.getTargetComponent());
            compMsg.setTaskName(taskId);
            compMsg.setTaskResult(MessageBuilder.TaskResult.SUCCESS.toString());
            compMsgs.add(compMsg);
        }
        return this.mMsgBuilder.buildFrameworkMessage(taskId, MessageBuilder.TaskResult.SUCCESS, compMsgs);
    }

    private ServiceAssemblyState getServiceAssemblyState(String saName) {
        ServiceAssemblyState saState = ServiceAssemblyState.UNKNOWN;
        try {
            String state = this.getState(saName);
            saState = ServiceAssemblyState.valueOfDeploymentServiceState(state);
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
        }
        return saState;
    }

    private void performJavaEEProcessing(String saName, String operation) throws ManagementException {
        if (this.isComponentInstalled(JAVA_EE_SE)) {
            ServiceAssemblyInfo saInfo;
            ArrayList<ServiceUnitInfo> suList = new ArrayList<ServiceUnitInfo>();
            ArrayList<ServiceUnitInfo> suSccssList = new ArrayList<ServiceUnitInfo>();
            try {
                saInfo = this.getRegistry().getServiceAssemblyQuery("domain").getServiceAssemblyInfo(saName);
            }
            catch (RegistryException regEx) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)regEx)));
                return;
            }
            for (ServiceUnitInfo suInfo : saInfo.getServiceUnitList()) {
                if (!JAVA_EE_SE.equals(suInfo.getTargetComponent())) continue;
                suList.add(suInfo);
            }
            if (suList.size() > 0) {
                this.autoStartComponent(JAVA_EE_SE, this.mPlatform.getAdminServerName());
            }
            for (ServiceUnitInfo suInfo : suList) {
                String suPath = this.getRegistry().getRepository().findArchive(ArchiveType.SERVICE_UNIT, saName + "/" + suInfo.getName());
                try {
                    String result = this.mInterceptor.performAction(operation, saName, suInfo.getName(), suPath, this.mTarget);
                    this.mLog.log(Level.FINER, "ApplicationInterceptor response for service assembly {0} : {1}", new Object[]{saName, result});
                    suSccssList.add(suInfo);
                }
                catch (Exception ex) {
                    if (operation.equals(DEPLOY) || operation.equals(START)) {
                        this.undoJavaEEProcessing(operation, saName, suSccssList);
                        throw new ManagementException(this.mMsgBuilder.buildFrameworkMessage(operation, MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, ex.getMessage(), new String[0], null));
                    }
                    this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_APPLICATION_INTERCEPTOR_ERROR", operation, saName, suInfo.getName(), ex.toString()));
                }
            }
        }
    }

    private void undoJavaEEProcessing(String operation, String saName, List<ServiceUnitInfo> suSccssList) {
        if (operation.equals(DEPLOY)) {
            String rollBackOperation = UNDEPLOY;
            for (ServiceUnitInfo suInfo : suSccssList) {
                String suPath = this.getRegistry().getRepository().findArchive(ArchiveType.SERVICE_UNIT, saName + "/" + suInfo.getName());
                if (suPath == null) continue;
                try {
                    String result = this.mInterceptor.performAction(rollBackOperation, saName, suInfo.getName(), suPath, this.mTarget);
                }
                catch (Exception ex) {
                    this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_APPLICATION_INTERCEPTOR_ROLLBACK_ERROR", operation, saName, suInfo.getName(), ex.toString()));
                }
            }
        }
    }

    private String getStateFromAllTargets(String saName) throws ManagementException {
        List<String> targets = this.getAllTargets();
        ArrayList<ServiceAssemblyState> states = new ArrayList<ServiceAssemblyState>();
        for (String target : targets) {
            try {
                ObjectName facadeDeploymentSvcMBean = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target);
                String state = (String)this.mMBeanSvr.invoke(facadeDeploymentSvcMBean, "getState", new Object[]{saName}, new String[]{"java.lang.String"});
                states.add(ServiceAssemblyState.valueOfDeploymentServiceState(state));
                this.mLog.log(Level.FINER, "The state of service assembly  {0} on target {1} is {2}", new Object[]{saName, target, state});
            }
            catch (Exception ex) {
                states.add(ServiceAssemblyState.UNKNOWN);
            }
        }
        this.mLog.log(Level.FINER, "The state of service assembly  {0} on targets {1} is {2}", new Object[]{saName, targets.toString(), states});
        ServiceAssemblyState effState = ServiceAssemblyState.getEffectiveServiceAssemblyState(states);
        return ServiceAssemblyState.convertState(effState);
    }

    private String getServiceUnitStateFromAllTargets(String componentName, String serviceUnitName) throws ManagementException {
        List<String> targets = this.getAllTargets();
        ArrayList<ServiceUnitState> states = new ArrayList<ServiceUnitState>();
        for (String target : targets) {
            try {
                ObjectName facadeDeploymentSvcMBean = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target);
                String state = (String)this.mMBeanSvr.invoke(facadeDeploymentSvcMBean, "getServiceUnitState", new Object[]{componentName, serviceUnitName}, new String[]{"java.lang.String", "java.lang.String"});
                states.add(ServiceUnitState.valueOfDeploymentServiceState(state));
                this.mLog.log(Level.FINER, "The state of service unit  {0} deployed to component {1} on target {2} is {3}", new Object[]{serviceUnitName, componentName, target, state});
            }
            catch (Exception ex) {
                states.add(ServiceUnitState.UNKNOWN);
            }
        }
        this.mLog.log(Level.FINER, "The state of service unit  {0} deployed to component{1} on targets {2} is {3}", new Object[]{serviceUnitName, componentName, targets.toString(), states});
        ServiceUnitState effState = ServiceUnitState.getEffectiveServiceAssemblyState(states);
        return ServiceUnitState.convertState(effState);
    }

    private void autoStartComponent(String componentName, String targetName) throws ManagementException {
        ComponentType compType = this.getComponentType(componentName);
        if (compType != null) {
            ObjectName facadeComponentLCMBean = null;
            facadeComponentLCMBean = this.mMBeanNames.getComponentMBeanName(componentName, compType, MBeanNames.ComponentServiceType.ComponentLifeCycle, targetName);
            try {
                String state = (String)this.mMBeanSvr.getAttribute(facadeComponentLCMBean, CURRENT_STATE);
                if (ComponentState.valueOfLifeCycleState(state).equals((Object)ComponentState.STARTED)) {
                    this.mLog.log(Level.FINER, "Component {0} is already started.", componentName);
                    return;
                }
                this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_CHANGING_COMPONENT_STATE_ON_INSTANCE", START, componentName, targetName));
                this.mLog.info(this.mTranslator.getString("JBI_ADMIN_AUTO_START_COMPONENT", componentName, targetName));
                this.mMBeanSvr.invoke(facadeComponentLCMBean, START, new Object[0], new String[0]);
            }
            catch (Exception ex) {
                this.mLog.fine(MessageHelper.getMsgString(ex));
                return;
            }
        }
    }

    public boolean isServiceAssemblyDeployedInInstance(String saName, String instanceName) throws ManagementException {
        try {
            String[] saNames;
            for (String saName1 : saNames = (String[])this.invokeRemoteOperation(this.getRemotedeploymentServiceObjectName(instanceName), "getDeployedServiceAssemblies", new Object[0], new String[0], instanceName)) {
                if (!saName1.equals(saName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
            throw new ManagementException(ex.getMessage());
        }
        return false;
    }

    private void autoStartComponents(String saName) throws ManagementException {
        List<String> comps = this.getTargetComponents("domain", saName);
        for (String compName : comps) {
            if (!this.mEnvCtx.isStartOnDeployEnabled()) continue;
            this.autoStartComponent(compName, this.mTarget);
        }
    }

    private String[] getDeployedServiceAssembliesForComponent(String target, String componentName) throws Exception {
        ArrayList<String> sas = new ArrayList<String>();
        ComponentInfo compInfo = this.getComponentQuery(target).getComponentInfo(componentName);
        if (compInfo != null) {
            List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
            for (ServiceUnitInfo suInfo : suList) {
                sas.add(suInfo.getServiceAssemblyName());
            }
        }
        return sas.toArray(new String[sas.size()]);
    }
}

